/*
 * *************************************************************************
 *  BrowserFragment.java
 * **************************************************************************
 *  Copyright © 2015 VLC authors and VideoLAN
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *  ***************************************************************************
 */

package org.videolan.vlc.gui;

import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBarActivity;

import org.videolan.vlc.widget.SwipeRefreshLayout;

public abstract class BrowserFragment extends Fragment {

    protected SwipeRefreshLayout mSwipeRefreshLayout;
    protected volatile boolean mReadyToDisplay = true;

    protected void setReadyToDisplay(boolean ready){}
    protected void display(){}

    protected abstract String getTitle();
    public abstract void clear();
    public void onStart(){
        super.onStart();
        ((ActionBarActivity) getActivity()).getSupportActionBar().setTitle(getTitle());
        getActivity().supportInvalidateOptionsMenu();
    }
}
