/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.sound;

import java.io.IOException;
import javax.media.Control;
import javax.media.ControllerErrorEvent;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import org.bluray.net.BDLocator;
import org.davic.net.InvalidLocatorException;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.media.content.BDHandler;
import org.videolan.media.content.control.MediaTimePositionControlImpl;
import org.videolan.media.content.control.OverallGainControlImpl;
import org.videolan.media.content.control.PanningControlImpl;

public class Handler
extends BDHandler {
    private BDLocator locator;
    private org.videolan.media.protocol.dripfeed.DataSource source = null;

    public Handler() {
        this.controls = new Control[3];
        this.controls[0] = new MediaTimePositionControlImpl(this);
        this.controls[1] = new OverallGainControlImpl(this);
        this.controls[2] = new PanningControlImpl(this);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.source = new org.videolan.media.protocol.dripfeed.DataSource(source.getLocator());
        if (source.getLocator() == null) {
            throw new IncompatibleSourceException();
        }
        try {
            this.locator = new BDLocator(source.getLocator().toExternalForm());
        }
        catch (InvalidLocatorException e) {
            throw new IncompatibleSourceException();
        }
    }

    public Time getDuration() {
        Logger.unimplemented("Handler", "getDuration");
        long duration = 1L;
        return new Time((double)duration * 1.1111111111111112E-5);
    }

    protected ControllerErrorEvent doPrefetch() {
        return super.doPrefetch();
    }

    protected ControllerErrorEvent doStart(Time at) {
        ControllerErrorEvent err = super.doStart(at);
        if (err != null) {
            return err;
        }
        if (!this.locator.isSoundItem()) {
            System.err.println("no sound effect in " + this.locator);
        } else {
            int id = this.locator.getSoundId();
            Libbluray.soundEffect(id);
            this.statusEvent(9, id);
        }
        return null;
    }

    protected BDLocator getLocator() {
        return this.locator;
    }
}

