/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.resources;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.Helper;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.SubBitmapAddEvent;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.ImageResource;
import vlcskineditor.resources.SubBitmapEditWindow;

public class SubBitmap
extends ImageResource
implements ActionListener {
    public int x;
    public int y;
    public int width;
    public int height;
    final int NBFRAMES_DEFAULT = 1;
    public int nbframes = 1;
    final int FPS_DEFAULT = 0;
    public int fps = 0;
    private Bitmap parent;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField width_tf;
    JTextField height_tf;
    JTextField nbframes_tf;
    JTextField fps_tf;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    JFileChooser fc;
    boolean created = false;
    SubBitmapEditWindow sbew = null;

    public SubBitmap(Node node, Skin skin, Bitmap bitmap) {
        this.type = Language.get("SUBBITMAP");
        this.s = skin;
        this.parent = bitmap;
        this.id = XML.getStringAttributeValue(node, "id", this.id);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.width = XML.getIntAttributeValue(node, "width", this.width);
        this.height = XML.getIntAttributeValue(node, "height", this.height);
        this.updateImage();
        this.created = true;
    }

    public SubBitmap(String string, Skin skin, Bitmap bitmap) {
        this.type = Language.get("SUBBITMAP");
        this.parent = bitmap;
        this.s = skin;
        this.id = XML.getValue(string, "id");
        this.x = XML.getIntValue(string, "x");
        this.y = XML.getIntValue(string, "y");
        this.width = XML.getIntValue(string, "width");
        this.height = XML.getIntValue(string, "height");
        this.created = true;
    }

    public SubBitmap(Skin skin, Bitmap bitmap) {
        this.type = Language.get("SUBBITMAP");
        this.s = skin;
        this.parent = bitmap;
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.x = 0;
        this.y = 0;
        this.width = 1;
        this.height = 1;
        this.showOptions();
    }

    public void updateImage() {
        if (this.parent.image != null) {
            this.image = this.parent.image.getSubimage(this.x, this.y, this.width, this.height);
        }
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.nbframes = Integer.parseInt(this.nbframes_tf.getText());
            this.fps = Integer.parseInt(this.fps_tf.getText());
            this.updateImage();
            this.s.updateResources();
            this.s.expandResource(this.id);
            SubBitmapAddEvent subBitmapAddEvent = new SubBitmapAddEvent(this.parent, this);
            this.s.m.hist.addEvent(subBitmapAddEvent);
            this.created = true;
        } else {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.nbframes = Integer.parseInt(this.nbframes_tf.getText());
            this.fps = Integer.parseInt(this.fps_tf.getText());
            this.updateImage();
            this.s.updateResources();
            this.s.expandResource(this.id);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_SBMP_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            this.id_tf.setToolTipText(Language.get("WIN_ITEM_ID_TIP").replaceAll("%t", this.type));
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_WIDTH"));
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_HEIGHT"));
            this.height_tf = new JTextField();
            this.height_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel6 = new JLabel(Language.get("WIN_BITMAP_NBFRAMES"));
            this.nbframes_tf = new JTextField();
            this.nbframes_tf.setDocument(new NumbersOnlyDocument(false));
            this.nbframes_tf.setToolTipText(Language.get("WIN_BITMAP_NBFRAMES_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_BITMAP_FPS"));
            this.fps_tf = new JTextField();
            this.fps_tf.setDocument(new NumbersOnlyDocument(false));
            this.fps_tf.setToolTipText(Language.get("WIN_BITMAP_FPS_TIP"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel8 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)jLabel);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel2);
            jPanel2.add(this.x_tf);
            this.x_tf.setPreferredSize(new Dimension(n2, this.x_tf.getPreferredSize().height));
            jPanel2.add(jLabel3);
            jPanel2.add(this.y_tf);
            this.y_tf.setPreferredSize(new Dimension(n2, this.y_tf.getPreferredSize().height));
            jPanel2.add(jLabel4);
            jPanel2.add(this.width_tf);
            this.width_tf.setPreferredSize(new Dimension(n2, this.width_tf.getPreferredSize().height));
            jPanel2.add(jLabel5);
            jPanel2.add(this.height_tf);
            this.height_tf.setPreferredSize(new Dimension(n2, this.height_tf.getPreferredSize().height));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_SBMP_BOUNDS")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel2, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.x_tf);
            springLayout2.putConstraint("North", (Component)jLabel3, 10, "South", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("North", (Component)jLabel4, 10, "South", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.width_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.width_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.width_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("North", (Component)jLabel5, 10, "South", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.height_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.height_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.height_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)jLabel5);
            this.frame.add(jPanel2);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.add(jLabel6);
            jPanel3.add(this.nbframes_tf);
            jPanel3.add(jLabel7);
            jPanel3.add(this.fps_tf);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_BITMAP_ANIMATION")));
            SpringLayout springLayout3 = new SpringLayout();
            jPanel3.setLayout(springLayout3);
            this.nbframes_tf.setPreferredSize(new Dimension(n2, this.nbframes_tf.getPreferredSize().height));
            springLayout3.putConstraint("North", (Component)jLabel6, 5, "North", (Component)jPanel3);
            springLayout3.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.nbframes_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout3.putConstraint("West", (Component)this.nbframes_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)jPanel3, 5, "East", (Component)this.nbframes_tf);
            springLayout3.putConstraint("North", (Component)jLabel7, 10, "South", (Component)jLabel6);
            springLayout3.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.fps_tf, 0, "VerticalCenter", (Component)jLabel7);
            springLayout3.putConstraint("West", (Component)this.fps_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)this.fps_tf, 0, "East", (Component)this.nbframes_tf);
            springLayout3.putConstraint("South", (Component)jPanel3, 10, "South", (Component)jLabel7);
            this.frame.add(jPanel3);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel8);
            SpringLayout springLayout4 = new SpringLayout();
            this.frame.setLayout(springLayout4);
            springLayout4.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)jPanel2, 5, "South", (Component)jPanel);
            springLayout4.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)jPanel3, 5, "South", (Component)jPanel2);
            springLayout4.putConstraint("West", (Component)jPanel3, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)jLabel8, 5, "South", (Component)jPanel3);
            springLayout4.putConstraint("West", (Component)jLabel8, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("East", (Component)jLabel8, 5, "East", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)this.ok_btn, 5, "South", (Component)jLabel8);
            springLayout4.putConstraint("North", (Component)this.cancel_btn, 5, "South", (Component)jLabel8);
            springLayout4.putConstraint("North", (Component)this.help_btn, 5, "South", (Component)jLabel8);
            springLayout4.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout4.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout4.putConstraint("South", (Component)this.frame.getContentPane(), 5, "South", (Component)this.ok_btn);
            springLayout4.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.nbframes_tf.setText(String.valueOf(this.nbframes));
        this.fps_tf.setText(String.valueOf(this.fps));
        this.frame.setVisible(true);
        this.sbew = new SubBitmapEditWindow(this.parent, this);
        this.x_tf.addKeyListener(this.sbew);
        this.y_tf.addKeyListener(this.sbew);
        this.width_tf.addKeyListener(this.sbew);
        this.height_tf.addKeyListener(this.sbew);
        this.frame.addWindowListener(this.sbew);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (this.width_tf.getText().length() < 1 || Integer.parseInt(this.width_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_WIDTH_INVALID_MSG"), Language.get("ERROR_WIDTH_INVALID_TITLE"), 1);
                return;
            }
            if (this.height_tf.getText().length() < 1 || Integer.parseInt(this.height_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_HEIGHT_INVALID_MSG"), Language.get("ERROR_HEIGHT_INVALID_TITLE"), 1);
                return;
            }
            if (Integer.parseInt(this.x_tf.getText()) + Integer.parseInt(this.width_tf.getText()) > this.parent.image.getWidth()) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_OUTSIDE_MSG"), Language.get("ERROR_OUTSIDE_TITLE"), 1);
                return;
            }
            if (Integer.parseInt(this.y_tf.getText()) + Integer.parseInt(this.height_tf.getText()) > this.parent.image.getHeight()) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_OUTSIDE_MSG"), Language.get("ERROR_OUTSIDE_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.destroyEditWindow();
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/res-subbitmap.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            this.destroyEditWindow();
            this.frame.dispose();
            this.frame = null;
            if (!this.created) {
                this.parent.SubBitmaps.remove(this);
            }
        }
    }

    public void destroyEditWindow() {
        this.sbew.frame.setVisible(false);
        this.x_tf.removeKeyListener(this.sbew);
        this.y_tf.removeKeyListener(this.sbew);
        this.height_tf.removeKeyListener(this.sbew);
        this.height_tf.removeKeyListener(this.sbew);
        this.frame.removeWindowListener(this.sbew);
        this.sbew.frame.dispose();
        this.sbew.frame = null;
        this.sbew = null;
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<SubBitmap id=\"" + this.id + "\" x=\"" + String.valueOf(this.x) + "\" y=\"" + String.valueOf(this.y) + "\"";
        string2 = string2 + " height=\"" + String.valueOf(this.height) + "\" width=\"" + String.valueOf(this.width) + "\"";
        if (this.nbframes != 1) {
            string2 = string2 + " nbframes=\"" + String.valueOf(this.nbframes) + "\"";
        }
        if (this.fps != 0) {
            string2 = string2 + " fps=\"" + String.valueOf(this.fps) + "\"";
        }
        string2 = string2 + "/>\n";
        return string2;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Bitmap: " + this.id);
        return defaultMutableTreeNode;
    }

    public Bitmap getParentBitmap() {
        return this.parent;
    }
}

