#define DEBUG

#include "../core/core.h"

#include "datalink.h"

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
C_DataLink::C_DataLink(handle hLogger) : C_Socket(hLogger)
{
	ASSERT(hLogger);

	m_hLog = hLogger;
	m_bLinkOk = false;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_DataLink::Init()
{
	int iRc = C_Socket::Open(SOCK_DGRAM, 0);

	if (!iRc)
	{
		int iPort = 10200;

		do
		{
			Sleep(1000);
			printf("Try to bind port %d\n", iPort);
			iRc = C_Socket::Bind("grognon", iPort++);
		} while ((iRc) && (iPort < 10300));
	}

	return iRc;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_DataLink::Connect(const C_String& strPeerName,
												const C_String& strPeerPort)
{
	m_bLinkOk = true;
	return C_Socket::Connect(strPeerName, strPeerPort);
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
C_String C_DataLink::GetLocalPort() const
{
	return C_Socket::GetLocalPort();
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_DataLink::Close()
{
	ASSERT(m_bLinkOk);
	m_bLinkOk = false;
	C_Socket::Close();
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_DataLink::WriteTsPacket(byte* pPacket)
{
	ASSERT(m_bLinkOk);
	Write(pPacket, 188);
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
bool C_DataLink::IsLinkOk()
{
	return m_bLinkOk;
}
