/* sane - Scanner Access Now Easy.
   Copyright (C) 2004, 2005 Anderson Lizardo <lizardo@users.sourceforge.net>

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.

   SANE backend for the Genius ColorPage-Vivid Pro II scanner.
*/

#ifndef geniusvp2_h
#define geniusvp2_h

#undef BACKEND_NAME
#define BACKEND_NAME    geniusvp2

#define DEBUG_NOT_STATIC

#include "../include/sane/sane.h"
#include "../include/sane/sanei_config.h"
#include "../include/sane/sanei_backend.h"

#define MM_PER_INCH 25.4

#define VP2_ASIC_ID 0xE1        /* EICI 091000 ASIC ID */
#define VP2_PRODUCT_ID 0x06     /* Genius ColorPage-Vivid Pro II product ID */

typedef enum
{
    param_none = 0,
    param_bool,
    param_int,
    param_fixed,
    param_string
}
parameter_type;

typedef enum
{
    opt_num_opts = 0,
    opt_mode_group,
    opt_mode,
    opt_depth,
    opt_resolution,
    opt_special_group,
    opt_print_options,
    opt_geometry_group,
    opt_tl_x,
    opt_tl_y,
    opt_br_x,
    opt_br_y,
    /* must come last: */
    num_options
}
geniusvp2_opts;

typedef struct VP2_Device
{
    struct VP2_Device *next;
    SANE_Device sane;
    SANE_Option_Descriptor opt[num_options];
    Option_Value val[num_options];
    SANE_Parameters params;
    SANE_String name;
    SANE_Int reader_pid;
    SANE_Int reader_fds;
    SANE_Int pipe;
    SANE_Word bytes_per_line;
    SANE_Word pixels_per_line;
    SANE_Word lines;
    SANE_Int bytes_total;
    SANE_Bool open;
    SANE_Bool scanning;
    SANE_Bool cancelled;
    SANE_Bool eof;
}
VP2_Device;

#endif /* geniusvp2_h */
