/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class UserPreferencesController
implements Controller {
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final HomeController homeController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView userPreferencesView;
    private String language;
    private LengthUnit unit;
    private String currency;
    private boolean valueAddedTaxEnabled;
    private boolean furnitureCatalogViewedInTree;
    private boolean navigationPanelVisible;
    private boolean editingIn3DViewEnabled;
    private boolean aerialViewCenteredOnSelectionEnabled;
    private boolean observerCameraSelectedAtChange;
    private boolean magnetismEnabled;
    private boolean rulersVisible;
    private boolean gridVisible;
    private String defaultFontName;
    private boolean furnitureViewedFromTop;
    private int furnitureModelIconSize;
    private boolean roomFloorColoredOrTextured;
    private TextureImage wallPattern;
    private TextureImage newWallPattern;
    private float newWallThickness;
    private float newWallHeight;
    private float newFloorThickness;
    private boolean checkUpdatesEnabled;
    private int autoSaveDelayForRecovery;
    private boolean autoSaveForRecoveryEnabled;

    public UserPreferencesController(UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(userPreferences, viewFactory, contentManager, null);
    }

    public UserPreferencesController(UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, HomeController homeController) {
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.homeController = homeController;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.userPreferencesView == null) {
            this.userPreferencesView = this.viewFactory.createUserPreferencesView(this.preferences, this);
        }
        return this.userPreferencesView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        this.setLanguage(this.preferences.getLanguage());
        this.setUnit(this.preferences.getLengthUnit());
        this.setCurrency(this.preferences.getCurrency());
        this.setValueAddedTaxEnabled(this.preferences.isValueAddedTaxEnabled());
        this.setFurnitureCatalogViewedInTree(this.preferences.isFurnitureCatalogViewedInTree());
        this.setNavigationPanelVisible(this.preferences.isNavigationPanelVisible());
        this.setEditingIn3DViewEnabled(this.preferences.isEditingIn3DViewEnabled());
        this.setAerialViewCenteredOnSelectionEnabled(this.preferences.isAerialViewCenteredOnSelectionEnabled());
        this.setObserverCameraSelectedAtChange(this.preferences.isObserverCameraSelectedAtChange());
        this.setMagnetismEnabled(this.preferences.isMagnetismEnabled());
        this.setRulersVisible(this.preferences.isRulersVisible());
        this.setGridVisible(this.preferences.isGridVisible());
        this.setDefaultFontName(this.preferences.getDefaultFontName());
        this.setFurnitureViewedFromTop(this.preferences.isFurnitureViewedFromTop());
        this.setFurnitureModelIconSize(this.preferences.getFurnitureModelIconSize());
        this.setRoomFloorColoredOrTextured(this.preferences.isRoomFloorColoredOrTextured());
        this.setWallPattern(this.preferences.getWallPattern());
        this.setNewWallPattern(this.preferences.getNewWallPattern());
        float f = this.getUnit().getMinimumLength();
        float f2 = this.getUnit().getMaximumLength();
        this.setNewWallThickness(Math.min(Math.max(f, this.preferences.getNewWallThickness()), f2 / 10.0f));
        this.setNewWallHeight(Math.min(Math.max(f, this.preferences.getNewWallHeight()), f2));
        this.setNewFloorThickness(Math.min(Math.max(f, this.preferences.getNewFloorThickness()), f2 / 10.0f));
        this.setCheckUpdatesEnabled(this.preferences.isCheckUpdatesEnabled());
        this.setAutoSaveDelayForRecovery(this.preferences.getAutoSaveDelayForRecovery());
        this.setAutoSaveForRecoveryEnabled(this.preferences.getAutoSaveDelayForRecovery() > 0);
    }

    public boolean isPropertyEditable(Property property) {
        switch (property.ordinal()) {
            case 0: {
                return this.preferences.isLanguageEditable();
            }
        }
        return true;
    }

    public void setLanguage(String string) {
        if (string != this.language) {
            String string2 = this.language;
            this.language = string;
            this.propertyChangeSupport.firePropertyChange(Property.LANGUAGE.name(), string2, string);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setUnit(LengthUnit lengthUnit) {
        if (lengthUnit != this.unit) {
            LengthUnit lengthUnit2 = this.unit;
            this.unit = lengthUnit;
            this.propertyChangeSupport.firePropertyChange(Property.UNIT.name(), (Object)lengthUnit2, (Object)lengthUnit);
        }
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public void setCurrency(String string) {
        if (string != this.currency) {
            String string2 = this.currency;
            this.currency = string;
            this.propertyChangeSupport.firePropertyChange(Property.CURRENCY.name(), string2, string);
            if (string == null) {
                this.setValueAddedTaxEnabled(false);
            }
        }
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setValueAddedTaxEnabled(boolean bl) {
        if (this.valueAddedTaxEnabled != bl) {
            this.valueAddedTaxEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VALUE_ADDED_TAX_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isValueAddedTaxEnabled() {
        return this.valueAddedTaxEnabled;
    }

    public void setFurnitureCatalogViewedInTree(boolean bl) {
        if (this.furnitureCatalogViewedInTree != bl) {
            this.furnitureCatalogViewedInTree = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_CATALOG_VIEWED_IN_TREE.name(), !bl, bl);
        }
    }

    public boolean isFurnitureCatalogViewedInTree() {
        return this.furnitureCatalogViewedInTree;
    }

    public void setNavigationPanelVisible(boolean bl) {
        if (this.navigationPanelVisible != bl) {
            this.navigationPanelVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAVIGATION_PANEL_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isNavigationPanelVisible() {
        return this.navigationPanelVisible;
    }

    public void setEditingIn3DViewEnabled(boolean bl) {
        if (bl != this.editingIn3DViewEnabled) {
            this.editingIn3DViewEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDITING_IN_3D_VIEW_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isEditingIn3DViewEnabled() {
        return this.editingIn3DViewEnabled;
    }

    public void setAerialViewCenteredOnSelectionEnabled(boolean bl) {
        if (bl != this.aerialViewCenteredOnSelectionEnabled) {
            this.aerialViewCenteredOnSelectionEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isAerialViewCenteredOnSelectionEnabled() {
        return this.aerialViewCenteredOnSelectionEnabled;
    }

    public void setObserverCameraSelectedAtChange(boolean bl) {
        if (bl != this.observerCameraSelectedAtChange) {
            this.observerCameraSelectedAtChange = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OBSERVER_CAMERA_SELECTED_AT_CHANGE.name(), !bl, bl);
        }
    }

    public boolean isObserverCameraSelectedAtChange() {
        return this.observerCameraSelectedAtChange;
    }

    public void setMagnetismEnabled(boolean bl) {
        if (bl != this.magnetismEnabled) {
            this.magnetismEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MAGNETISM_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isMagnetismEnabled() {
        return this.magnetismEnabled;
    }

    public void setRulersVisible(boolean bl) {
        if (bl != this.rulersVisible) {
            this.rulersVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RULERS_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isRulersVisible() {
        return this.rulersVisible;
    }

    public void setGridVisible(boolean bl) {
        if (bl != this.gridVisible) {
            this.gridVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.GRID_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setDefaultFontName(String string) {
        if (!(string == this.defaultFontName || string != null && string.equals(this.defaultFontName))) {
            String string2 = this.defaultFontName;
            this.defaultFontName = string;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_FONT_NAME.name(), string2, string);
        }
    }

    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public void setFurnitureViewedFromTop(boolean bl) {
        if (this.furnitureViewedFromTop != bl) {
            this.furnitureViewedFromTop = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_VIEWED_FROM_TOP.name(), !bl, bl);
        }
    }

    public boolean isFurnitureViewedFromTop() {
        return this.furnitureViewedFromTop;
    }

    public void setFurnitureModelIconSize(int n) {
        if (n != this.furnitureModelIconSize) {
            int n2 = this.furnitureModelIconSize;
            this.furnitureModelIconSize = n;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_MODEL_ICON_SIZE.name(), n2, n);
        }
    }

    public int getFurnitureModelIconSize() {
        return this.furnitureModelIconSize;
    }

    public void setRoomFloorColoredOrTextured(boolean bl) {
        if (this.roomFloorColoredOrTextured != bl) {
            this.roomFloorColoredOrTextured = bl;
            this.propertyChangeSupport.firePropertyChange(Property.ROOM_FLOOR_COLORED_OR_TEXTURED.name(), !bl, bl);
        }
    }

    public boolean isRoomFloorColoredOrTextured() {
        return this.roomFloorColoredOrTextured;
    }

    public void setWallPattern(TextureImage textureImage) {
        if (this.wallPattern != textureImage) {
            TextureImage textureImage2 = this.wallPattern;
            this.wallPattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_PATTERN.name(), textureImage2, textureImage);
        }
    }

    public TextureImage getWallPattern() {
        return this.wallPattern;
    }

    public void setNewWallPattern(TextureImage textureImage) {
        if (this.newWallPattern != textureImage) {
            TextureImage textureImage2 = this.newWallPattern;
            this.newWallPattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_PATTERN.name(), textureImage2, textureImage);
        }
    }

    public TextureImage getNewWallPattern() {
        return this.newWallPattern;
    }

    public void setNewWallThickness(float f) {
        if (f != this.newWallThickness) {
            float f2 = this.newWallThickness;
            this.newWallThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallThickness() {
        return this.newWallThickness;
    }

    public void setNewWallHeight(float f) {
        if (f != this.newWallHeight) {
            float f2 = this.newWallHeight;
            this.newWallHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallHeight() {
        return this.newWallHeight;
    }

    public void setNewFloorThickness(float f) {
        if (f != this.newFloorThickness) {
            float f2 = this.newFloorThickness;
            this.newFloorThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_FLOOR_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewFloorThickness() {
        return this.newFloorThickness;
    }

    public void setCheckUpdatesEnabled(boolean bl) {
        if (bl != this.checkUpdatesEnabled) {
            this.checkUpdatesEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CHECK_UPDATES_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isCheckUpdatesEnabled() {
        return this.checkUpdatesEnabled;
    }

    public void setAutoSaveDelayForRecovery(int n) {
        if (n != this.autoSaveDelayForRecovery) {
            float f = this.autoSaveDelayForRecovery;
            this.autoSaveDelayForRecovery = n;
            this.propertyChangeSupport.firePropertyChange(Property.AUTO_SAVE_DELAY_FOR_RECOVERY.name(), Float.valueOf(f), (Object)n);
        }
    }

    public int getAutoSaveDelayForRecovery() {
        return this.autoSaveDelayForRecovery;
    }

    public void setAutoSaveForRecoveryEnabled(boolean bl) {
        if (bl != this.autoSaveForRecoveryEnabled) {
            this.autoSaveForRecoveryEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AUTO_SAVE_FOR_RECOVERY_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isAutoSaveForRecoveryEnabled() {
        return this.autoSaveForRecoveryEnabled;
    }

    public void checkUpdates() {
        if (this.homeController != null) {
            this.homeController.checkUpdates(false);
        }
    }

    public boolean mayImportLanguageLibrary() {
        return this.homeController != null;
    }

    public void importLanguageLibrary() {
        if (this.homeController != null) {
            this.homeController.importLanguageLibrary();
        }
    }

    public void resetDisplayedActionTips() {
        this.preferences.resetIgnoredActionTips();
    }

    public void modifyUserPreferences() {
        this.preferences.setLanguage(this.getLanguage());
        this.preferences.setUnit(this.getUnit());
        this.preferences.setCurrency(this.getCurrency());
        this.preferences.setValueAddedTaxEnabled(this.isValueAddedTaxEnabled());
        this.preferences.setFurnitureCatalogViewedInTree(this.isFurnitureCatalogViewedInTree());
        this.preferences.setNavigationPanelVisible(this.isNavigationPanelVisible());
        this.preferences.setEditingIn3DViewEnabled(this.isEditingIn3DViewEnabled());
        this.preferences.setAerialViewCenteredOnSelectionEnabled(this.isAerialViewCenteredOnSelectionEnabled());
        this.preferences.setObserverCameraSelectedAtChange(this.isObserverCameraSelectedAtChange());
        this.preferences.setMagnetismEnabled(this.isMagnetismEnabled());
        this.preferences.setRulersVisible(this.isRulersVisible());
        this.preferences.setGridVisible(this.isGridVisible());
        this.preferences.setDefaultFontName(this.getDefaultFontName());
        this.preferences.setFurnitureViewedFromTop(this.isFurnitureViewedFromTop());
        this.preferences.setFurnitureModelIconSize(this.getFurnitureModelIconSize());
        this.preferences.setFloorColoredOrTextured(this.isRoomFloorColoredOrTextured());
        this.preferences.setWallPattern(this.getWallPattern());
        this.preferences.setNewWallPattern(this.getNewWallPattern());
        this.preferences.setNewWallThickness(this.getNewWallThickness());
        this.preferences.setNewWallHeight(this.getNewWallHeight());
        this.preferences.setNewFloorThickness(this.getNewFloorThickness());
        this.preferences.setCheckUpdatesEnabled(this.isCheckUpdatesEnabled());
        this.preferences.setAutoSaveDelayForRecovery(this.isAutoSaveForRecoveryEnabled() ? this.getAutoSaveDelayForRecovery() : 0);
    }

    public static enum Property {
        LANGUAGE,
        UNIT,
        CURRENCY,
        VALUE_ADDED_TAX_ENABLED,
        MAGNETISM_ENABLED,
        RULERS_VISIBLE,
        GRID_VISIBLE,
        DEFAULT_FONT_NAME,
        FURNITURE_VIEWED_FROM_TOP,
        FURNITURE_MODEL_ICON_SIZE,
        ROOM_FLOOR_COLORED_OR_TEXTURED,
        WALL_PATTERN,
        NEW_WALL_PATTERN,
        NEW_WALL_THICKNESS,
        NEW_WALL_HEIGHT,
        NEW_FLOOR_THICKNESS,
        FURNITURE_CATALOG_VIEWED_IN_TREE,
        NAVIGATION_PANEL_VISIBLE,
        EDITING_IN_3D_VIEW_ENABLED,
        AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED,
        OBSERVER_CAMERA_SELECTED_AT_CHANGE,
        CHECK_UPDATES_ENABLED,
        AUTO_SAVE_DELAY_FOR_RECOVERY,
        AUTO_SAVE_FOR_RECOVERY_ENABLED;

    }
}

