/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslProvider;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.ssl.config.CertType;
import org.opensearch.security.ssl.util.SSLConfigConstants;

public class SslParameters {
    private final SslProvider provider;
    private final ClientAuth clientAuth;
    private final List<String> protocols;
    private final List<String> ciphers;
    private final boolean validateCertDNsOnReload;

    private SslParameters(SslProvider provider, ClientAuth clientAuth, List<String> protocols, List<String> ciphers, boolean validateCertDNsOnReload) {
        this.provider = provider;
        this.ciphers = ciphers;
        this.protocols = protocols;
        this.clientAuth = clientAuth;
        this.validateCertDNsOnReload = validateCertDNsOnReload;
    }

    public ClientAuth clientAuth() {
        return this.clientAuth;
    }

    public SslProvider provider() {
        return this.provider;
    }

    public List<String> allowedCiphers() {
        return this.ciphers;
    }

    public List<String> allowedProtocols() {
        return this.protocols;
    }

    public boolean shouldValidateNewCertDNs() {
        return this.validateCertDNsOnReload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslParameters that = (SslParameters)o;
        return this.provider == that.provider && Objects.equals(this.ciphers, that.ciphers) && Objects.equals(this.protocols, that.protocols);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.ciphers, this.protocols);
    }

    public static Loader loader(CertType certType, Settings settings) {
        return new Loader(certType, settings);
    }

    public static final class Loader {
        private static final Logger LOGGER = LogManager.getLogger(SslParameters.class);
        private final CertType certType;
        private final Settings sslConfigSettings;

        public Loader(CertType certType, Settings settings) {
            this.certType = certType;
            this.sslConfigSettings = settings.getByPrefix(certType.sslSettingPrefix());
        }

        private SslProvider provider() {
            return SslProvider.JDK;
        }

        private boolean validateCertDNsOnReload(Settings settings) {
            return settings.getAsBoolean("enforce_cert_reload_dn_verification", Boolean.valueOf(true));
        }

        private List<String> protocols(Settings settings) {
            List allowedProtocols = settings.getAsList("enabled_protocols", List.of(SSLConfigConstants.ALLOWED_SSL_PROTOCOLS));
            return this.jdkProtocols(allowedProtocols);
        }

        private List<String> jdkProtocols(List<String> allowedSslProtocols) {
            try {
                String[] supportedProtocols = SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
                LOGGER.debug("JVM supports the following {} protocols {}", (Object)supportedProtocols.length, (Object)supportedProtocols);
                return Stream.of(supportedProtocols).filter(allowedSslProtocols::contains).collect(Collectors.toList());
            }
            catch (NoSuchAlgorithmException e) {
                throw new OpenSearchException("Unable to determine supported protocols", (Throwable)e, new Object[0]);
            }
        }

        private List<String> ciphers(Settings settings) {
            Stream<String> allowedCiphers;
            List allowed = settings.getAsList("enabled_ciphers", List.of(SSLConfigConstants.ALLOWED_SSL_CIPHERS));
            try {
                String[] supportedCiphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
                LOGGER.debug("JVM supports the following {} ciphers {}", (Object)supportedCiphers.length, (Object)supportedCiphers);
                allowedCiphers = Stream.of(supportedCiphers).filter(allowed::contains);
            }
            catch (NoSuchAlgorithmException e) {
                throw new OpenSearchException("Unable to determine ciphers protocols", (Throwable)e, new Object[0]);
            }
            return allowedCiphers.sorted(String::compareTo).collect(Collectors.toList());
        }

        public SslParameters load() {
            ClientAuth clientAuth = this.certType == CertType.TRANSPORT || this.certType == CertType.TRANSPORT_CLIENT ? SSLConfigConstants.SECURITY_SSL_TRANSPORT_CLIENTAUTH_MODE_DEFAULT : ClientAuth.valueOf((String)this.sslConfigSettings.get("clientauth_mode", ClientAuth.OPTIONAL.name()).toUpperCase(Locale.ROOT));
            SslProvider provider = this.provider();
            SslParameters sslParameters = new SslParameters(provider, clientAuth, this.protocols(this.sslConfigSettings), this.ciphers(this.sslConfigSettings), this.validateCertDNsOnReload(this.sslConfigSettings));
            if (sslParameters.allowedProtocols().isEmpty()) {
                throw new OpenSearchSecurityException("No ssl protocols for " + this.certType.id() + " layer", new Object[0]);
            }
            if (sslParameters.allowedCiphers().isEmpty()) {
                throw new OpenSearchSecurityException("No valid cipher suites for " + this.certType.id() + " layer", new Object[0]);
            }
            return sslParameters;
        }
    }
}

