/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableToPointInTimeRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
    private static final SdkField<String> SOURCE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTableArn").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::sourceTableArn)).setter(RestoreTableToPointInTimeRequest.setter(Builder::sourceTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableArn").build()}).build();
    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTableName").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::sourceTableName)).setter(RestoreTableToPointInTimeRequest.setter(Builder::sourceTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()}).build();
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTableName").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::targetTableName)).setter(RestoreTableToPointInTimeRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLatestRestorableTime").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::useLatestRestorableTime)).setter(RestoreTableToPointInTimeRequest.setter(Builder::useLatestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build()}).build();
    private static final SdkField<Instant> RESTORE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreDateTime").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::restoreDateTime)).setter(RestoreTableToPointInTimeRequest.setter(Builder::restoreDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDateTime").build()}).build();
    private static final SdkField<String> BILLING_MODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingModeOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::billingModeOverrideAsString)).setter(RestoreTableToPointInTimeRequest.setter(Builder::billingModeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeOverride").build()}).build();
    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::globalSecondaryIndexOverride)).setter(RestoreTableToPointInTimeRequest.setter(Builder::globalSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalSecondaryIndexOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::localSecondaryIndexOverride)).setter(RestoreTableToPointInTimeRequest.setter(Builder::localSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::provisionedThroughputOverride)).setter(RestoreTableToPointInTimeRequest.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughputOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::onDemandThroughputOverride)).setter(RestoreTableToPointInTimeRequest.setter(Builder::onDemandThroughputOverride)).constructor(OnDemandThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughputOverride").build()}).build();
    private static final SdkField<SSESpecification> SSE_SPECIFICATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSESpecificationOverride").getter(RestoreTableToPointInTimeRequest.getter(RestoreTableToPointInTimeRequest::sseSpecificationOverride)).setter(RestoreTableToPointInTimeRequest.setter(Builder::sseSpecificationOverride)).constructor(SSESpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecificationOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_ARN_FIELD, SOURCE_TABLE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, RESTORE_DATE_TIME_FIELD, BILLING_MODE_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD, LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD, SSE_SPECIFICATION_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreTableToPointInTimeRequest.memberNameToFieldInitializer();
    private final String sourceTableArn;
    private final String sourceTableName;
    private final String targetTableName;
    private final Boolean useLatestRestorableTime;
    private final Instant restoreDateTime;
    private final String billingModeOverride;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexOverride;
    private final List<LocalSecondaryIndex> localSecondaryIndexOverride;
    private final ProvisionedThroughput provisionedThroughputOverride;
    private final OnDemandThroughput onDemandThroughputOverride;
    private final SSESpecification sseSpecificationOverride;

    private RestoreTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceTableArn = builder.sourceTableArn;
        this.sourceTableName = builder.sourceTableName;
        this.targetTableName = builder.targetTableName;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.restoreDateTime = builder.restoreDateTime;
        this.billingModeOverride = builder.billingModeOverride;
        this.globalSecondaryIndexOverride = builder.globalSecondaryIndexOverride;
        this.localSecondaryIndexOverride = builder.localSecondaryIndexOverride;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.onDemandThroughputOverride = builder.onDemandThroughputOverride;
        this.sseSpecificationOverride = builder.sseSpecificationOverride;
    }

    public final String sourceTableArn() {
        return this.sourceTableArn;
    }

    public final String sourceTableName() {
        return this.sourceTableName;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public final Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public final Instant restoreDateTime() {
        return this.restoreDateTime;
    }

    public final BillingMode billingModeOverride() {
        return BillingMode.fromValue(this.billingModeOverride);
    }

    public final String billingModeOverrideAsString() {
        return this.billingModeOverride;
    }

    public final boolean hasGlobalSecondaryIndexOverride() {
        return this.globalSecondaryIndexOverride != null && !(this.globalSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    public final List<GlobalSecondaryIndex> globalSecondaryIndexOverride() {
        return this.globalSecondaryIndexOverride;
    }

    public final boolean hasLocalSecondaryIndexOverride() {
        return this.localSecondaryIndexOverride != null && !(this.localSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    public final List<LocalSecondaryIndex> localSecondaryIndexOverride() {
        return this.localSecondaryIndexOverride;
    }

    public final ProvisionedThroughput provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final OnDemandThroughput onDemandThroughputOverride() {
        return this.onDemandThroughputOverride;
    }

    public final SSESpecification sseSpecificationOverride() {
        return this.sseSpecificationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexOverride() ? this.globalSecondaryIndexOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalSecondaryIndexOverride() ? this.localSecondaryIndexOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecificationOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableToPointInTimeRequest)) {
            return false;
        }
        RestoreTableToPointInTimeRequest other = (RestoreTableToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.sourceTableArn(), other.sourceTableArn()) && Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && Objects.equals(this.restoreDateTime(), other.restoreDateTime()) && Objects.equals(this.billingModeOverrideAsString(), other.billingModeOverrideAsString()) && this.hasGlobalSecondaryIndexOverride() == other.hasGlobalSecondaryIndexOverride() && Objects.equals(this.globalSecondaryIndexOverride(), other.globalSecondaryIndexOverride()) && this.hasLocalSecondaryIndexOverride() == other.hasLocalSecondaryIndexOverride() && Objects.equals(this.localSecondaryIndexOverride(), other.localSecondaryIndexOverride()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.onDemandThroughputOverride(), other.onDemandThroughputOverride()) && Objects.equals(this.sseSpecificationOverride(), other.sseSpecificationOverride());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTableToPointInTimeRequest").add("SourceTableArn", (Object)this.sourceTableArn()).add("SourceTableName", (Object)this.sourceTableName()).add("TargetTableName", (Object)this.targetTableName()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("RestoreDateTime", (Object)this.restoreDateTime()).add("BillingModeOverride", (Object)this.billingModeOverrideAsString()).add("GlobalSecondaryIndexOverride", this.hasGlobalSecondaryIndexOverride() ? this.globalSecondaryIndexOverride() : null).add("LocalSecondaryIndexOverride", this.hasLocalSecondaryIndexOverride() ? this.localSecondaryIndexOverride() : null).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("OnDemandThroughputOverride", (Object)this.onDemandThroughputOverride()).add("SSESpecificationOverride", (Object)this.sseSpecificationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceTableArn": {
                return Optional.ofNullable(clazz.cast(this.sourceTableArn()));
            }
            case "SourceTableName": {
                return Optional.ofNullable(clazz.cast(this.sourceTableName()));
            }
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "UseLatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableTime()));
            }
            case "RestoreDateTime": {
                return Optional.ofNullable(clazz.cast(this.restoreDateTime()));
            }
            case "BillingModeOverride": {
                return Optional.ofNullable(clazz.cast(this.billingModeOverrideAsString()));
            }
            case "GlobalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexOverride()));
            }
            case "LocalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexOverride()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "OnDemandThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughputOverride()));
            }
            case "SSESpecificationOverride": {
                return Optional.ofNullable(clazz.cast(this.sseSpecificationOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceTableArn", SOURCE_TABLE_ARN_FIELD);
        map.put("SourceTableName", SOURCE_TABLE_NAME_FIELD);
        map.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        map.put("UseLatestRestorableTime", USE_LATEST_RESTORABLE_TIME_FIELD);
        map.put("RestoreDateTime", RESTORE_DATE_TIME_FIELD);
        map.put("BillingModeOverride", BILLING_MODE_OVERRIDE_FIELD);
        map.put("GlobalSecondaryIndexOverride", GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD);
        map.put("LocalSecondaryIndexOverride", LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("OnDemandThroughputOverride", ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD);
        map.put("SSESpecificationOverride", SSE_SPECIFICATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreTableToPointInTimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String sourceTableArn;
        private String sourceTableName;
        private String targetTableName;
        private Boolean useLatestRestorableTime;
        private Instant restoreDateTime;
        private String billingModeOverride;
        private List<GlobalSecondaryIndex> globalSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private List<LocalSecondaryIndex> localSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private ProvisionedThroughput provisionedThroughputOverride;
        private OnDemandThroughput onDemandThroughputOverride;
        private SSESpecification sseSpecificationOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableToPointInTimeRequest model) {
            super(model);
            this.sourceTableArn(model.sourceTableArn);
            this.sourceTableName(model.sourceTableName);
            this.targetTableName(model.targetTableName);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.restoreDateTime(model.restoreDateTime);
            this.billingModeOverride(model.billingModeOverride);
            this.globalSecondaryIndexOverride(model.globalSecondaryIndexOverride);
            this.localSecondaryIndexOverride(model.localSecondaryIndexOverride);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.onDemandThroughputOverride(model.onDemandThroughputOverride);
            this.sseSpecificationOverride(model.sseSpecificationOverride);
        }

        public final String getSourceTableArn() {
            return this.sourceTableArn;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final Instant getRestoreDateTime() {
            return this.restoreDateTime;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final String getBillingModeOverride() {
            return this.billingModeOverride;
        }

        public final void setBillingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
        }

        @Override
        public final Builder billingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
            return this;
        }

        @Override
        public final Builder billingModeOverride(BillingMode billingModeOverride) {
            this.billingModeOverride(billingModeOverride == null ? null : billingModeOverride.toString());
            return this;
        }

        public final List<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexOverride() {
            List<GlobalSecondaryIndex.Builder> result = GlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexOverride(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexOverride);
        }

        @Override
        public final Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Arrays.asList(globalSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Stream.of(globalSecondaryIndexOverride).map(c -> (GlobalSecondaryIndex)((GlobalSecondaryIndex.Builder)GlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LocalSecondaryIndex.Builder> getLocalSecondaryIndexOverride() {
            List<LocalSecondaryIndex.Builder> result = LocalSecondaryIndexListCopier.copyToBuilder(this.localSecondaryIndexOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexOverride(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexOverride);
        }

        @Override
        public final Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copy(localSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(LocalSecondaryIndex ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Arrays.asList(localSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Stream.of(localSecondaryIndexOverride).map(c -> (LocalSecondaryIndex)((LocalSecondaryIndex.Builder)LocalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughput.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughputOverride() {
            return this.onDemandThroughputOverride != null ? this.onDemandThroughputOverride.toBuilder() : null;
        }

        public final void setOnDemandThroughputOverride(OnDemandThroughput.BuilderImpl onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride != null ? onDemandThroughputOverride.build() : null;
        }

        @Override
        public final Builder onDemandThroughputOverride(OnDemandThroughput onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride;
            return this;
        }

        public final SSESpecification.Builder getSseSpecificationOverride() {
            return this.sseSpecificationOverride != null ? this.sseSpecificationOverride.toBuilder() : null;
        }

        public final void setSseSpecificationOverride(SSESpecification.BuilderImpl sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride != null ? sseSpecificationOverride.build() : null;
        }

        @Override
        public final Builder sseSpecificationOverride(SSESpecification sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableToPointInTimeRequest build() {
            return new RestoreTableToPointInTimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
        public Builder sourceTableArn(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetTableName(String var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder restoreDateTime(Instant var1);

        public Builder billingModeOverride(String var1);

        public Builder billingModeOverride(BillingMode var1);

        public Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... var1);

        public Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> var1);

        public Builder localSecondaryIndexOverride(LocalSecondaryIndex ... var1);

        public Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughput var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughput.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder onDemandThroughputOverride(OnDemandThroughput var1);

        default public Builder onDemandThroughputOverride(Consumer<OnDemandThroughput.Builder> onDemandThroughputOverride) {
            return this.onDemandThroughputOverride((OnDemandThroughput)((OnDemandThroughput.Builder)OnDemandThroughput.builder().applyMutation(onDemandThroughputOverride)).build());
        }

        public Builder sseSpecificationOverride(SSESpecification var1);

        default public Builder sseSpecificationOverride(Consumer<SSESpecification.Builder> sseSpecificationOverride) {
            return this.sseSpecificationOverride((SSESpecification)((SSESpecification.Builder)SSESpecification.builder().applyMutation(sseSpecificationOverride)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

