/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetricsPerTableCopier;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteItemResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, BatchWriteItemResponse> {
    private static final SdkField<Map<String, List<WriteRequest>>> UNPROCESSED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UnprocessedItems").getter(BatchWriteItemResponse.getter(BatchWriteItemResponse::unprocessedItems)).setter(BatchWriteItemResponse.setter(Builder::unprocessedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WriteRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ItemCollectionMetrics>>> ITEM_COLLECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ItemCollectionMetrics").getter(BatchWriteItemResponse.getter(BatchWriteItemResponse::itemCollectionMetrics)).setter(BatchWriteItemResponse.setter(Builder::itemCollectionMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemCollectionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedCapacity").getter(BatchWriteItemResponse.getter(BatchWriteItemResponse::consumedCapacity)).setter(BatchWriteItemResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_ITEMS_FIELD, ITEM_COLLECTION_METRICS_FIELD, CONSUMED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchWriteItemResponse.memberNameToFieldInitializer();
    private final Map<String, List<WriteRequest>> unprocessedItems;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public final boolean hasUnprocessedItems() {
        return this.unprocessedItems != null && !(this.unprocessedItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<WriteRequest>> unprocessedItems() {
        return this.unprocessedItems;
    }

    public final boolean hasItemCollectionMetrics() {
        return this.itemCollectionMetrics != null && !(this.itemCollectionMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public final boolean hasConsumedCapacity() {
        return this.consumedCapacity != null && !(this.consumedCapacity instanceof SdkAutoConstructList);
    }

    public final List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedItems() ? this.unprocessedItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemCollectionMetrics() ? this.itemCollectionMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedCapacity() ? this.consumedCapacity() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse)((Object)obj);
        return this.hasUnprocessedItems() == other.hasUnprocessedItems() && Objects.equals(this.unprocessedItems(), other.unprocessedItems()) && this.hasItemCollectionMetrics() == other.hasItemCollectionMetrics() && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics()) && this.hasConsumedCapacity() == other.hasConsumedCapacity() && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"BatchWriteItemResponse").add("UnprocessedItems", this.hasUnprocessedItems() ? this.unprocessedItems() : null).add("ItemCollectionMetrics", this.hasItemCollectionMetrics() ? this.itemCollectionMetrics() : null).add("ConsumedCapacity", this.hasConsumedCapacity() ? this.consumedCapacity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedItems": {
                return Optional.ofNullable(clazz.cast(this.unprocessedItems()));
            }
            case "ItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionMetrics()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UnprocessedItems", UNPROCESSED_ITEMS_FIELD);
        map.put("ItemCollectionMetrics", ITEM_COLLECTION_METRICS_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteItemResponse, T> g) {
        return obj -> g.apply((BatchWriteItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics = DefaultSdkAutoConstructMap.getInstance();
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            super(model);
            this.unprocessedItems(model.unprocessedItems);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, List<WriteRequest.Builder>> getUnprocessedItems() {
            Map<String, List<WriteRequest.Builder>> result = BatchWriteItemRequestMapCopier.copyToBuilder(this.unprocessedItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest.BuilderImpl>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copyFromBuilder(unprocessedItems);
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final Map<String, List<ItemCollectionMetrics.Builder>> getItemCollectionMetrics() {
            Map<String, List<ItemCollectionMetrics.Builder>> result = ItemCollectionMetricsPerTableCopier.copyToBuilder(this.itemCollectionMetrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics.BuilderImpl>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copyFromBuilder(itemCollectionMetrics);
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final List<ConsumedCapacity.Builder> getConsumedCapacity() {
            List<ConsumedCapacity.Builder> result = ConsumedCapacityMultipleCopier.copyToBuilder(this.consumedCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchWriteItemResponse> {
        public Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);
    }
}

