/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplatePlacement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplatePlacement> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::availabilityZone)).setter(LaunchTemplatePlacement.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Affinity").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::affinity)).setter(LaunchTemplatePlacement.setter(Builder::affinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").unmarshallLocationName("affinity").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::groupName)).setter(LaunchTemplatePlacement.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostId").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::hostId)).setter(LaunchTemplatePlacement.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("hostId").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::tenancyAsString)).setter(LaunchTemplatePlacement.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<String> SPREAD_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpreadDomain").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::spreadDomain)).setter(LaunchTemplatePlacement.setter(Builder::spreadDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadDomain").unmarshallLocationName("spreadDomain").build()}).build();
    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostResourceGroupArn").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::hostResourceGroupArn)).setter(LaunchTemplatePlacement.setter(Builder::hostResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").unmarshallLocationName("hostResourceGroupArn").build()}).build();
    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionNumber").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::partitionNumber)).setter(LaunchTemplatePlacement.setter(Builder::partitionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").unmarshallLocationName("partitionNumber").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(LaunchTemplatePlacement.getter(LaunchTemplatePlacement::groupId)).setter(LaunchTemplatePlacement.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AFFINITY_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, TENANCY_FIELD, SPREAD_DOMAIN_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD, PARTITION_NUMBER_FIELD, GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplatePlacement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String affinity;
    private final String groupName;
    private final String hostId;
    private final String tenancy;
    private final String spreadDomain;
    private final String hostResourceGroupArn;
    private final Integer partitionNumber;
    private final String groupId;

    private LaunchTemplatePlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.partitionNumber = builder.partitionNumber;
        this.groupId = builder.groupId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String affinity() {
        return this.affinity;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final String spreadDomain() {
        return this.spreadDomain;
    }

    public final String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public final Integer partitionNumber() {
        return this.partitionNumber;
    }

    public final String groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.affinity());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplatePlacement)) {
            return false;
        }
        LaunchTemplatePlacement other = (LaunchTemplatePlacement)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.affinity(), other.affinity()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.spreadDomain(), other.spreadDomain()) && Objects.equals(this.hostResourceGroupArn(), other.hostResourceGroupArn()) && Objects.equals(this.partitionNumber(), other.partitionNumber()) && Objects.equals(this.groupId(), other.groupId());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplatePlacement").add("AvailabilityZone", (Object)this.availabilityZone()).add("Affinity", (Object)this.affinity()).add("GroupName", (Object)this.groupName()).add("HostId", (Object)this.hostId()).add("Tenancy", (Object)this.tenancyAsString()).add("SpreadDomain", (Object)this.spreadDomain()).add("HostResourceGroupArn", (Object)this.hostResourceGroupArn()).add("PartitionNumber", (Object)this.partitionNumber()).add("GroupId", (Object)this.groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Affinity": {
                return Optional.ofNullable(clazz.cast(this.affinity()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "SpreadDomain": {
                return Optional.ofNullable(clazz.cast(this.spreadDomain()));
            }
            case "HostResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.hostResourceGroupArn()));
            }
            case "PartitionNumber": {
                return Optional.ofNullable(clazz.cast(this.partitionNumber()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Affinity", AFFINITY_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("HostId", HOST_ID_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("SpreadDomain", SPREAD_DOMAIN_FIELD);
        map.put("HostResourceGroupArn", HOST_RESOURCE_GROUP_ARN_FIELD);
        map.put("PartitionNumber", PARTITION_NUMBER_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplatePlacement, T> g) {
        return obj -> g.apply((LaunchTemplatePlacement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String affinity;
        private String groupName;
        private String hostId;
        private String tenancy;
        private String spreadDomain;
        private String hostResourceGroupArn;
        private Integer partitionNumber;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplatePlacement model) {
            this.availabilityZone(model.availabilityZone);
            this.affinity(model.affinity);
            this.groupName(model.groupName);
            this.hostId(model.hostId);
            this.tenancy(model.tenancy);
            this.spreadDomain(model.spreadDomain);
            this.hostResourceGroupArn(model.hostResourceGroupArn);
            this.partitionNumber(model.partitionNumber);
            this.groupId(model.groupId);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAffinity() {
            return this.affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getSpreadDomain() {
            return this.spreadDomain;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public LaunchTemplatePlacement build() {
            return new LaunchTemplatePlacement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplatePlacement> {
        public Builder availabilityZone(String var1);

        public Builder affinity(String var1);

        public Builder groupName(String var1);

        public Builder hostId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder spreadDomain(String var1);

        public Builder hostResourceGroupArn(String var1);

        public Builder partitionNumber(Integer var1);

        public Builder groupId(String var1);
    }
}

