/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.IndexSearcher;

final class Disjunctions {
    Disjunctions() {
    }

    public static List<IntervalsSource> pullUp(List<IntervalsSource> sources, Function<List<IntervalsSource>, IntervalsSource> function) {
        ArrayList rewritten = new ArrayList();
        rewritten.add(new ArrayList());
        for (IntervalsSource source2 : sources) {
            List<IntervalsSource> disjuncts = Disjunctions.splitDisjunctions(source2);
            if (disjuncts.size() == 1) {
                rewritten.forEach(l -> l.add((IntervalsSource)disjuncts.get(0)));
                continue;
            }
            if (rewritten.size() * disjuncts.size() > IndexSearcher.getMaxClauseCount()) {
                throw new IllegalArgumentException("Too many disjunctions to expand");
            }
            ArrayList toAdd = new ArrayList();
            for (IntervalsSource disj : disjuncts) {
                for (List list : rewritten) {
                    ArrayList<IntervalsSource> l2 = new ArrayList<IntervalsSource>(list);
                    l2.add(disj);
                    toAdd.add(l2);
                }
            }
            rewritten = toAdd;
        }
        if (rewritten.size() == 1) {
            return Collections.singletonList(function.apply((List)rewritten.get(0)));
        }
        return rewritten.stream().map(function).collect(Collectors.toList());
    }

    public static List<IntervalsSource> pullUp(IntervalsSource source2, Function<IntervalsSource, IntervalsSource> function) {
        List<IntervalsSource> disjuncts = Disjunctions.splitDisjunctions(source2);
        if (disjuncts.size() == 1) {
            return Collections.singletonList(function.apply(disjuncts.get(0)));
        }
        return disjuncts.stream().map(function).collect(Collectors.toList());
    }

    private static List<IntervalsSource> splitDisjunctions(IntervalsSource source2) {
        ArrayList<IntervalsSource> singletons = new ArrayList<IntervalsSource>();
        ArrayList<IntervalsSource> nonSingletons = new ArrayList<IntervalsSource>();
        for (IntervalsSource disj : source2.pullUpDisjunctions()) {
            if (disj.minExtent() == 1) {
                singletons.add(disj);
                continue;
            }
            nonSingletons.add(disj);
        }
        ArrayList<IntervalsSource> split = new ArrayList<IntervalsSource>();
        if (singletons.size() > 0) {
            split.add(Intervals.or(singletons.toArray(new IntervalsSource[0])));
        }
        split.addAll(nonSingletons);
        return split;
    }
}

