/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

public class RangeMorpher {
    public static final String PROPERTY_MORPH_STARTED = "Morph Started";
    public static final String PROPERTY_MORPH_ENDED = "Morph Ended";
    public static final String PROPERTY_MORPH_RANGES = "Morph Ranges";
    private double position = 1.0;
    private int numSteps = 10;
    private int delay = 40;
    private int stepsLeft = this.numSteps;
    private Timer timer;
    private Range<?>[] ranges = null;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public RangeMorpher() {
    }

    public RangeMorpher(int numSteps, int delay) {
        this.numSteps = numSteps;
        this.stepsLeft = numSteps;
        this.delay = delay;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean isMorphing() {
        return this.position < 1.0;
    }

    public void morph(final Range<?>[] sourceRanges, final Range<?>[] destinationRanges) {
        this.stopAnimation();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeMorpher.this.stepsLeft--;
                RangeMorpher.this.position = (double)(RangeMorpher.this.numSteps - RangeMorpher.this.stepsLeft) / (double)RangeMorpher.this.numSteps;
                if (RangeMorpher.this.stepsLeft == 0) {
                    RangeMorpher.this.stopAnimation();
                    RangeMorpher.this.support.firePropertyChange(RangeMorpher.PROPERTY_MORPH_ENDED, RangeMorpher.this.ranges, destinationRanges);
                } else {
                    Range[] oldRanges = RangeMorpher.this.ranges;
                    RangeMorpher.access$402(RangeMorpher.this, RangeMorpher.this.createIntermediate(sourceRanges, destinationRanges, RangeMorpher.this.position));
                    RangeMorpher.this.support.firePropertyChange(RangeMorpher.PROPERTY_MORPH_RANGES, oldRanges, RangeMorpher.this.ranges);
                }
            }
        };
        this.timer = new Timer(this.delay, listener);
        this.timer.start();
        this.support.firePropertyChange(PROPERTY_MORPH_STARTED, null, sourceRanges);
    }

    Range<?>[] createIntermediate(Range<?>[] sources, Range<?>[] targets, double position) {
        Range[] ranges = new Range[sources.length];
        for (int i = 0; i < ranges.length; ++i) {
            if (!(sources[i] instanceof AbstractRange)) {
                throw new UnsupportedOperationException("Cannot morph " + sources[i].getClass().getName());
            }
            AbstractRange ar = (AbstractRange)sources[i];
            ranges[i] = ar.createIntermediate((AbstractRange)targets[i], position);
        }
        return ranges;
    }

    Range<?> createIntermediate(NumericRange source2, NumericRange target, double position) {
        double sourceMin = source2.minimum();
        double sourceMax = source2.maximum();
        double targetMin = target.minimum();
        double targetMax = target.maximum();
        double min2 = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        return new NumericRange(min2, max);
    }

    Range<?> createIntermediate(CategoryRange<?> source2, CategoryRange<?> target, double position) {
        double sourceMin = source2.minimum();
        double sourceMax = source2.maximum();
        double targetMin = target.minimum();
        double targetMax = target.maximum();
        double min2 = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        CategoryRange r = position < 0.5 ? new CategoryRange(source2) : new CategoryRange(target);
        r.setMinimum(min2);
        r.setMaximum(max);
        return r;
    }

    Range<?> createIntermediate(TimeRange source2, TimeRange target, double position) {
        double sourceMin = source2.minimum();
        double sourceMax = source2.maximum();
        double targetMin = target.minimum();
        double targetMax = target.maximum();
        double min2 = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        return new TimeRange((long)min2, (long)max);
    }

    private void stopAnimation() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.stepsLeft = this.numSteps;
        }
    }

    static /* synthetic */ Range[] access$402(RangeMorpher x0, Range[] x1) {
        x0.ranges = x1;
        return x1;
    }
}

