/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public final class UndoRedoSupport<E> {
    private TransactionList<E> txSource;
    private ListEventListener<E> txSourceListener = new TXSourceListener();
    private final CopyOnWriteArrayList<Listener> listenerList = new CopyOnWriteArrayList();
    private int ignoreListEvent = 0;
    private List<E> priorElements;

    private UndoRedoSupport(EventList<E> source2) {
        this.txSource = new TransactionList<E>(source2, false);
        this.txSource.addListEventListener(this.txSourceListener);
        this.priorElements = new ArrayList<E>(source2);
    }

    public void addUndoSupportListener(Listener l) {
        if (l != null) {
            this.listenerList.add(l);
        }
    }

    public void removeUndoSupportListener(Listener l) {
        if (l != null) {
            this.listenerList.remove(l);
        }
    }

    private void fireUndoableEditHappened(Edit edit) {
        List listenerListCopy = (List)this.listenerList.clone();
        ListIterator li = listenerListCopy.listIterator(listenerListCopy.size());
        while (li.hasPrevious()) {
            ((Listener)li.previous()).undoableEditHappened(edit);
        }
    }

    public static <E> UndoRedoSupport install(EventList<E> source2) {
        return new UndoRedoSupport<E>(source2);
    }

    public void uninstall() {
        this.txSource.dispose();
        this.txSource.removeListEventListener(this.txSourceListener);
        this.txSource = null;
        this.priorElements = null;
    }

    private final class UpdateEdit<E>
    extends AbstractSimpleEdit<E> {
        private final E oldValue;

        public UpdateEdit(EventList<E> source2, int index, E value, E oldValue) {
            super(source2, index, value);
            this.oldValue = oldValue;
        }

        @Override
        public void undoImpl() {
            this.source.set(this.index, this.oldValue);
        }

        @Override
        public void redoImpl() {
            this.source.set(this.index, this.value);
        }
    }

    private final class RemoveEdit<E>
    extends AbstractSimpleEdit<E> {
        public RemoveEdit(EventList<E> source2, int index, E value) {
            super(source2, index, value);
        }

        @Override
        public void undoImpl() {
            this.source.add(this.index, this.value);
        }

        @Override
        public void redoImpl() {
            this.source.remove(this.index);
        }
    }

    private final class AddEdit<E>
    extends AbstractSimpleEdit<E> {
        public AddEdit(EventList<E> source2, int index, E value) {
            super(source2, index, value);
        }

        @Override
        public void undoImpl() {
            this.source.remove(this.index);
        }

        @Override
        public void redoImpl() {
            this.source.add(this.index, this.value);
        }
    }

    private abstract class AbstractSimpleEdit<E>
    extends AbstractEdit {
        protected final EventList<E> source;
        protected final int index;
        protected final E value;

        protected AbstractSimpleEdit(EventList<E> source2, int index, E value) {
            this.source = source2;
            this.index = index;
            this.value = value;
        }
    }

    final class CompositeEdit
    extends AbstractEdit {
        private final List<Edit> edits;

        CompositeEdit() {
            this.edits = new ArrayList<Edit>();
        }

        void add(Edit edit) {
            this.edits.add(edit);
        }

        private boolean isEmpty() {
            return this.edits.isEmpty();
        }

        private Edit getSimplestEdit() {
            return this.edits.size() == 1 ? this.edits.get(0) : this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undoImpl() {
            UndoRedoSupport.this.txSource.beginEvent();
            try {
                ListIterator<Edit> i = this.edits.listIterator(this.edits.size());
                while (i.hasPrevious()) {
                    i.previous().undo();
                }
            }
            finally {
                UndoRedoSupport.this.txSource.commitEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redoImpl() {
            UndoRedoSupport.this.txSource.beginEvent();
            try {
                for (Edit edit : this.edits) {
                    edit.redo();
                }
            }
            finally {
                UndoRedoSupport.this.txSource.commitEvent();
            }
        }
    }

    private abstract class AbstractEdit
    implements Edit {
        protected boolean canUndo = true;

        private AbstractEdit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() {
            if (!this.canUndo()) {
                throw new IllegalStateException("The Edit is in an incorrect state for undoing");
            }
            UndoRedoSupport.this.ignoreListEvent++;
            try {
                this.undoImpl();
            }
            finally {
                UndoRedoSupport.this.ignoreListEvent--;
            }
            this.canUndo = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() {
            if (!this.canRedo()) {
                throw new IllegalStateException("The Edit is in an incorrect state for redoing");
            }
            UndoRedoSupport.this.ignoreListEvent++;
            try {
                this.redoImpl();
            }
            finally {
                UndoRedoSupport.this.ignoreListEvent--;
            }
            this.canUndo = true;
        }

        protected abstract void undoImpl();

        protected abstract void redoImpl();

        @Override
        public final boolean canUndo() {
            return this.canUndo;
        }

        @Override
        public final boolean canRedo() {
            return !this.canUndo;
        }
    }

    public static interface Edit {
        public void undo();

        public boolean canUndo();

        public void redo();

        public boolean canRedo();
    }

    public static interface Listener
    extends EventListener {
        public void undoableEditHappened(Edit var1);
    }

    private class TXSourceListener
    implements ListEventListener<E> {
        private TXSourceListener() {
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            if (UndoRedoSupport.this.ignoreListEvent > 0) {
                return;
            }
            CompositeEdit edit = new CompositeEdit();
            while (listChanges.next()) {
                Object newValue;
                int changeIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType == 2) {
                    Object inserted = UndoRedoSupport.this.txSource.get(changeIndex);
                    UndoRedoSupport.this.priorElements.add(changeIndex, inserted);
                    edit.add(new AddEdit(UndoRedoSupport.this.txSource, changeIndex, inserted));
                    continue;
                }
                if (changeType == 0) {
                    Object deleted = listChanges.getOldValue();
                    Object deletedElementFromPrivateCopy = UndoRedoSupport.this.priorElements.remove(changeIndex);
                    if (deleted == ListEvent.UNKNOWN_VALUE) {
                        deleted = deletedElementFromPrivateCopy;
                    }
                    edit.add(new RemoveEdit(UndoRedoSupport.this.txSource, changeIndex, deleted));
                    continue;
                }
                if (changeType != 1) continue;
                Object previousValue = listChanges.getOldValue();
                if (previousValue == ListEvent.UNKNOWN_VALUE) {
                    previousValue = UndoRedoSupport.this.priorElements.get(changeIndex);
                }
                if ((newValue = UndoRedoSupport.this.txSource.get(changeIndex)) == previousValue) continue;
                UndoRedoSupport.this.priorElements.set(changeIndex, newValue);
                edit.add(new UpdateEdit(UndoRedoSupport.this.txSource, changeIndex, newValue, previousValue));
            }
            if (!edit.isEmpty()) {
                UndoRedoSupport.this.fireUndoableEditHappened(edit.getSimplestEdit());
            }
        }
    }
}

