/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import tim.prune.function.srtm.SrtmSource;
import tim.prune.function.srtm.SrtmTile;

public class SrtmLowResSource
extends SrtmSource {
    private byte[] _tileData = null;
    private static final String URL_PREFIX = "https://srtm.kurviger.de/SRTM3/";
    private static final String[] CONTINENTS = new String[]{"", "Eurasia", "North_America", "Australia", "Islands", "South_America", "Africa"};

    @Override
    public int getTilePixels() {
        return 1201;
    }

    @Override
    public URL getUrl(SrtmTile srtmTile) {
        if (srtmTile == null) {
            return null;
        }
        if (this._tileData == null) {
            this._tileData = SrtmLowResSource.readDatFile();
            if (this._tileData == null) {
                System.err.println("Build error: resource srtmtiles.dat missing!");
                return null;
            }
        }
        URL uRL = null;
        int n = (srtmTile.getLatitude() + 59) * 360 + (srtmTile.getLongitude() + 180);
        try {
            byte by = this._tileData[n];
            if (by > 0) {
                try {
                    uRL = new URL(URL_PREFIX + CONTINENTS[by] + "/" + this.getFilename(srtmTile));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return uRL;
    }

    @Override
    public String getFilename(SrtmTile srtmTile) {
        return String.valueOf(srtmTile.getTileName()) + ".hgt.zip";
    }

    /*
     * Loose catch block
     */
    private static byte[] readDatFile() {
        block13: {
            InputStream inputStream;
            block12: {
                inputStream = null;
                inputStream = SrtmLowResSource.class.getResourceAsStream("/tim/prune/function/srtm/srtmtiles.dat");
                if (inputStream == null) break block12;
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                inputStream.close();
                byte[] byArray2 = byArray;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                return byArray2;
                catch (IOException iOException) {
                    try {
                        System.err.println("Exception trying to read srtmtiles.dat : " + iOException.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public SrtmSource.Result downloadTile(SrtmTile srtmTile) {
        URL uRL = this.getUrl(srtmTile);
        if (uRL == null) {
            return SrtmSource.Result.NOTHING_TO_DO;
        }
        File file = this.getCacheDir();
        if (file != null) {
            if (file.exists() && !file.isDirectory()) {
                return SrtmSource.Result.CACHE_FAILED;
            }
            if (!file.exists() && !file.mkdir()) {
                return SrtmSource.Result.CACHE_FAILED;
            }
        } else {
            return SrtmSource.Result.CACHE_FAILED;
        }
        InputStream inputStream = null;
        SrtmSource.Result result = SrtmSource.Result.NOTHING_TO_DO;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "GpsPrune v23");
            inputStream = uRLConnection.getInputStream();
            result = this.writeFileFromStream(uRL, inputStream) ? SrtmSource.Result.DOWNLOADED : SrtmSource.Result.DOWNLOAD_FAILED;
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage());
            result = SrtmSource.Result.DOWNLOAD_FAILED;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return result;
    }
}

