/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;

public abstract class Tooltip {
    public static final long DEFAULT_DELAY = 1000L;
    private final long delayMS;
    private volatile long alarmT1;
    private volatile boolean forced;
    private Shape tool;
    protected final int renderModes;
    protected final Vec4f backColor = new Vec4f(1.0f, 1.0f, 1.0f, 0.9f);
    protected final Vec4f frontColor = new Vec4f(0.2f, 0.2f, 0.2f, 1.0f);

    public String toString() {
        return "Tooltip[d " + this.delayMS + ", next " + this.alarmT1 + ", forced " + this.forced + "]";
    }

    protected Tooltip(Vec4f vec4f, Vec4f vec4f2, long l, int n) {
        this.delayMS = l;
        this.alarmT1 = 0L;
        this.forced = false;
        this.tool = null;
        this.renderModes = n;
        if (null != vec4f) {
            this.backColor.set(vec4f);
        }
        if (null != vec4f2) {
            this.frontColor.set(vec4f2);
        }
    }

    final void setTool(Shape shape) {
        this.tool = shape;
    }

    public final Shape getTool() {
        return this.tool;
    }

    public final boolean stop(boolean bl) {
        if (bl) {
            this.alarmT1 = 0L;
            this.forced = false;
            return true;
        }
        if (!this.forced) {
            this.alarmT1 = 0L;
            return true;
        }
        return false;
    }

    public final void start() {
        if (!this.forced && this.delayMS > 0L) {
            this.alarmT1 = Clock.currentMillis() + this.delayMS;
        }
    }

    public final void now() {
        this.forced = true;
        this.alarmT1 = Clock.currentMillis() - 1L;
    }

    public final boolean forced() {
        return this.forced;
    }

    public final boolean tick() {
        if (0L == this.alarmT1) {
            return false;
        }
        if (Clock.currentMillis() < this.alarmT1) {
            return false;
        }
        this.alarmT1 = 0L;
        this.forced = false;
        return true;
    }

    public AABBox getToolMvBounds(PMVMatrix4f pMVMatrix4f) {
        return this.getTool().getBounds().transform(pMVMatrix4f.getMv(), new AABBox());
    }

    public Vec2f getTipMvPosition(Scene scene, PMVMatrix4f pMVMatrix4f, float f, float f2) {
        return this.getTipMvPosition(scene, this.getToolMvBounds(pMVMatrix4f), f, f2);
    }

    public Vec2f getTipMvPosition(Scene scene, AABBox aABBox, float f, float f2) {
        AABBox aABBox2 = scene.getBounds();
        Vec2f vec2f = new Vec2f();
        if (aABBox.getCenter().x() - f / 2.0f < aABBox2.getLow().x()) {
            vec2f.setX(aABBox2.getLow().x());
        } else if (aABBox.getCenter().x() + f / 2.0f > aABBox2.getHigh().x()) {
            vec2f.setX(aABBox2.getHigh().x() - f);
        } else {
            vec2f.setX(aABBox.getCenter().x() - f / 2.0f);
        }
        if (aABBox.getCenter().y() + f2 <= aABBox2.getHigh().y()) {
            vec2f.setY(aABBox.getCenter().y());
        } else if (aABBox.getHigh().y() >= f2) {
            vec2f.setY(aABBox.getHigh().y() - f2);
        } else {
            vec2f.setY(aABBox2.getHigh().y() - f2);
        }
        return vec2f;
    }

    public Vec2f getTipMvPosition(Scene scene, Vec3f vec3f, float f, float f2) {
        AABBox aABBox = scene.getBounds();
        Vec2f vec2f = new Vec2f();
        if (vec3f.x() - f / 2.0f < aABBox.getLow().x()) {
            vec2f.setX(aABBox.getLow().x());
        } else if (vec3f.x() + f / 2.0f > aABBox.getHigh().x()) {
            vec2f.setX(aABBox.getHigh().x() - f);
        } else {
            vec2f.setX(vec3f.x() - f / 2.0f);
        }
        if (vec3f.y() + f2 <= aABBox.getHigh().y()) {
            vec2f.setY(vec3f.y());
        } else {
            vec2f.setY(aABBox.getHigh().y() - f2);
        }
        return vec2f;
    }

    public abstract Shape createTip(Scene var1, AABBox var2);

    public void destroyTip(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        shape.destroy(gL2ES2, regionRenderer);
    }
}

