/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.XBLEventSupport;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.bridge.Messages;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.ScriptingEnvironment;
import io.sf.carte.echosvg.bridge.Window;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeContext;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractElement;
import io.sf.carte.echosvg.dom.events.EventSupport;
import io.sf.carte.echosvg.dom.svg12.SVGGlobal;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.dom.util.TriplyIndexedTable;
import io.sf.carte.echosvg.script.Interpreter;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class SVG12ScriptingEnvironment
extends ScriptingEnvironment {
    public static final String HANDLER_SCRIPT_DESCRIPTION = "SVG12ScriptingEnvironment.constant.handler.script.description";
    protected TriplyIndexedTable handlerScriptingListeners;

    public SVG12ScriptingEnvironment(BridgeContext bridgeContext) {
        super(bridgeContext);
    }

    @Override
    protected void addDocumentListeners() {
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        this.domAttrModifiedListener = new DOMAttrModifiedListener();
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    @Override
    protected void removeDocumentListeners() {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    @Override
    protected void addScriptingListenersOn(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if ("http://www.w3.org/2000/svg".equals(string) && "handler".equals(string2)) {
            Object object;
            AbstractElement abstractElement = (AbstractElement)element.getParentNode();
            String string3 = element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            String string4 = "http://www.w3.org/2001/xml-events";
            if (string3.indexOf(58) != -1) {
                object = DOMUtilities.getPrefix((String)string3);
                string3 = DOMUtilities.getLocalName((String)string3);
                string4 = element.lookupNamespaceURI((String)object);
            }
            object = new HandlerScriptingEventListener(string4, string3, (AbstractElement)element);
            abstractElement.addEventListenerNS(string4, string3, (EventListener)object, false, null);
            if (this.handlerScriptingListeners == null) {
                this.handlerScriptingListeners = new TriplyIndexedTable();
            }
            this.handlerScriptingListeners.put((Object)string4, (Object)string3, (Object)element, object);
        }
        super.addScriptingListenersOn(element);
    }

    @Override
    protected void removeScriptingListenersOn(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if ("http://www.w3.org/2000/svg".equals(string) && "handler".equals(string2)) {
            Object object;
            AbstractElement abstractElement = (AbstractElement)element.getParentNode();
            String string3 = element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            String string4 = "http://www.w3.org/2001/xml-events";
            if (string3.indexOf(58) != -1) {
                object = DOMUtilities.getPrefix((String)string3);
                string3 = DOMUtilities.getLocalName((String)string3);
                string4 = element.lookupNamespaceURI((String)object);
            }
            object = (EventListener)this.handlerScriptingListeners.put((Object)string4, (Object)string3, (Object)element, null);
            abstractElement.removeEventListenerNS(string4, string3, (EventListener)object, false);
        }
        super.removeScriptingListenersOn(element);
    }

    @Override
    public Window createWindow(Interpreter interpreter, String string) {
        return new Global(interpreter, string);
    }

    protected class DOMAttrModifiedListener
    extends ScriptingEnvironment.DOMAttrModifiedListener {
        protected DOMAttrModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent((Event)event));
        }
    }

    protected class DOMNodeInsertedListener
    extends ScriptingEnvironment.DOMNodeInsertedListener {
        protected DOMNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent((Event)event));
        }
    }

    protected class DOMNodeRemovedListener
    extends ScriptingEnvironment.DOMNodeRemovedListener {
        protected DOMNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent((Event)event));
        }
    }

    protected class Global
    extends ScriptingEnvironment.Window
    implements SVGGlobal {
        public Global(Interpreter interpreter, String string) {
            super(interpreter, string);
        }

        public void startMouseCapture(EventTarget eventTarget, boolean bl, boolean bl2) {
            ((SVG12BridgeContext)SVG12ScriptingEnvironment.this.bridgeContext.getPrimaryBridgeContext()).startMouseCapture(eventTarget, bl, bl2);
        }

        public void stopMouseCapture() {
            ((SVG12BridgeContext)SVG12ScriptingEnvironment.this.bridgeContext.getPrimaryBridgeContext()).stopMouseCapture();
        }
    }

    protected class HandlerScriptingEventListener
    implements EventListener {
        protected String eventNamespaceURI;
        protected String eventType;
        protected AbstractElement handlerElement;

        public HandlerScriptingEventListener(String string, String string2, AbstractElement abstractElement) {
            this.eventNamespaceURI = string;
            this.eventType = string2;
            this.handlerElement = abstractElement;
        }

        @Override
        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getCurrentTarget());
            String string = this.handlerElement.getTextContent();
            if (string.length() == 0) {
                return;
            }
            DocumentLoader documentLoader = SVG12ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            AbstractDocument abstractDocument = (AbstractDocument)this.handlerElement.getOwnerDocument();
            int n = documentLoader.getLineNumber((Element)this.handlerElement);
            String string2 = Messages.formatMessage(SVG12ScriptingEnvironment.HANDLER_SCRIPT_DESCRIPTION, new Object[]{abstractDocument.getDocumentURI(), this.eventNamespaceURI, this.eventType, n});
            String string3 = this.handlerElement.getAttributeNS(null, "contentScriptType");
            if (string3.length() == 0) {
                Element element2 = element;
                while (!(element2 == null || "http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) && "svg".equals(element2.getLocalName()))) {
                    element2 = SVGUtilities.getParentElement(element2);
                }
                if (element2 == null) {
                    return;
                }
                string3 = element2.getAttributeNS(null, "contentScriptType");
            }
            SVG12ScriptingEnvironment.this.runEventHandler(string, event, string3, string2);
        }
    }
}

