/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korio.net;

import com.soywiz.kmem.ByteArrayBuilder;
import com.soywiz.korio.file.PathInfoKt;
import com.soywiz.korio.lang.Charset;
import com.soywiz.korio.lang.CharsetKt;
import com.soywiz.korio.lang.StringExtKt;
import com.soywiz.korio.lang.UTF8Kt;
import com.soywiz.korio.net.URL;
import com.soywiz.korio.util.StrReader;
import com.soywiz.krypto.encoding.Hex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001ABQ\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00104\u001a\u00020\fH\u00c6\u0003Jc\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u00020\fH\u00d6\u0001J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020\u0005J\b\u0010;\u001a\u00020\u0005H\u0016J\"\u0010<\u001a\u00060=j\u0002`>2\b\b\u0002\u0010?\u001a\u00020\u00032\f\b\u0002\u0010@\u001a\u00060=j\u0002`>R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u0013R\u001b\u0010\u0018\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0013\u0010 \u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R\u001b\u0010#\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0017\u001a\u0004\b$\u0010\u0013R\u0011\u0010&\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013R\u0013\u0010*\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0013\u00a8\u0006B"}, d2={"Lcom/soywiz/korio/net/URL;", "", "isOpaque", "", "scheme", "", "userInfo", "host", "path", "query", "fragment", "defaultPort", "", "(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getDefaultPort", "()I", "defaultSchemePort", "getDefaultSchemePort", "getFragment", "()Ljava/lang/String;", "fullUrl", "getFullUrl", "fullUrl$delegate", "Lkotlin/Lazy;", "fullUrlWithoutScheme", "getFullUrlWithoutScheme", "fullUrlWithoutScheme$delegate", "getHost", "isAbsolute", "()Z", "isHierarchical", "isSecureScheme", "password", "getPassword", "getPath", "pathWithQuery", "getPathWithQuery", "pathWithQuery$delegate", "port", "getPort", "getQuery", "getScheme", "user", "getUser", "getUserInfo", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "resolve", "toComponentString", "toString", "toUrlString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "includeScheme", "out", "Companion", "korio"})
public final class URL {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isOpaque;
    @Nullable
    private final String scheme;
    @Nullable
    private final String userInfo;
    @Nullable
    private final String host;
    @NotNull
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final String fragment;
    private final int defaultPort;
    @NotNull
    private final Lazy fullUrl$delegate;
    @NotNull
    private final Lazy fullUrlWithoutScheme$delegate;
    @NotNull
    private final Lazy pathWithQuery$delegate;
    private static final int DEFAULT_PORT;
    @NotNull
    private static final Regex schemeRegex;

    private URL(boolean isOpaque, String scheme, String userInfo, String host, String path2, String query, String fragment, int defaultPort) {
        this.isOpaque = isOpaque;
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.path = path2;
        this.query = query;
        this.fragment = fragment;
        this.defaultPort = defaultPort;
        this.fullUrl$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = URL.toUrlString$default(this.this$0, false, null, 3, null).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toUrlString().toString()");
                return string;
            }
        });
        this.fullUrlWithoutScheme$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = URL.toUrlString$default(this.this$0, false, null, 2, null).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toUrlString(includeScheme = false).toString()");
                return string;
            }
        });
        this.pathWithQuery$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ URL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getQuery() != null ? this.this$0.getPath() + '?' + this.this$0.getQuery() : this.this$0.getPath();
            }
        });
    }

    public final boolean isOpaque() {
        return this.isOpaque;
    }

    @Nullable
    public final String getScheme() {
        return this.scheme;
    }

    @Nullable
    public final String getUserInfo() {
        return this.userInfo;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getQuery() {
        return this.query;
    }

    @Nullable
    public final String getFragment() {
        return this.fragment;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @Nullable
    public final String getUser() {
        String string = this.userInfo;
        return string == null ? null : StringsKt.substringBefore$default(string, ':', null, 2, null);
    }

    @Nullable
    public final String getPassword() {
        String string = this.userInfo;
        return string == null ? null : StringsKt.substringAfter$default(string, ':', null, 2, null);
    }

    public final boolean isHierarchical() {
        return !this.isOpaque;
    }

    public final boolean isSecureScheme() {
        return Intrinsics.areEqual(this.scheme, "https") || Intrinsics.areEqual(this.scheme, "wss") || Intrinsics.areEqual(this.scheme, "ftps");
    }

    public final int getDefaultSchemePort() {
        return Companion.defaultPortForScheme(this.scheme);
    }

    public final int getPort() {
        return this.defaultPort == DEFAULT_PORT ? this.getDefaultSchemePort() : this.defaultPort;
    }

    @NotNull
    public final String getFullUrl() {
        Lazy lazy = this.fullUrl$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getFullUrlWithoutScheme() {
        Lazy lazy = this.fullUrlWithoutScheme$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getPathWithQuery() {
        Lazy lazy = this.pathWithQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final StringBuilder toUrlString(boolean includeScheme, @NotNull StringBuilder out2) {
        if (includeScheme && this.scheme != null) {
            out2.append(Intrinsics.stringPlus(this.scheme, ":"));
            if (!this.isOpaque) {
                out2.append("//");
            }
        }
        if (this.userInfo != null) {
            out2.append(Intrinsics.stringPlus(this.userInfo, "@"));
        }
        if (this.host != null) {
            out2.append(this.host);
        }
        if (this.getPort() != DEFAULT_PORT && this.getPort() != this.getDefaultSchemePort()) {
            out2.append(':').append(this.getPort());
        }
        out2.append(this.path);
        if (this.query != null) {
            out2.append(Intrinsics.stringPlus("?", this.query));
        }
        if (this.fragment != null) {
            out2.append(Intrinsics.stringPlus("#", this.fragment));
        }
        return out2;
    }

    public static /* synthetic */ StringBuilder toUrlString$default(URL uRL, boolean bl, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return uRL.toUrlString(bl, stringBuilder);
    }

    public final boolean isAbsolute() {
        return this.scheme != null;
    }

    @NotNull
    public String toString() {
        return this.getFullUrl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toComponentString() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object = new KProperty0[]{new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getScheme();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getUserInfo();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getHost();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getPath();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getQuery();
            }
        }, new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return ((URL)this.receiver).getFragment();
            }
        }};
        object = CollectionsKt.listOf(object);
        StringBuilder stringBuilder = new StringBuilder().append("URL(");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KProperty0 kProperty0 = (KProperty0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getName(), it.get()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, toComponentString.9.INSTANCE, 30, null)).append(')').toString();
    }

    @NotNull
    public final URL resolve(@NotNull URL path2) {
        return Companion.invoke(Companion.resolve(this.getFullUrl(), path2.getFullUrl()));
    }

    public final boolean component1() {
        return this.isOpaque;
    }

    @Nullable
    public final String component2() {
        return this.scheme;
    }

    @Nullable
    public final String component3() {
        return this.userInfo;
    }

    @Nullable
    public final String component4() {
        return this.host;
    }

    @NotNull
    public final String component5() {
        return this.path;
    }

    @Nullable
    public final String component6() {
        return this.query;
    }

    @Nullable
    public final String component7() {
        return this.fragment;
    }

    public final int component8() {
        return this.defaultPort;
    }

    @NotNull
    public final URL copy(boolean isOpaque, @Nullable String scheme, @Nullable String userInfo, @Nullable String host, @NotNull String path2, @Nullable String query, @Nullable String fragment, int defaultPort) {
        return new URL(isOpaque, scheme, userInfo, host, path2, query, fragment, defaultPort);
    }

    public static /* synthetic */ URL copy$default(URL uRL, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = uRL.isOpaque;
        }
        if ((n2 & 2) != 0) {
            string = uRL.scheme;
        }
        if ((n2 & 4) != 0) {
            string2 = uRL.userInfo;
        }
        if ((n2 & 8) != 0) {
            string3 = uRL.host;
        }
        if ((n2 & 0x10) != 0) {
            string4 = uRL.path;
        }
        if ((n2 & 0x20) != 0) {
            string5 = uRL.query;
        }
        if ((n2 & 0x40) != 0) {
            string6 = uRL.fragment;
        }
        if ((n2 & 0x80) != 0) {
            n = uRL.defaultPort;
        }
        return uRL.copy(bl, string, string2, string3, string4, string5, string6, n);
    }

    public int hashCode() {
        int n = this.isOpaque ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result2 = result2 * 31 + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        result2 = result2 * 31 + (this.host == null ? 0 : this.host.hashCode());
        result2 = result2 * 31 + this.path.hashCode();
        result2 = result2 * 31 + (this.query == null ? 0 : this.query.hashCode());
        result2 = result2 * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.defaultPort);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URL)) {
            return false;
        }
        URL uRL = (URL)other;
        if (this.isOpaque != uRL.isOpaque) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scheme, uRL.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userInfo, uRL.userInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.host, uRL.host)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.path, uRL.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.query, uRL.query)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fragment, uRL.fragment)) {
            return false;
        }
        return this.defaultPort == uRL.defaultPort;
    }

    public /* synthetic */ URL(boolean isOpaque, String scheme, String userInfo, String host, String path2, String query, String fragment, int defaultPort, DefaultConstructorMarker $constructor_marker) {
        this(isOpaque, scheme, userInfo, host, path2, query, fragment, defaultPort);
    }

    static {
        schemeRegex = new Regex("\\w+:");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\"\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0086\u0002JW\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/soywiz/korio/net/URL$Companion;", "", "()V", "DEFAULT_PORT", "", "getDEFAULT_PORT", "()I", "schemeRegex", "Lkotlin/text/Regex;", "decodeComponent", "", "s", "charset", "Lcom/soywiz/korio/lang/Charset;", "formUrlEncoded", "", "defaultPortForScheme", "scheme", "encodeComponent", "invoke", "Lcom/soywiz/korio/net/URL;", "url", "userInfo", "host", "path", "query", "fragment", "opaque", "port", "isAbsolute", "resolve", "base", "access", "korio"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_PORT() {
            return DEFAULT_PORT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int defaultPortForScheme(@Nullable String scheme) {
            String string = scheme;
            if (string == null) return -1;
            int n = -1;
            switch (string.hashCode()) {
                case 3153745: {
                    if (string.equals("ftps")) {
                        n = 1;
                    }
                    break;
                }
                case 101730: {
                    if (string.equals("ftp")) {
                        n = 2;
                    }
                    break;
                }
                case 118039: {
                    if (string.equals("wss")) {
                        n = 3;
                    }
                    break;
                }
                case 3213448: {
                    if (string.equals("http")) {
                        n = 4;
                    }
                    break;
                }
                case 99617003: {
                    if (string.equals("https")) {
                        n = 3;
                    }
                    break;
                }
                case 3804: {
                    if (string.equals("ws")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return 21;
                }
                case 1: {
                    return 990;
                }
                case 4: {
                    return 80;
                }
                case 3: {
                    return 443;
                }
                default: {
                    return -1;
                }
            }
        }

        @NotNull
        public final URL invoke(@Nullable String scheme, @Nullable String userInfo, @Nullable String host, @NotNull String path2, @Nullable String query, @Nullable String fragment, boolean opaque, int port) {
            return new URL(opaque, scheme, userInfo, host, path2, query, fragment, port, null);
        }

        public static /* synthetic */ URL invoke$default(Companion companion, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                n = companion.getDEFAULT_PORT();
            }
            return companion.invoke(string, string2, string3, string4, string5, string6, bl, n);
        }

        @NotNull
        public final URL invoke(@NotNull String url) {
            URL uRL;
            StrReader r = new StrReader(url, null, 0, 6, null);
            String schemeColon = r.tryRegex(schemeRegex);
            if (schemeColon != null) {
                String string;
                boolean isHierarchical = r.tryLit("//") != null;
                String nonScheme = r.readRemaining();
                String scheme = StringsKt.dropLast(schemeColon, 1);
                String nonFragment = StringsKt.substringBefore$default(nonScheme, '#', null, 2, null);
                String fragment = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(nonScheme, '#');
                String nonQuery = StringsKt.substringBefore$default(nonFragment, '?', null, 2, null);
                String query = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(nonFragment, '?');
                String authority = StringsKt.substringBefore$default(nonQuery, '/', null, 2, null);
                String path2 = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(nonQuery, '/');
                String hostWithPort = StringsKt.substringAfter$default(authority, '@', null, 2, null);
                String userInfo = com.soywiz.korio.util.StringExtKt.substringBeforeOrNull(authority, '@');
                String host = StringsKt.substringBefore$default(hostWithPort, ':', null, 2, null);
                String port = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(hostWithPort, ':');
                Companion companion = Companion;
                boolean bl = !isHierarchical;
                String it = string = host;
                boolean bl2 = false;
                String string2 = ((CharSequence)it).length() > 0 ? string : null;
                string = path2 != null ? Intrinsics.stringPlus("/", path2) : "";
                String string3 = port;
                Integer n = string3 == null ? null : StringsKt.toIntOrNull(string3);
                int n2 = n == null ? this.getDEFAULT_PORT() : n.intValue();
                uRL = companion.invoke(scheme, userInfo, string2, string, query, fragment, bl, n2);
            } else {
                String nonFragment = StringsKt.substringBefore$default(url, '#', null, 2, null);
                String fragment = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(url, '#');
                String path3 = StringsKt.substringBefore$default(nonFragment, '?', null, 2, null);
                String query = com.soywiz.korio.util.StringExtKt.substringAfterOrNull(nonFragment, '?');
                uRL = com.soywiz.korio.net.URL$Companion.invoke$default(Companion, null, null, null, path3, query, fragment, false, 0, 128, null);
            }
            return uRL;
        }

        public final boolean isAbsolute(@NotNull String url) {
            return new StrReader(url, null, 0, 6, null).tryRegex(schemeRegex) != null;
        }

        @NotNull
        public final String resolve(@NotNull String base, @NotNull String access2) {
            String string;
            if (this.isAbsolute(access2)) {
                string = access2;
            } else if (StringsKt.startsWith$default(access2, "/", false, 2, null)) {
                string = URL.copy$default(Companion.invoke(base), false, null, null, null, access2, null, null, 0, 239, null).getFullUrl();
            } else {
                URL $this$resolve_u24lambda_u2d1 = Companion.invoke(base);
                boolean bl = false;
                char[] cArray = new char[]{'/'};
                string = URL.copy$default($this$resolve_u24lambda_u2d1, false, null, null, null, Intrinsics.stringPlus("/", StringsKt.trimStart(PathInfoKt.normalize-aFssNxc(PathInfoKt.getPathInfo(StringsKt.substringBeforeLast$default($this$resolve_u24lambda_u2d1.getPath(), '/', null, 2, null) + '/' + access2)), cArray)), null, null, 0, 239, null).getFullUrl();
            }
            return string;
        }

        @NotNull
        public final String decodeComponent(@NotNull String s, @NotNull Charset charset, boolean formUrlEncoded) {
            ByteArrayBuilder bos = new ByteArrayBuilder(0, 1, null);
            int len = s.length();
            int n = 0;
            while (n < len) {
                ByteArrayBuilder this_$iv;
                boolean $i$f$append;
                byte v$iv;
                int c = s.charAt(n);
                int n2 = c;
                if (n2 == 37) {
                    ByteArrayBuilder byteArrayBuilder = bos;
                    v$iv = (byte)Integer.parseInt(StringExtKt.substr(s, n + 1, 2), CharsKt.checkRadix(16));
                    $i$f$append = false;
                    this_$iv.appendFast(v$iv);
                    n += 2;
                } else if (n2 == 43) {
                    if (formUrlEncoded) {
                        this_$iv = bos;
                        v$iv = 32;
                        $i$f$append = false;
                        this_$iv.appendFast(v$iv);
                    } else {
                        this_$iv = bos;
                        v$iv = 43;
                        $i$f$append = false;
                        this_$iv.appendFast(v$iv);
                    }
                } else {
                    this_$iv = bos;
                    v$iv = (byte)c;
                    $i$f$append = false;
                    this_$iv.appendFast(v$iv);
                }
                n2 = n;
                n = n2 + 1;
            }
            return CharsetKt.toString$default(bos.toByteArray(), charset, 0, 0, 6, null);
        }

        public static /* synthetic */ String decodeComponent$default(Companion companion, String string, Charset charset, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                charset = UTF8Kt.getUTF8();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.decodeComponent(string, charset, bl);
        }

        @NotNull
        public final String encodeComponent(@NotNull String s, @NotNull Charset charset, boolean formUrlEncoded) {
            StringBuilder sb = new StringBuilder(s.length());
            byte[] data2 = CharsetKt.toByteArray$default(s, charset, 0, 0, 6, null);
            int n = 0;
            int n2 = data2.length;
            while (n < n2) {
                int n3;
                byte c;
                char cc;
                char c2;
                if ((c2 = (cc = (char)(c = data2[n3 = n++]))) == ' ') {
                    if (formUrlEncoded) {
                        sb.append("+");
                        continue;
                    }
                    sb.append("%20");
                    continue;
                }
                boolean bl = (('a' <= c2 ? c2 < '{' : false) ? true : ('A' <= c2 ? c2 < '[' : false)) ? true : ('0' <= c2 ? c2 < ':' : false);
                if ((((bl ? true : c2 == '-') ? true : c2 == '_') ? true : c2 == '.') ? true : c2 == '*') {
                    sb.append(cc);
                    continue;
                }
                sb.append('%');
                int n4 = 1;
                do {
                    int n5 = n4--;
                    sb.append(Hex.INSTANCE.encodeCharUpper(c >>> n5 * 4 & 0xF));
                } while (0 <= n4);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
            return string;
        }

        public static /* synthetic */ String encodeComponent$default(Companion companion, String string, Charset charset, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                charset = UTF8Kt.getUTF8();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.encodeComponent(string, charset, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

