/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.writers;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sunflow.image.BitmapWriter;
import org.sunflow.image.Color;
import org.sunflow.image.ColorEncoder;

public class HDRBitmapWriter
implements BitmapWriter {
    private String filename;
    private int width;
    private int height;
    private int[] data;

    public void configure(String string, String string2) {
    }

    public void openFile(String string) throws IOException {
        this.filename = string;
    }

    public void writeHeader(int n, int n2, int n3) throws IOException, UnsupportedOperationException {
        this.width = n;
        this.height = n2;
        this.data = new int[n * n2];
    }

    public void writeTile(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) throws IOException {
        int[] nArray = ColorEncoder.encodeRGBE(colorArray);
        int n5 = 0;
        int n6 = 0;
        int n7 = n + n2 * this.width;
        while (n5 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                this.data[n7] = nArray[n6];
                ++n8;
                ++n6;
                ++n7;
            }
            ++n5;
            n7 += this.width - n3;
        }
    }

    public void closeFile() throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.filename));
        ((OutputStream)bufferedOutputStream).write("#?RGBE\n".getBytes());
        ((OutputStream)bufferedOutputStream).write("FORMAT=32-bit_rle_rgbe\n\n".getBytes());
        ((OutputStream)bufferedOutputStream).write(("-Y " + this.height + " +X " + this.width + "\n").getBytes());
        for (int i = 0; i < this.data.length; ++i) {
            int n = this.data[i];
            ((OutputStream)bufferedOutputStream).write(n >> 24);
            ((OutputStream)bufferedOutputStream).write(n >> 16);
            ((OutputStream)bufferedOutputStream).write(n >> 8);
            ((OutputStream)bufferedOutputStream).write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
    }
}

