import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  CreateStackInstancesInput,
  CreateStackInstancesOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface CreateStackInstancesCommandInput
  extends CreateStackInstancesInput {}
export interface CreateStackInstancesCommandOutput
  extends CreateStackInstancesOutput,
    __MetadataBearer {}
export declare class CreateStackInstancesCommand extends $Command<
  CreateStackInstancesCommandInput,
  CreateStackInstancesCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: CreateStackInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateStackInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateStackInstancesCommandInput,
    CreateStackInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
