/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.renderer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import zext.plantuml.com.ctreber.acearth.renderer.RenderTarget;
import zext.plantuml.com.ctreber.acearth.renderer.RowTypeRenderer;
import zext.plantuml.com.ctreber.acearth.shader.Shader;

public class Renderer {
    private Shader fShader;
    private RenderTarget fRenderTarget;
    private List fRowTypeRenderers = new ArrayList();

    public Renderer(RenderTarget pRenderTarget) {
        this.fRenderTarget = pRenderTarget;
    }

    public void render() {
        for (RowTypeRenderer lRowRenderer : this.fRowTypeRenderers) {
            lRowRenderer.startNewRun();
        }
        this.renderRows();
    }

    private void renderRows() {
        for (int lRowNo = 0; lRowNo < this.fRenderTarget.getImageHeight(); ++lRowNo) {
            int[] lPixelTypes = this.getPixelTypes(lRowNo);
            this.renderRow(lRowNo, lPixelTypes);
        }
    }

    private int[] getPixelTypes(int pRowNo) {
        int[] lPixelTypes = new int[this.fRenderTarget.getImageWidth()];
        for (RowTypeRenderer lRowRenderer : this.fRowTypeRenderers) {
            lRowRenderer.getPixelTypes(pRowNo, lPixelTypes);
        }
        return lPixelTypes;
    }

    private void renderRow(int pRowNo, int[] pPixelTypes) {
        Color[] lPixelColors = this.fShader.getShadedColors(pRowNo, pPixelTypes);
        for (int lColNo = 0; lColNo < this.fRenderTarget.getImageWidth(); ++lColNo) {
            this.fRenderTarget.setPixel(lColNo, pRowNo, lPixelColors[lColNo]);
        }
    }

    public void setShader(Shader pShader) {
        this.fShader = pShader;
    }

    public void setRenderTarget(RenderTarget pRenderTarget) {
        this.fRenderTarget = pRenderTarget;
    }

    public void addRowTypeRenderer(RowTypeRenderer pRowRenderer) {
        this.fRowTypeRenderers.add(pRowRenderer);
    }
}

