/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.opensearch.data.utils.Content;

public class OpenSearchJsonContent
implements Content {
    private final JsonNode value;

    @Override
    public Integer intValue() {
        return this.value().intValue();
    }

    @Override
    public Long longValue() {
        return this.value().longValue();
    }

    @Override
    public Short shortValue() {
        return this.value().shortValue();
    }

    @Override
    public Byte byteValue() {
        return (byte)this.value().shortValue();
    }

    @Override
    public Float floatValue() {
        return Float.valueOf(this.value().floatValue());
    }

    @Override
    public Double doubleValue() {
        return this.value().doubleValue();
    }

    @Override
    public String stringValue() {
        return this.value().asText();
    }

    @Override
    public Boolean booleanValue() {
        return this.value().booleanValue();
    }

    @Override
    public Iterator<Map.Entry<String, Content>> map() {
        LinkedHashMap map = new LinkedHashMap();
        JsonNode mapValue = this.value();
        mapValue.fieldNames().forEachRemaining(field -> map.put(field, new OpenSearchJsonContent(mapValue.get(field))));
        return map.entrySet().iterator();
    }

    @Override
    public Iterator<? extends Content> array() {
        return Iterators.transform((Iterator)this.value.elements(), OpenSearchJsonContent::new);
    }

    @Override
    public boolean isNull() {
        return this.value == null || this.value.isNull() || this.value.isArray() && this.value.isEmpty();
    }

    @Override
    public boolean isNumber() {
        return this.value().isNumber();
    }

    @Override
    public boolean isLong() {
        return this.value().isLong();
    }

    @Override
    public boolean isFloat() {
        return this.value().isFloat();
    }

    @Override
    public boolean isDouble() {
        return this.value().isDouble();
    }

    @Override
    public boolean isString() {
        return this.value().isTextual();
    }

    @Override
    public boolean isBoolean() {
        return this.value().isBoolean();
    }

    @Override
    public boolean isArray() {
        return this.value().isArray();
    }

    @Override
    public Object objectValue() {
        return this.value();
    }

    @Override
    public Pair<Double, Double> geoValue() {
        JsonNode value = this.value();
        if (value.has("lat") && value.has("lon")) {
            Double lat = 0.0;
            Double lon = 0.0;
            try {
                lat = this.extractDoubleValue(value.get("lat"));
            }
            catch (Exception exception) {
                throw new IllegalStateException("latitude must be number value, but got value: " + value.get("lat"));
            }
            try {
                lon = this.extractDoubleValue(value.get("lon"));
            }
            catch (Exception exception) {
                throw new IllegalStateException("longitude must be number value, but got value: " + value.get("lon"));
            }
            return Pair.of((Object)lat, (Object)lon);
        }
        throw new IllegalStateException("geo point must in format of {\"lat\": number, \"lon\": number}");
    }

    private JsonNode value() {
        return this.value;
    }

    private Double extractDoubleValue(JsonNode node) {
        if (node.isTextual()) {
            return Double.valueOf(node.textValue());
        }
        if (node.isNumber()) {
            return node.doubleValue();
        }
        throw new IllegalStateException("node must be a number");
    }

    @Generated
    public OpenSearchJsonContent(JsonNode value) {
        this.value = value;
    }
}

