/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.commons.alerting.action.IndexWorkflowRequest;
import org.opensearch.commons.alerting.model.CompositeInput;
import org.opensearch.commons.alerting.model.Delegate;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.WorkflowInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lorg/opensearch/commons/alerting/action/IndexWorkflowRequest;", "Lorg/opensearch/action/ActionRequest;", "workflowId", "", "seqNo", "", "primaryTerm", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "method", "Lorg/opensearch/rest/RestRequest$Method;", "workflow", "Lorg/opensearch/commons/alerting/model/Workflow;", "rbacRoles", "", "(Ljava/lang/String;JJLorg/opensearch/action/support/WriteRequest$RefreshPolicy;Lorg/opensearch/rest/RestRequest$Method;Lorg/opensearch/commons/alerting/model/Workflow;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "MAX_DELEGATE_SIZE", "", "getMethod", "()Lorg/opensearch/rest/RestRequest$Method;", "getPrimaryTerm", "()J", "getRbacRoles", "()Ljava/util/List;", "getRefreshPolicy", "()Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "getSeqNo", "getWorkflow", "()Lorg/opensearch/commons/alerting/model/Workflow;", "setWorkflow", "(Lorg/opensearch/commons/alerting/model/Workflow;)V", "getWorkflowId", "()Ljava/lang/String;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nIndexWorkflowRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexWorkflowRequest.kt\norg/opensearch/commons/alerting/action/IndexWorkflowRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1179#2,2:161\n1253#2,4:163\n1855#2,2:167\n*S KotlinDebug\n*F\n+ 1 IndexWorkflowRequest.kt\norg/opensearch/commons/alerting/action/IndexWorkflowRequest\n*L\n105#1:161,2\n105#1:163,4\n106#1:167,2\n*E\n"})
public final class IndexWorkflowRequest
extends ActionRequest {
    @NotNull
    private final String workflowId;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final WriteRequest.RefreshPolicy refreshPolicy;
    @NotNull
    private final RestRequest.Method method;
    @NotNull
    private Workflow workflow;
    @Nullable
    private final List<String> rbacRoles;
    private final int MAX_DELEGATE_SIZE;

    @NotNull
    public final String getWorkflowId() {
        return this.workflowId;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @NotNull
    public final RestRequest.Method getMethod() {
        return this.method;
    }

    @NotNull
    public final Workflow getWorkflow() {
        return this.workflow;
    }

    public final void setWorkflow(@NotNull Workflow workflow) {
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"<set-?>");
        this.workflow = workflow;
    }

    @Nullable
    public final List<String> getRbacRoles() {
        return this.rbacRoles;
    }

    public IndexWorkflowRequest(@NotNull String workflowId, long seqNo, long primaryTerm, @NotNull WriteRequest.RefreshPolicy refreshPolicy, @NotNull RestRequest.Method method, @NotNull Workflow workflow, @Nullable List<String> rbacRoles) {
        Intrinsics.checkNotNullParameter((Object)workflowId, (String)"workflowId");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        this.MAX_DELEGATE_SIZE = 25;
        this.workflowId = workflowId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.method = method;
        this.workflow = workflow;
        this.rbacRoles = rbacRoles;
    }

    public /* synthetic */ IndexWorkflowRequest(String string, long l, long l2, WriteRequest.RefreshPolicy refreshPolicy, RestRequest.Method method, Workflow workflow, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            list = null;
        }
        this(string, l, l2, refreshPolicy, method, workflow, list);
    }

    public IndexWorkflowRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        long l = sin.readLong();
        long l2 = sin.readLong();
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)sin);
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"readFrom(sin)");
        Enum enum_ = sin.readEnum(RestRequest.Method.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(RestRequest.Method::class.java)");
        RestRequest.Method method = (RestRequest.Method)enum_;
        Workflow workflow = Workflow.Companion.readFrom(sin);
        Intrinsics.checkNotNull((Object)workflow, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Workflow");
        this(string, l, l2, refreshPolicy, method, workflow, sin.readOptionalStringList());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ActionRequestValidationException validate() {
        void $this$associateTo$iv$iv;
        List<Delegate> delegates;
        Set orderSet2;
        ActionRequestValidationException validationException = null;
        if (this.workflow.getInputs().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Input list can not be empty.", validationException);
            return validationException;
        }
        if (this.workflow.getInputs().size() > 1) {
            validationException = ValidateActions.addValidationError((String)"Input list can contain only one element.", (ActionRequestValidationException)validationException);
            return validationException;
        }
        if (!(this.workflow.getInputs().get(0) instanceof CompositeInput)) {
            validationException = ValidateActions.addValidationError((String)"When creating a workflow input must be CompositeInput", (ActionRequestValidationException)validationException);
        }
        WorkflowInput workflowInput = this.workflow.getInputs().get(0);
        Intrinsics.checkNotNull((Object)workflowInput, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.CompositeInput");
        CompositeInput compositeInput = (CompositeInput)workflowInput;
        List monitorIds2 = compositeInput.getSequence().getDelegates().stream().map(arg_0 -> IndexWorkflowRequest.validate$lambda$0(validate.monitorIds.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Collection collection = monitorIds2;
        if (collection == null || collection.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Delegates list can not be empty.", (ActionRequestValidationException)validationException);
            return validationException;
        }
        if (monitorIds2.size() > this.MAX_DELEGATE_SIZE) {
            validationException = ValidateActions.addValidationError((String)("Delegates list can not be larger then " + this.MAX_DELEGATE_SIZE + "."), (ActionRequestValidationException)validationException);
        }
        Intrinsics.checkNotNullExpressionValue(monitorIds2, (String)"monitorIds");
        if (CollectionsKt.toSet((Iterable)monitorIds2).size() != monitorIds2.size()) {
            validationException = ValidateActions.addValidationError((String)"Duplicate delegates not allowed", (ActionRequestValidationException)validationException);
        }
        if ((orderSet2 = (delegates = compositeInput.getSequence().getDelegates()).stream().filter(arg_0 -> IndexWorkflowRequest.validate$lambda$1(validate.orderSet.1.INSTANCE, arg_0)).map(arg_0 -> IndexWorkflowRequest.validate$lambda$2(validate.orderSet.2.INSTANCE, arg_0)).collect(Collectors.toSet())).size() != delegates.size()) {
            validationException = ValidateActions.addValidationError((String)"Sequence ordering of delegate monitor shouldn't contain duplicate order values", (ActionRequestValidationException)validationException);
        }
        Iterable $this$associate$iv = delegates;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Delegate it = (Delegate)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getMonitorId(), (Object)it.getOrder());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map monitorIdOrderMap = destination$iv$iv;
        Iterable $this$forEach$iv = delegates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Delegate it = (Delegate)element$iv;
            boolean bl = false;
            if (it.getChainedMonitorFindings() == null) continue;
            if (it.getChainedMonitorFindings().getMonitorId() != null) {
                if (!monitorIdOrderMap.containsKey(it.getChainedMonitorFindings().getMonitorId())) {
                    validationException = ValidateActions.addValidationError((String)("Chained Findings Monitor " + it.getChainedMonitorFindings().getMonitorId() + " doesn't exist in sequence"), (ActionRequestValidationException)validationException);
                    return validationException;
                }
                int n = it.getOrder();
                Object v = monitorIdOrderMap.get(it.getChainedMonitorFindings().getMonitorId());
                Intrinsics.checkNotNull(v);
                if (n > ((Number)v).intValue()) continue;
                validationException = ValidateActions.addValidationError((String)("Chained Findings Monitor " + it.getChainedMonitorFindings().getMonitorId() + " should be executed before monitor " + it.getMonitorId()), (ActionRequestValidationException)validationException);
                continue;
            }
            for (String monitorId : it.getChainedMonitorFindings().getMonitorIds()) {
                if (!monitorIdOrderMap.containsKey(monitorId)) {
                    validationException = ValidateActions.addValidationError((String)("Chained Findings Monitor " + monitorId + " doesn't exist in sequence"), (ActionRequestValidationException)validationException);
                    return validationException;
                }
                Object v = monitorIdOrderMap.get(monitorId);
                Intrinsics.checkNotNull(v);
                int order = ((Number)v).intValue();
                if (order < it.getOrder()) continue;
                return ValidateActions.addValidationError((String)("Chained Findings Monitor " + it.getChainedMonitorFindings().getMonitorId() + " should be executed before monitor " + it.getMonitorId() + ". Order of monitor being chained [" + order + "] should be smaller than order of monitor using findings as source data [" + it.getOrder() + "] in sequence"), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.workflowId);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        this.refreshPolicy.writeTo(out);
        out.writeEnum((Enum)this.method);
        this.workflow.writeTo(out);
        out.writeOptionalStringCollection((Collection)this.rbacRoles);
    }

    private static final String validate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean validate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Integer validate$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }
}

