/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.ExceptionsHelper;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.knn.index.VectorDataType;

public abstract class KNNVectorScriptDocValues<T>
extends ScriptDocValues<T> {
    private final DocIdSetIterator vectorValues;
    private final String fieldName;
    private final VectorDataType vectorDataType;
    private boolean docExists = false;
    private int lastDocID = -1;

    public void setNextDocId(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + docId);
        }
        this.lastDocID = docId;
        int curDocID = this.vectorValues.docID();
        if (this.lastDocID > curDocID) {
            curDocID = this.vectorValues.advance(docId);
        }
        this.docExists = this.lastDocID == curDocID;
    }

    public T getValue() {
        if (!this.docExists) {
            String errorMessage = String.format("One of the document doesn't have a value for field '%s'. This can be avoided by checking if a document has a value for the field or not by doc['%s'].size() == 0 ? 0 : {your script}", this.fieldName, this.fieldName);
            throw new IllegalStateException(errorMessage);
        }
        try {
            return this.doGetValue();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected abstract T doGetValue() throws IOException;

    public int size() {
        return this.docExists ? 1 : 0;
    }

    public T get(int i) {
        throw new UnsupportedOperationException("knn vector does not support this operation");
    }

    public static KNNVectorScriptDocValues<?> create(DocIdSetIterator values, String fieldName, VectorDataType vectorDataType) {
        Objects.requireNonNull(values, "values must not be null");
        if (values instanceof ByteVectorValues) {
            return new KNNByteVectorScriptDocValues((ByteVectorValues)values, fieldName, vectorDataType);
        }
        if (values instanceof FloatVectorValues) {
            return new KNNFloatVectorScriptDocValues((FloatVectorValues)values, fieldName, vectorDataType);
        }
        if (values instanceof BinaryDocValues) {
            return new KNNNativeVectorScriptDocValues((BinaryDocValues)values, fieldName, vectorDataType);
        }
        throw new IllegalArgumentException("Unsupported values type: " + String.valueOf(values.getClass()));
    }

    public static KNNVectorScriptDocValues<?> emptyValues(String fieldName, VectorDataType type) {
        if (type == VectorDataType.FLOAT) {
            return new KNNVectorScriptDocValues<float[]>(DocIdSetIterator.empty(), fieldName, type){

                @Override
                protected float[] doGetValue() throws IOException {
                    throw new UnsupportedOperationException("empty values");
                }
            };
        }
        return new KNNVectorScriptDocValues<byte[]>(DocIdSetIterator.empty(), fieldName, type){

            @Override
            protected byte[] doGetValue() throws IOException {
                throw new UnsupportedOperationException("empty values");
            }
        };
    }

    @Generated
    private KNNVectorScriptDocValues(DocIdSetIterator vectorValues, String fieldName, VectorDataType vectorDataType) {
        this.vectorValues = vectorValues;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    private static final class KNNNativeVectorScriptDocValues<T>
    extends KNNVectorScriptDocValues<T> {
        private final BinaryDocValues values;

        KNNNativeVectorScriptDocValues(BinaryDocValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values, field, type);
            this.values = values;
        }

        @Override
        protected T doGetValue() throws IOException {
            return this.getVectorDataType().getVectorFromBytesRef(this.values.binaryValue());
        }
    }

    private static final class KNNFloatVectorScriptDocValues
    extends KNNVectorScriptDocValues<float[]> {
        private final FloatVectorValues values;

        KNNFloatVectorScriptDocValues(FloatVectorValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values, field, type);
            this.values = values;
        }

        @Override
        protected float[] doGetValue() throws IOException {
            return this.values.vectorValue();
        }
    }

    private static final class KNNByteVectorScriptDocValues
    extends KNNVectorScriptDocValues<byte[]> {
        private final ByteVectorValues values;

        KNNByteVectorScriptDocValues(ByteVectorValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values, field, type);
            this.values = values;
        }

        @Override
        protected byte[] doGetValue() throws IOException {
            try {
                return this.values.vectorValue();
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }
    }
}

