/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference;

public class GetTransitGatewayPrefixListReferencesIterable
implements SdkIterable<GetTransitGatewayPrefixListReferencesResponse> {
    private final Ec2Client client;
    private final GetTransitGatewayPrefixListReferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTransitGatewayPrefixListReferencesIterable(Ec2Client client, GetTransitGatewayPrefixListReferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTransitGatewayPrefixListReferencesResponseFetcher();
    }

    public Iterator<GetTransitGatewayPrefixListReferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayPrefixListReference> transitGatewayPrefixListReferences() {
        Function<GetTransitGatewayPrefixListReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayPrefixListReferences() != null) {
                return response.transitGatewayPrefixListReferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTransitGatewayPrefixListReferencesResponseFetcher
    implements SyncPageFetcher<GetTransitGatewayPrefixListReferencesResponse> {
        private GetTransitGatewayPrefixListReferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayPrefixListReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTransitGatewayPrefixListReferencesResponse nextPage(GetTransitGatewayPrefixListReferencesResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayPrefixListReferencesIterable.this.client.getTransitGatewayPrefixListReferences(GetTransitGatewayPrefixListReferencesIterable.this.firstRequest);
            }
            return GetTransitGatewayPrefixListReferencesIterable.this.client.getTransitGatewayPrefixListReferences((GetTransitGatewayPrefixListReferencesRequest)((Object)GetTransitGatewayPrefixListReferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

