/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.model.EntityState;
import org.opensearch.timeseries.model.InitProgressProfile;
import org.opensearch.timeseries.model.Mergeable;
import org.opensearch.timeseries.model.ModelProfileOnNode;

public class EntityProfile
implements Writeable,
ToXContent,
Mergeable {
    public static final String IS_ACTIVE = "is_active";
    public static final String LAST_ACTIVE_TIMESTAMP = "last_active_timestamp";
    public static final String LAST_SAMPLE_TIMESTAMP = "last_sample_timestamp";
    private Boolean isActive;
    private long lastActiveTimestampMs;
    private long lastSampleTimestampMs;
    private InitProgressProfile initProgress;
    private ModelProfileOnNode modelProfile;
    private EntityState state;

    public EntityProfile(Boolean isActive, long lastActiveTimeStamp, long lastSampleTimestamp, InitProgressProfile initProgress, ModelProfileOnNode modelProfile, EntityState state) {
        this.isActive = isActive;
        this.lastActiveTimestampMs = lastActiveTimeStamp;
        this.lastSampleTimestampMs = lastSampleTimestamp;
        this.initProgress = initProgress;
        this.modelProfile = modelProfile;
        this.state = state;
    }

    public EntityProfile(StreamInput in) throws IOException {
        this.isActive = in.readOptionalBoolean();
        this.lastActiveTimestampMs = in.readLong();
        this.lastSampleTimestampMs = in.readLong();
        if (in.readBoolean()) {
            this.initProgress = new InitProgressProfile(in);
        }
        if (in.readBoolean()) {
            this.modelProfile = new ModelProfileOnNode(in);
        }
        this.state = (EntityState)in.readEnum(EntityState.class);
    }

    public Optional<Boolean> getActive() {
        return Optional.ofNullable(this.isActive);
    }

    public Long getLastActiveTimestamp() {
        return this.lastActiveTimestampMs;
    }

    public Long getLastSampleTimestamp() {
        return this.lastSampleTimestampMs;
    }

    public InitProgressProfile getInitProgress() {
        return this.initProgress;
    }

    public ModelProfileOnNode getModelProfile() {
        return this.modelProfile;
    }

    public EntityState getState() {
        return this.state;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.isActive != null) {
            builder.field(IS_ACTIVE, this.isActive);
        }
        if (this.lastActiveTimestampMs > 0L) {
            builder.field(LAST_ACTIVE_TIMESTAMP, this.lastActiveTimestampMs);
        }
        if (this.lastSampleTimestampMs > 0L) {
            builder.field(LAST_SAMPLE_TIMESTAMP, this.lastSampleTimestampMs);
        }
        if (this.initProgress != null) {
            builder.field("init_progress", (ToXContent)this.initProgress);
        }
        if (this.modelProfile != null) {
            builder.field("model", (ToXContent)this.modelProfile);
        }
        if (this.state != null && this.state != EntityState.UNKNOWN) {
            builder.field("state", (Object)this.state);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.isActive);
        out.writeLong(this.lastActiveTimestampMs);
        out.writeLong(this.lastSampleTimestampMs);
        if (this.initProgress != null) {
            out.writeBoolean(true);
            this.initProgress.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelProfile != null) {
            out.writeBoolean(true);
            this.modelProfile.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeEnum((Enum)this.state);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        if (this.isActive != null) {
            builder.append(IS_ACTIVE, (Object)this.isActive);
        }
        if (this.lastActiveTimestampMs > 0L) {
            builder.append(LAST_ACTIVE_TIMESTAMP, this.lastActiveTimestampMs);
        }
        if (this.lastSampleTimestampMs > 0L) {
            builder.append(LAST_SAMPLE_TIMESTAMP, this.lastSampleTimestampMs);
        }
        if (this.initProgress != null) {
            builder.append("init_progress", (Object)this.initProgress);
        }
        if (this.modelProfile != null) {
            builder.append("models", (Object)this.modelProfile);
        }
        if (this.state != null && this.state != EntityState.UNKNOWN) {
            builder.append("state", (Object)this.state);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof EntityProfile) {
            EntityProfile other = (EntityProfile)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.isActive, (Object)other.isActive);
            equalsBuilder.append(this.lastActiveTimestampMs, other.lastActiveTimestampMs);
            equalsBuilder.append(this.lastSampleTimestampMs, other.lastSampleTimestampMs);
            equalsBuilder.append((Object)this.initProgress, (Object)other.initProgress);
            equalsBuilder.append((Object)this.modelProfile, (Object)other.modelProfile);
            equalsBuilder.append((Object)this.state, (Object)other.state);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.isActive).append(this.lastActiveTimestampMs).append(this.lastSampleTimestampMs).append((Object)this.initProgress).append((Object)this.modelProfile).append((Object)this.state).toHashCode();
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        EntityProfile otherProfile = (EntityProfile)other;
        if (otherProfile.getInitProgress() != null) {
            this.initProgress = otherProfile.getInitProgress();
        }
        if (otherProfile.isActive != null) {
            this.isActive = otherProfile.isActive;
        }
        if (otherProfile.lastActiveTimestampMs > 0L) {
            this.lastActiveTimestampMs = otherProfile.lastActiveTimestampMs;
        }
        if (otherProfile.lastSampleTimestampMs > 0L) {
            this.lastSampleTimestampMs = otherProfile.lastSampleTimestampMs;
        }
        if (otherProfile.modelProfile != null) {
            this.modelProfile = otherProfile.modelProfile;
        }
        if (otherProfile.getState() != null && otherProfile.getState() != EntityState.UNKNOWN) {
            this.state = otherProfile.getState();
        }
    }

    public static class Builder {
        private Boolean isActive = null;
        private long lastActiveTimestampMs = -1L;
        private long lastSampleTimestampMs = -1L;
        private InitProgressProfile initProgress = null;
        private ModelProfileOnNode modelProfile = null;
        private EntityState state = EntityState.UNKNOWN;

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder lastActiveTimestampMs(long lastActiveTimestampMs) {
            this.lastActiveTimestampMs = lastActiveTimestampMs;
            return this;
        }

        public Builder lastSampleTimestampMs(long lastSampleTimestampMs) {
            this.lastSampleTimestampMs = lastSampleTimestampMs;
            return this;
        }

        public Builder initProgress(InitProgressProfile initProgress) {
            this.initProgress = initProgress;
            return this;
        }

        public Builder modelProfile(ModelProfileOnNode modelProfile) {
            this.modelProfile = modelProfile;
            return this;
        }

        public Builder state(EntityState state) {
            this.state = state;
            return this;
        }

        public EntityProfile build() {
            return new EntityProfile(this.isActive, this.lastActiveTimestampMs, this.lastSampleTimestampMs, this.initProgress, this.modelProfile, this.state);
        }
    }
}

