/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.stats.IndexingPressurePerShardStats;

@PublicApi(since="1.3.0")
public class ShardIndexingPressureStats
implements Writeable,
ToXContentFragment {
    private final Map<ShardId, IndexingPressurePerShardStats> shardIndexingPressureStore;
    private final long totalNodeLimitsBreachedRejections;
    private final long totalLastSuccessfulRequestLimitsBreachedRejections;
    private final long totalThroughputDegradationLimitsBreachedRejections;
    private final boolean shardIndexingPressureEnabled;
    private final boolean shardIndexingPressureEnforced;

    public ShardIndexingPressureStats(StreamInput in) throws IOException {
        int shardEntries = in.readInt();
        this.shardIndexingPressureStore = new HashMap<ShardId, IndexingPressurePerShardStats>();
        for (int i = 0; i < shardEntries; ++i) {
            ShardId shardId = new ShardId(in);
            IndexingPressurePerShardStats shardStats = new IndexingPressurePerShardStats(in);
            this.shardIndexingPressureStore.put(shardId, shardStats);
        }
        this.totalNodeLimitsBreachedRejections = in.readVLong();
        this.totalLastSuccessfulRequestLimitsBreachedRejections = in.readVLong();
        this.totalThroughputDegradationLimitsBreachedRejections = in.readVLong();
        this.shardIndexingPressureEnabled = in.readBoolean();
        this.shardIndexingPressureEnforced = in.readBoolean();
    }

    public ShardIndexingPressureStats(Map<ShardId, IndexingPressurePerShardStats> shardIndexingPressureStore, long totalNodeLimitsBreachedRejections, long totalLastSuccessfulRequestLimitsBreachedRejections, long totalThroughputDegradationLimitsBreachedRejections, boolean shardIndexingPressureEnabled, boolean shardIndexingPressureEnforced) {
        this.shardIndexingPressureStore = shardIndexingPressureStore;
        this.totalNodeLimitsBreachedRejections = totalNodeLimitsBreachedRejections;
        this.totalLastSuccessfulRequestLimitsBreachedRejections = totalLastSuccessfulRequestLimitsBreachedRejections;
        this.totalThroughputDegradationLimitsBreachedRejections = totalThroughputDegradationLimitsBreachedRejections;
        this.shardIndexingPressureEnabled = shardIndexingPressureEnabled;
        this.shardIndexingPressureEnforced = shardIndexingPressureEnforced;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardIndexingPressureStore.size());
        for (Map.Entry<ShardId, IndexingPressurePerShardStats> entry : this.shardIndexingPressureStore.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
        out.writeVLong(this.totalNodeLimitsBreachedRejections);
        out.writeVLong(this.totalLastSuccessfulRequestLimitsBreachedRejections);
        out.writeVLong(this.totalThroughputDegradationLimitsBreachedRejections);
        out.writeBoolean(this.shardIndexingPressureEnabled);
        out.writeBoolean(this.shardIndexingPressureEnforced);
    }

    public IndexingPressurePerShardStats getIndexingPressureShardStats(ShardId shardId) {
        return this.shardIndexingPressureStore.get(shardId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("shard_indexing_pressure");
        builder.startObject("stats");
        for (Map.Entry<ShardId, IndexingPressurePerShardStats> entry : this.shardIndexingPressureStore.entrySet()) {
            entry.getValue().toXContent(builder, params);
        }
        builder.endObject();
        if (this.shardIndexingPressureEnforced) {
            builder.startObject("total_rejections_breakup");
        } else {
            builder.startObject("total_rejections_breakup_shadow_mode");
        }
        builder.field("node_limits", this.totalNodeLimitsBreachedRejections);
        builder.field("no_successful_request_limits", this.totalLastSuccessfulRequestLimitsBreachedRejections);
        builder.field("throughput_degradation_limits", this.totalThroughputDegradationLimitsBreachedRejections);
        builder.endObject();
        builder.field("enabled", this.shardIndexingPressureEnabled);
        builder.field("enforced", this.shardIndexingPressureEnforced);
        return builder.endObject();
    }

    public void addAll(ShardIndexingPressureStats shardIndexingPressureStats) {
        if (this.shardIndexingPressureStore != null) {
            this.shardIndexingPressureStore.putAll(shardIndexingPressureStats.shardIndexingPressureStore);
        }
    }
}

