/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.breaker;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.unit.ByteSizeValue;

public final class BreakerSettings {
    private static final String BREAKER_SETTING_PREFIX = "breaker.";
    private static final String BREAKER_LIMIT_SUFFIX = "limit";
    private static final String BREAKER_OVERHEAD_SUFFIX = "overhead";
    private static final String BREAKER_TYPE_SUFFIX = "type";
    public static final Setting.AffixSetting<ByteSizeValue> CIRCUIT_BREAKER_LIMIT_SETTING = Setting.affixKeySetting("breaker.", "limit", name -> Setting.memorySizeSetting(name, "100%", Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Double> CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.affixKeySetting("breaker.", "overhead", name -> Setting.doubleSetting(name, 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<CircuitBreaker.Type> CIRCUIT_BREAKER_TYPE = Setting.affixKeySetting("breaker.", "type", name -> new Setting<CircuitBreaker.Type>((String)name, "noop", CircuitBreaker.Type::parseValue, type -> {
        if (CircuitBreaker.Type.PARENT.equals(type)) {
            throw new IllegalArgumentException("Invalid circuit breaker type [parent]. Only [memory] or [noop] are configurable");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private final String name;
    private final long limitBytes;
    private final double overhead;
    private final CircuitBreaker.Type type;
    private final CircuitBreaker.Durability durability;

    static String breakerLimitSettingKey(String breakerName) {
        return BREAKER_SETTING_PREFIX + breakerName + ".limit";
    }

    static String breakerOverheadSettingKey(String breakerName) {
        return BREAKER_SETTING_PREFIX + breakerName + ".overhead";
    }

    static String breakerTypeSettingKey(String breakerName) {
        return BREAKER_SETTING_PREFIX + breakerName + ".type";
    }

    public static BreakerSettings updateFromSettings(BreakerSettings defaultSettings, Settings currentSettings) {
        String breakerName = defaultSettings.name;
        return new BreakerSettings(breakerName, BreakerSettings.getOrDefault(CIRCUIT_BREAKER_LIMIT_SETTING.getConcreteSetting(BreakerSettings.breakerLimitSettingKey(breakerName)), new ByteSizeValue(defaultSettings.limitBytes), currentSettings).getBytes(), BreakerSettings.getOrDefault(CIRCUIT_BREAKER_OVERHEAD_SETTING.getConcreteSetting(BreakerSettings.breakerOverheadSettingKey(breakerName)), defaultSettings.overhead, currentSettings), BreakerSettings.getOrDefault(CIRCUIT_BREAKER_TYPE.getConcreteSetting(BreakerSettings.breakerTypeSettingKey(breakerName)), defaultSettings.type, currentSettings), defaultSettings.durability);
    }

    private static <T> T getOrDefault(Setting<T> concreteSetting, T defaultValue, Settings settings) {
        return concreteSetting.exists(settings) ? concreteSetting.get(settings) : defaultValue;
    }

    public BreakerSettings(String name, long limitBytes, double overhead) {
        this(name, limitBytes, overhead, CircuitBreaker.Type.MEMORY, CircuitBreaker.Durability.PERMANENT);
    }

    public BreakerSettings(String name, long limitBytes, double overhead, CircuitBreaker.Type type, CircuitBreaker.Durability durability) {
        this.name = name;
        this.limitBytes = limitBytes;
        this.overhead = overhead;
        this.type = type;
        this.durability = durability;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limitBytes;
    }

    public double getOverhead() {
        return this.overhead;
    }

    public CircuitBreaker.Type getType() {
        return this.type;
    }

    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    public String toString() {
        return "[" + this.name + ",type=" + this.type.toString() + ",durability=" + (this.durability == null ? "null" : this.durability.toString()) + ",limit=" + this.limitBytes + "/" + new ByteSizeValue(this.limitBytes) + ",overhead=" + this.overhead + "]";
    }
}

