/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.action.support.WriteResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public abstract class DocWriteResponse
extends ReplicationResponse
implements WriteResponse,
StatusToXContentObject {
    private static final String _SHARDS = "_shards";
    private static final String _INDEX = "_index";
    private static final String _ID = "_id";
    private static final String _VERSION = "_version";
    private static final String _SEQ_NO = "_seq_no";
    private static final String _PRIMARY_TERM = "_primary_term";
    private static final String RESULT = "result";
    private static final String FORCED_REFRESH = "forced_refresh";
    private final ShardId shardId;
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private boolean forcedRefresh;
    protected final Result result;

    public DocWriteResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, Result result) {
        this.shardId = Objects.requireNonNull(shardId);
        this.id = Objects.requireNonNull(id);
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.version = version;
        this.result = Objects.requireNonNull(result);
    }

    protected DocWriteResponse(ShardId shardId, StreamInput in) throws IOException {
        super(in);
        this.shardId = shardId;
        if (in.getVersion().before(Version.V_2_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readString();
        this.version = in.readZLong();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.forcedRefresh = in.readBoolean();
        this.result = Result.readFrom(in);
    }

    protected DocWriteResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readString();
        this.version = in.readZLong();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.forcedRefresh = in.readBoolean();
        this.result = Result.readFrom(in);
    }

    public Result getResult() {
        return this.result;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        this.forcedRefresh = forcedRefresh;
    }

    @Override
    public RestStatus status() {
        return this.getShardInfo().status();
    }

    public String getLocation(@Nullable String routing) {
        String encodedRouting;
        String encodedId;
        String encodedType;
        String encodedIndex;
        try {
            encodedIndex = URLEncoder.encode(this.getIndex(), "UTF-8");
            encodedType = URLEncoder.encode("_doc", "UTF-8");
            encodedId = URLEncoder.encode(this.getId(), "UTF-8");
            encodedRouting = routing == null ? null : URLEncoder.encode(routing, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        String routingStart = "?routing=";
        int bufferSizeExcludingRouting = 3 + encodedIndex.length() + encodedType.length() + encodedId.length();
        int bufferSize = encodedRouting == null ? bufferSizeExcludingRouting : bufferSizeExcludingRouting + "?routing=".length() + encodedRouting.length();
        StringBuilder location = new StringBuilder(bufferSize);
        location.append('/').append(encodedIndex);
        location.append('/').append(encodedType);
        location.append('/').append(encodedId);
        if (encodedRouting != null) {
            location.append("?routing=").append(encodedRouting);
        }
        return location.toString();
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeWithoutShardId(out);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        this.writeWithoutShardId(out);
    }

    private void writeWithoutShardId(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeZLong(this.version);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeBoolean(this.forcedRefresh);
        this.result.writeTo(out);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ReplicationResponse.ShardInfo shardInfo = this.getShardInfo();
        builder.field(_INDEX, this.shardId.getIndexName());
        builder.field(_ID, this.id).field(_VERSION, this.version).field(RESULT, this.getResult().getLowercase());
        if (this.forcedRefresh) {
            builder.field(FORCED_REFRESH, true);
        }
        builder.field(_SHARDS, (ToXContent)shardInfo);
        if (this.getSeqNo() >= 0L) {
            builder.field(_SEQ_NO, this.getSeqNo());
            builder.field(_PRIMARY_TERM, this.getPrimaryTerm());
        }
        return builder;
    }

    protected static void parseInnerToXContent(XContentParser parser, Builder context) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String currentFieldName = parser.currentName();
        token = parser.nextToken();
        if (token.isValue()) {
            if (_INDEX.equals(currentFieldName)) {
                context.setShardId(new ShardId(new Index(parser.text(), "_na_"), -1));
            } else if (_ID.equals(currentFieldName)) {
                context.setId(parser.text());
            } else if (_VERSION.equals(currentFieldName)) {
                context.setVersion(parser.longValue());
            } else if (RESULT.equals(currentFieldName)) {
                String result = parser.text();
                for (Result r : Result.values()) {
                    if (!r.getLowercase().equals(result)) continue;
                    context.setResult(r);
                    break;
                }
            } else if (FORCED_REFRESH.equals(currentFieldName)) {
                context.setForcedRefresh(parser.booleanValue());
            } else if (_SEQ_NO.equals(currentFieldName)) {
                context.setSeqNo(parser.longValue());
            } else if (_PRIMARY_TERM.equals(currentFieldName)) {
                context.setPrimaryTerm(parser.longValue());
            }
        } else if (token == XContentParser.Token.START_OBJECT) {
            if (_SHARDS.equals(currentFieldName)) {
                context.setShardInfo(ReplicationResponse.ShardInfo.fromXContent(parser));
            } else {
                parser.skipChildren();
            }
        } else if (token == XContentParser.Token.START_ARRAY) {
            parser.skipChildren();
        }
    }

    public static abstract class Builder {
        protected ShardId shardId = null;
        protected String id = null;
        protected Long version = null;
        protected Result result = null;
        protected boolean forcedRefresh;
        protected ReplicationResponse.ShardInfo shardInfo = null;
        protected long seqNo = -2L;
        protected long primaryTerm = 0L;

        public ShardId getShardId() {
            return this.shardId;
        }

        public void setShardId(ShardId shardId) {
            this.shardId = shardId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public void setForcedRefresh(boolean forcedRefresh) {
            this.forcedRefresh = forcedRefresh;
        }

        public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
            this.shardInfo = shardInfo;
        }

        public void setSeqNo(long seqNo) {
            this.seqNo = seqNo;
        }

        public void setPrimaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
        }

        public abstract DocWriteResponse build();
    }

    public static enum Result implements Writeable
    {
        CREATED(0),
        UPDATED(1),
        DELETED(2),
        NOT_FOUND(3),
        NOOP(4);

        private final byte op;
        private final String lowercase;

        private Result(int op) {
            this.op = (byte)op;
            this.lowercase = this.name().toLowerCase(Locale.ROOT);
        }

        public byte getOp() {
            return this.op;
        }

        public String getLowercase() {
            return this.lowercase;
        }

        public static Result readFrom(StreamInput in) throws IOException {
            Byte opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    return CREATED;
                }
                case 1: {
                    return UPDATED;
                }
                case 2: {
                    return DELETED;
                }
                case 3: {
                    return NOT_FOUND;
                }
                case 4: {
                    return NOOP;
                }
            }
            throw new IllegalArgumentException("Unknown result code: " + opcode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.op);
        }
    }
}

