/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import org.jmol.c.VDW;
import org.jmol.util.Logger;

public class Elements {
    public static final String[] elementSymbols;
    public static final float[] atomicMass;
    public static final int[] isotopeMass;
    public static final int elementNumberMax;
    public static Map<String, Integer> htElementMap;
    public static final String[] elementNames;
    public static final int ISOTOPE_NUMBER_MASK = 248;
    public static final int ISOTOPE_MASS_OFFSET = 7;
    public static final int ELEMENT_NUMBER_MASK = 127;
    private static final String naturalIsotopes = "1H,12C,14N";
    public static final int firstIsotope = 4;
    private static final int[] altElementNumbers;
    public static final int altElementMax;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;
    public static final String VdwPROBE = "#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733";
    public static final short[] vanderwaalsMars;
    public static final int RAD_COV_IONIC_OB1_100_1 = 0;
    public static final int RAD_COV_BODR_2014_02_22 = 1;
    public static int covalentVersion;
    public static int bondingVersion;
    public static final short[] defaultBondingMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    private static final short[] cationLookupTable;
    private static final short[] anionLookupTable;
    private static final BS bsCations;
    private static final BS bsAnions;
    private static final float[] hydrophobicities;
    private static float[] electroNegativities;

    public static int getNaturalIsotope(int elementNumber) {
        return isotopeMass[elementNumber & 0x7F];
    }

    public static float getAtomicMass(int i) {
        return i < 1 || i >= atomicMass.length ? 0.0f : atomicMass[i];
    }

    public static final int elementNumberFromSymbol(String elementSymbol, boolean isSilent) {
        if (htElementMap == null) {
            Integer boxed;
            String symbol;
            Hashtable<String, Integer> map = new Hashtable<String, Integer>();
            int elementNumber = elementNumberMax;
            while (--elementNumber >= 0) {
                symbol = elementSymbols[elementNumber];
                boxed = elementNumber;
                map.put(symbol, boxed);
                if (symbol.length() != 2) continue;
                map.put(symbol.toUpperCase(), boxed);
            }
            int i = altElementMax;
            while (--i >= 4) {
                symbol = altElementSymbols[i];
                boxed = altElementNumbers[i];
                map.put(symbol, boxed);
                if (symbol.length() != 2) continue;
                map.put(symbol.toUpperCase(), boxed);
            }
            map.put("Z", 0);
            htElementMap = map;
        }
        if (elementSymbol == null) {
            return 0;
        }
        Integer boxedAtomicNumber = htElementMap.get(elementSymbol);
        if (boxedAtomicNumber != null) {
            return boxedAtomicNumber;
        }
        if (PT.isDigit(elementSymbol.charAt(0))) {
            int n;
            int isotope;
            int pt = elementSymbol.length() - 2;
            if (pt >= 0 && PT.isDigit(elementSymbol.charAt(pt))) {
                ++pt;
            }
            int n2 = isotope = pt > 0 ? PT.parseInt(elementSymbol.substring(0, pt)) : 0;
            if (isotope > 0 && (n = Elements.elementNumberFromSymbol(elementSymbol.substring(pt), true)) > 0) {
                isotope = Elements.getAtomicAndIsotopeNumber(n, isotope);
                htElementMap.put(elementSymbol.toUpperCase(), isotope);
                return isotope;
            }
        }
        if (!isSilent) {
            Logger.error("'" + elementSymbol + "' is not a recognized symbol");
        }
        return 0;
    }

    public static final String elementSymbolFromNumber(int elemNo) {
        int isoNumber = 0;
        if (elemNo >= elementNumberMax) {
            int j = altElementMax;
            while (--j >= 0) {
                if (elemNo != altElementNumbers[j]) continue;
                return altElementSymbols[j];
            }
            isoNumber = Elements.getIsotopeNumber(elemNo);
            return "" + isoNumber + Elements.getElementSymbol(elemNo %= 128);
        }
        return Elements.getElementSymbol(elemNo);
    }

    private static String getElementSymbol(int elemNo) {
        if (elemNo < 0 || elemNo >= elementNumberMax) {
            elemNo = 0;
        }
        return elementSymbols[elemNo];
    }

    public static final String elementNameFromNumber(int elementNumber) {
        if (elementNumber >= elementNumberMax) {
            int j = altElementMax;
            while (--j >= 0) {
                if (elementNumber != altElementNumbers[j]) continue;
                return altElementNames[j];
            }
            elementNumber %= 128;
        }
        if (elementNumber < 0 || elementNumber >= elementNumberMax) {
            elementNumber = 0;
        }
        return elementNames[elementNumber];
    }

    public static final int elementNumberFromName(String name) {
        for (int i = 1; i < elementNumberMax; ++i) {
            if (!elementNames[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public static final String altElementNameFromIndex(int i) {
        return altElementNames[i];
    }

    public static final int altElementNumberFromIndex(int i) {
        return altElementNumbers[i];
    }

    public static final String altElementSymbolFromIndex(int i) {
        return altElementSymbols[i];
    }

    public static final String altIsotopeSymbolFromIndex(int i) {
        int code = altElementNumbers[i];
        return (code >> 7) + Elements.elementSymbolFromNumber(code & 0x7F);
    }

    public static final String altIsotopeSymbolFromIndex2(int i) {
        int code = altElementNumbers[i];
        return Elements.elementSymbolFromNumber(code & 0x7F) + (code >> 7);
    }

    public static final int getElementNumber(int atomicAndIsotopeNumber) {
        return atomicAndIsotopeNumber & 0x7F;
    }

    public static final int getIsotopeNumber(int atomicAndIsotopeNumber) {
        return (atomicAndIsotopeNumber & 0xF8) >> 7;
    }

    public static final int getAtomicAndIsotopeNumber(int n, int mass) {
        return (n < 0 ? 0 : n) + (mass <= 0 ? 0 : mass << 7);
    }

    public static final int altElementIndexFromNumber(int atomicAndIsotopeNumber) {
        for (int i = 0; i < altElementMax; ++i) {
            if (altElementNumbers[i] != atomicAndIsotopeNumber) continue;
            return i;
        }
        return 0;
    }

    public static final boolean isNaturalIsotope(String isotopeSymbol) {
        return naturalIsotopes.indexOf(isotopeSymbol + ",") >= 0;
    }

    public static float getBondingRadius(int atomicNumberAndIsotope, int charge) {
        int atomicNumber = atomicNumberAndIsotope & 0x7F;
        return charge > 0 && bsCations.get(atomicNumber) ? Elements.getBondingRadFromTable(atomicNumber, charge, cationLookupTable) : (charge < 0 && bsAnions.get(atomicNumber) ? Elements.getBondingRadFromTable(atomicNumber, charge, anionLookupTable) : (float)defaultBondingMars[(atomicNumber << 1) + bondingVersion] / 1000.0f);
    }

    public static float getCovalentRadius(int atomicNumberAndIsotope) {
        return (float)defaultBondingMars[((atomicNumberAndIsotope & 0x7F) << 1) + covalentVersion] / 1000.0f;
    }

    public static float getBondingRadFromTable(int atomicNumber, int charge, short[] table) {
        int ionic = (atomicNumber << 4) + (charge + 4);
        int iVal = 0;
        int iMid = 0;
        int iMin = 0;
        int iMax = table.length / 2;
        while (iMin != iMax) {
            iMid = (iMin + iMax) / 2;
            iVal = table[iMid << 1];
            if (iVal > ionic) {
                iMax = iMid;
                continue;
            }
            if (iVal < ionic) {
                iMin = iMid + 1;
                continue;
            }
            return (float)table[(iMid << 1) + 1] / 1000.0f;
        }
        if (iVal > ionic) {
            --iMid;
        }
        if (atomicNumber != (iVal = table[iMid << 1]) >> 4) {
            ++iMid;
        }
        return (float)table[(iMid << 1) + 1] / 1000.0f;
    }

    public static int getVanderwaalsMar(int atomicAndIsotopeNumber, VDW type) {
        return vanderwaalsMars[((atomicAndIsotopeNumber & 0x7F) << 2) + type.pt % 4];
    }

    public static float getHydrophobicity(int i) {
        return i < 1 || i >= hydrophobicities.length ? 0.0f : hydrophobicities[i];
    }

    public static float getAllredRochowElectroNeg(int elemno) {
        return elemno > 0 && elemno < electroNegativities.length ? electroNegativities[elemno] : 0.0f;
    }

    public static boolean isElement(int atomicAndIsotopeNumber, int elemNo) {
        return (atomicAndIsotopeNumber & 0x7F) == elemNo;
    }

    static {
        int i;
        elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
        atomicMass = new float[]{0.0f, 1.008f, 4.002f, 6.9675f, 9.012f, 10.8135f, 12.0106f, 14.006f, 15.999f, 18.998f, 20.1797f, 22.989f, 24.307f, 26.981f, 28.084f, 30.973f, 32.059f, 35.4515f, 39.948f, 39.0983f, 40.078f, 44.955f, 47.867f, 50.9415f, 51.9961f, 54.938f, 55.845f, 58.933f, 58.6934f, 63.546f, 65.38f, 69.723f, 72.63f, 74.921f, 78.971f, 79.904f, 83.798f, 85.4678f, 87.62f, 88.905f, 91.224f, 92.906f, 95.95f, 98.91f, 101.07f, 102.905f, 106.42f, 107.8682f, 112.414f, 114.818f, 118.71f, 121.76f, 127.6f, 126.904f, 131.293f, 132.905f, 137.327f, 138.905f, 140.116f, 140.907f, 144.242f, 144.9f, 150.36f, 151.964f, 157.25f, 158.925f, 162.5f, 164.93f, 167.259f, 168.934f, 173.054f, 174.9668f, 178.49f, 180.947f, 183.84f, 186.207f, 190.23f, 192.217f, 195.084f, 196.966f, 200.592f, 204.3835f, 207.2f, 208.98f, 210.0f, 210.0f, 222.0f, 223.0f, 226.03f, 227.03f, 232.0377f, 231.035f, 238.028f, 237.05f, 239.1f, 243.1f, 247.1f, 247.1f, 252.1f, 252.1f, 257.1f, 256.1f, 259.1f, 260.1f, 261.0f, 262.0f, 263.0f, 262.0f, 265.0f, 268.0f};
        isotopeMass = new int[]{0, 1, 4, 7, 9, 11, 12, 14, 16, 19, 20, 23, 24, 27, 28, 31, 32, 35, 40, 39, 40, 45, 48, 51, 52, 55, 56, 59, 59, 64, 65, 70, 73, 75, 79, 80, 84, 85, 88, 89, 91, 93, 96, 98, 101, 103, 106, 108, 112, 115, 119, 122, 128, 127, 131, 133, 137, 139, 140, 141, 144, 145, 150, 152, 157, 159, 163, 165, 167, 169, 173, 175, 179, 181, 184, 186, 190, 192, 195, 197, 201, 204, 207, 209, 209, 210, 222, 223, 226, 227, 232, 231, 238, 237, 244, 243, 247, 247, 251, 252, 257, 258, 259, 260, 261, 262, 263, 262, 265, 268};
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        altElementNumbers = new int[]{0, 13, 16, 55, 257, 385, 1414, 1670, 1798, 1927};
        altElementMax = altElementNumbers.length;
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "11C", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", "", ""};
        vanderwaalsMars = new short[]{1000, 1000, 1000, 1000, 1200, 1100, 1100, 1200, 1400, 1400, 2200, 1400, 1820, 1810, 1220, 2200, 1700, 1530, 628, 1900, 2080, 1920, 1548, 1800, 1950, 1700, 1548, 1700, 1850, 1550, 1400, 1600, 1700, 1520, 1348, 1550, 1730, 1470, 1300, 1500, 1540, 1540, 2020, 1540, 2270, 2270, 2200, 2400, 1730, 1730, 1500, 2200, 2050, 1840, 1500, 2100, 2100, 2100, 2200, 2100, 2080, 1800, 1880, 1950, 2000, 1800, 1808, 1800, 1970, 1750, 1748, 1800, 1880, 1880, 2768, 1880, 2750, 2750, 2388, 2800, 1973, 2310, 1948, 2400, 1700, 2300, 1320, 2300, 1700, 2150, 1948, 2150, 1700, 2050, 1060, 2050, 1700, 2050, 1128, 2050, 1700, 2050, 1188, 2050, 1700, 2050, 1948, 2050, 1700, 2000, 1128, 2000, 1630, 2000, 1240, 2000, 1400, 2000, 1148, 2000, 1390, 2100, 1148, 2100, 1870, 1870, 1548, 2100, 1700, 2110, 3996, 2100, 1850, 1850, 828, 2050, 1900, 1900, 900, 1900, 2100, 1830, 1748, 1900, 2020, 2020, 1900, 2020, 1700, 3030, 2648, 2900, 1700, 2490, 2020, 2550, 1700, 2400, 1608, 2400, 1700, 2300, 1420, 2300, 1700, 2150, 1328, 2150, 1700, 2100, 1748, 2100, 1700, 2050, 1800, 2050, 1700, 2050, 1200, 2050, 1700, 2000, 1220, 2000, 1630, 2050, 1440, 2050, 1720, 2100, 1548, 2100, 1580, 2200, 1748, 2200, 1930, 2200, 1448, 2200, 2170, 1930, 1668, 2250, 2200, 2170, 1120, 2200, 2060, 2060, 1260, 2100, 2150, 1980, 1748, 2100, 2160, 2160, 2100, 2160, 1700, 3430, 3008, 3000, 1700, 2680, 2408, 2700, 1700, 2500, 1828, 2500, 1700, 2480, 1860, 2480, 1700, 2470, 1620, 2470, 1700, 2450, 1788, 2450, 1700, 2430, 1760, 2430, 1700, 2420, 1740, 2420, 1700, 2400, 1960, 2400, 1700, 2380, 1688, 2380, 1700, 2370, 1660, 2370, 1700, 2350, 1628, 2350, 1700, 2330, 1608, 2330, 1700, 2320, 1588, 2320, 1700, 2300, 1568, 2300, 1700, 2280, 1540, 2280, 1700, 2270, 1528, 2270, 1700, 2250, 1400, 2250, 1700, 2200, 1220, 2200, 1700, 2100, 1260, 2100, 1700, 2050, 1300, 2050, 1700, 2000, 1580, 2000, 1700, 2000, 1220, 2000, 1720, 2050, 1548, 2050, 1660, 2100, 1448, 2100, 1550, 2050, 1980, 2050, 1960, 1960, 1708, 2200, 2020, 2020, 2160, 2300, 1700, 2070, 1728, 2300, 1700, 1970, 1208, 2000, 1700, 2020, 1120, 2000, 1700, 2200, 2300, 2000, 1700, 3480, 3240, 2000, 1700, 2830, 2568, 2000, 1700, 2000, 2120, 2000, 1700, 2400, 1840, 2400, 1700, 2000, 1600, 2000, 1860, 2300, 1748, 2300, 1700, 2000, 1708, 2000, 1700, 2000, 1668, 2000, 1700, 2000, 1660, 2000, 1700, 2000, 1648, 2000, 1700, 2000, 1640, 2000, 1700, 2000, 1628, 2000, 1700, 2000, 1620, 2000, 1700, 2000, 1608, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1588, 2000, 1700, 2000, 1580, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000};
        covalentVersion = 1;
        bondingVersion = 0;
        defaultBondingMars = new short[]{0, 0, 230, 320, 930, 460, 680, 1330, 350, 1020, 830, 850, 680, 750, 680, 710, 680, 630, 640, 640, 1120, 670, 970, 1550, 1100, 1390, 1350, 1260, 1200, 1160, 750, 1110, 1020, 1030, 990, 990, 1570, 960, 1330, 1960, 990, 1710, 1440, 1480, 1470, 1360, 1330, 1340, 1350, 1220, 1350, 1190, 1340, 1160, 1330, 1110, 1500, 1100, 1520, 1120, 1450, 1180, 1220, 1240, 1170, 1210, 1210, 1210, 1220, 1160, 1210, 1140, 1910, 1170, 1470, 2100, 1120, 1850, 1780, 1630, 1560, 1540, 1480, 1470, 1470, 1380, 1350, 1280, 1400, 1250, 1450, 1250, 1500, 1200, 1590, 1280, 1690, 1360, 1630, 1420, 1460, 1400, 1460, 1400, 1470, 1360, 1400, 1330, 1980, 1310, 1670, 2320, 1340, 1960, 1870, 1800, 1830, 1630, 1820, 1760, 1810, 1740, 1800, 1730, 1800, 1720, 1990, 1680, 1790, 1690, 1760, 1680, 1750, 1670, 1740, 1660, 1730, 1650, 1720, 1640, 1940, 1700, 1720, 1620, 1570, 1520, 1430, 1460, 1370, 1370, 1350, 1310, 1370, 1290, 1320, 1220, 1500, 1230, 1500, 1240, 1700, 1330, 1550, 1440, 1540, 1440, 1540, 1510, 1680, 1450, 1700, 1470, 2400, 1420, 2000, 2230, 1900, 2010, 1880, 1860, 1790, 1750, 1610, 1690, 1580, 1700, 1550, 1710, 1530, 1720, 1510, 1660, 1500, 1660, 1500, 1680, 1500, 1680, 1500, 1650, 1500, 1670, 1500, 1730, 1500, 1760, 1500, 1610, 1600, 1570, 1600, 1490, 1600, 1430, 1600, 1410, 1600, 1340, 1600, 1290};
        cationLookupTable = new short[]{53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 680, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920};
        anionLookupTable = new short[]{19, 1540, 96, 2600, 113, 1710, 130, 1360, 131, 680, 147, 1330, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1980, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200};
        bsCations = new BS();
        bsAnions = new BS();
        for (i = 0; i < anionLookupTable.length; i += 2) {
            bsAnions.set(anionLookupTable[i] >> 4);
        }
        for (i = 0; i < cationLookupTable.length; i += 2) {
            bsCations.set(cationLookupTable[i] >> 4);
        }
        hydrophobicities = new float[]{0.0f, 0.62f, -2.53f, -0.78f, -0.9f, 0.29f, -0.85f, -0.74f, 0.48f, -0.4f, 1.38f, 1.06f, -1.5f, 0.64f, 1.19f, 0.12f, -0.18f, -0.05f, 0.81f, 0.26f, 1.08f};
        if (elementNames.length != elementNumberMax || vanderwaalsMars.length >> 2 != elementNumberMax || defaultBondingMars.length >> 1 != elementNumberMax) {
            Logger.error("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + elementSymbols.length + "\n elementNames.length=" + elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + defaultBondingMars.length);
        }
        electroNegativities = new float[]{0.0f, 2.2f, 0.0f, 0.97f, 1.47f, 2.01f, 2.5f, 3.07f, 3.5f, 4.1f, 0.0f, 1.01f, 1.23f, 1.47f, 1.74f, 2.06f, 2.44f, 2.83f, 0.0f, 0.91f, 1.04f, 1.2f, 1.32f, 1.45f, 1.56f, 1.6f, 1.64f, 1.7f, 1.75f, 1.75f, 1.66f, 1.82f, 2.02f, 2.2f, 2.48f, 2.74f, 0.0f, 0.89f, 0.99f, 1.11f, 1.22f, 1.23f, 1.3f, 1.36f, 1.42f, 1.45f, 1.35f, 1.42f, 1.46f, 1.49f, 1.72f, 1.82f, 2.01f, 2.21f};
    }
}

