/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.util.Map;
import javajs.util.BS;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SpaceGroupFinder;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.symmetry.WyckoffFinder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    SpaceGroup spaceGroup;
    private PointGroup pointGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private CIPChirality cip;
    private static WyckoffFinder wyckoffFinder;
    private boolean isBio;
    private SymmetryDesc desc;
    private static SymmetryDesc nullDesc;
    private static Map<String, Object> aflowStructures;
    private static Map<String, Object>[] itaData;
    private static Lst<Object> allDataITA;
    private static Lst<Object> listDataITA;

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface siLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, int maxAtoms, boolean localEnvOnly) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, center, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance, maxAtoms, localEnvOnly);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, float scale) {
        if (drawID == null && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (drawID == null && this.pointGroup.isDrawType(type, index, scale)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, drawID, asInfo, type, index, scale);
    }

    @Override
    public void setSpaceGroup(boolean doNormalize) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, doNormalize, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String xyz, int opId) {
        return this.spaceGroup.addSymmetry(xyz, opId, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 mat, boolean isReverse) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((isReverse ? "!" : "") + "[[bio" + mat, 0, false);
    }

    @Override
    public void setLattice(int latt) {
        this.spaceGroup.setLatticeParam(latt);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public boolean createSpaceGroup(int desiredSpaceGroupIndex, String name, Object data, int modDim) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(desiredSpaceGroupIndex, name, data, modDim);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo());
        }
        return this.spaceGroup != null;
    }

    @Override
    public Object getSpaceGroupInfoObj(String name, float[] params, boolean isFull, boolean addNonstandard) {
        return SpaceGroup.getInfo(this.spaceGroup, name, params, isFull, addNonstandard);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(int dim, String name, P3[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize, String filterSymop) {
        if (name != null && (name.startsWith("bio") || name.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = name;
        }
        if (filterSymop != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.operations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!filterSymop.contains(" " + (i + 1) + " ")) continue;
                lst.addLast(this.spaceGroup.operations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, name + " *(" + filterSymop.trim() + ")", lst, -1);
        }
        this.spaceGroup.setFinalOperationsForAtoms(dim, atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    @Override
    public M4 getSpaceGroupOperation(int i) {
        return this.spaceGroup == null || this.spaceGroup.operations == null || i >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[i] : this.spaceGroup.finalOperations[i]);
    }

    @Override
    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.getXyz(i, doNormalize);
    }

    @Override
    public void newSpaceGroupPoint(P3 pt, int i, M4 o, int transX, int transY, int transZ, P3 retPoint) {
        if (o == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation op = this.spaceGroup.operations[i];
            if (!op.isFinalized) {
                op.doFinalize();
            }
            o = op;
        }
        Symmetry.newPoint(o == null ? this.spaceGroup.finalOperations[i] : o, pt, transX, transY, transZ, retPoint);
    }

    @Override
    public V3[] rotateAxes(int iop, V3[] axes, P3 ptTemp, M3 mTemp) {
        return iop == 0 ? axes : this.spaceGroup.finalOperations[iop].rotateAxes(axes, this.unitCell, ptTemp, mTemp);
    }

    @Override
    public String getSpaceGroupOperationCode(int iOp) {
        return this.spaceGroup.operations[iOp].subsystemCode;
    }

    @Override
    public void setTimeReversal(int op, int val) {
        this.spaceGroup.operations[op].setTimeReversal(val);
    }

    @Override
    public int getSpinOp(int op) {
        return this.spaceGroup.operations[op].getMagneticOp();
    }

    @Override
    public boolean addLatticeVectors(Lst<float[]> lattvecs) {
        return this.spaceGroup.addLatticeVectors(lattvecs);
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Lst<P3> getLatticeCentering() {
        return SymmetryOperation.getLatticeCentering(this.getSymmetryOperations());
    }

    @Override
    public Matrix getOperationRsVs(int iop) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[iop].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 pt) {
        return this.spaceGroup.getSiteMultiplicity(pt, this.unitCell);
    }

    @Override
    public String addSubSystemOp(String code, Matrix rs, Matrix vs, Matrix sigma) {
        this.spaceGroup.isSSG = true;
        String s = SymmetryOperation.getXYZFromRsVs(rs, vs, false);
        int i = this.spaceGroup.addSymmetry(s, -1, true);
        this.spaceGroup.operations[i].setSigma(code, sigma);
        return s;
    }

    @Override
    public String getMatrixFromString(String xyz, float[] rotTransMatrix, boolean allowScaling, int modDim) {
        return SymmetryOperation.getMatrixFromString(null, xyz, rotTransMatrix, allowScaling, true, true);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public String getSpaceGroupNameType(String type) {
        return this.spaceGroup == null ? null : this.spaceGroup.getNameType(type, this);
    }

    @Override
    public void setSpaceGroupName(String name) {
        if (this.spaceGroup != null) {
            this.spaceGroup.setName(name);
        }
    }

    @Override
    public char getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? (char)'P' : this.spaceGroup.latticeType);
    }

    @Override
    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.intlTableNumber);
    }

    @Override
    public String getIntTableNumberFull() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNoFull : (this.spaceGroup == null ? null : (this.spaceGroup.intlTableNumberFull != null ? this.spaceGroup.intlTableNumberFull : this.spaceGroup.intlTableNumber));
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.infoStr;
        }
        if (this.spaceGroup == null) {
            return "";
        }
        this.symmetryInfo = new SymmetryInfo();
        this.symmetryInfo.setSymmetryInfo(null, this.getUnitCellParams(), this.spaceGroup);
        return this.symmetryInfo.infoStr;
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    public SymmetryOperation[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        this.spaceGroup.setFinalOperations();
        return this.spaceGroup.finalOperations;
    }

    @Override
    public int getAdditionalOperationsCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null && this.symmetryInfo.getAdditionalOperations() != null ? this.symmetryInfo.additionalOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.getAdditionalOperationsCount() : 0);
    }

    @Override
    public M4[] getAdditionalOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.getAdditionalOperations();
        }
        this.getSymmetryOperations();
        return this.spaceGroup.getAdditionalOperations();
    }

    @Override
    public boolean isSimple() {
        return this.spaceGroup == null && (this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null);
    }

    @Override
    public SymmetryInterface setSymmetryInfo(int modelIndex, Map<String, Object> modelAuxiliaryInfo, float[] unitCellParams) {
        this.symmetryInfo = new SymmetryInfo();
        float[] params = this.symmetryInfo.setSymmetryInfo(modelAuxiliaryInfo, unitCellParams, null);
        if (params != null) {
            this.setUnitCellFromParams(params, modelAuxiliaryInfo.containsKey("jmolData"), Float.NaN);
            this.unitCell.moreInfo = (Lst)modelAuxiliaryInfo.get("moreUnitCellInfo");
            modelAuxiliaryInfo.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)modelAuxiliaryInfo.get("unitCellOffset"));
            M3 matUnitCellOrientation = (M3)modelAuxiliaryInfo.get("matUnitCellOrientation");
            if (matUnitCellOrientation != null) {
                this.initializeOrientation(matUnitCellOrientation);
            }
            if (Logger.debugging) {
                Logger.debug("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true, true));
            }
        }
        return this;
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public SymmetryInterface setUnitCellFromParams(float[] unitCellParams, boolean setRelative, float slop) {
        if (unitCellParams == null) {
            unitCellParams = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        this.unitCell = UnitCell.fromParams(unitCellParams, setRelative, slop);
        this.unitCell.setPrecision(slop);
        return this;
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface uc2) {
        return ((Symmetry)uc2).unitCell.isSameAs(this.unitCell);
    }

    @Override
    public String getUnitCellState() {
        if (this.unitCell == null) {
            return "";
        }
        return this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false, true);
    }

    @Override
    public void initializeOrientation(M3 mat) {
        this.unitCell.initOrientation(mat);
    }

    @Override
    public void unitize(T3 ptFrac) {
        this.unitCell.unitize(ptFrac);
    }

    @Override
    public void toUnitCell(T3 pt, T3 offset) {
        this.unitCell.toUnitCell(pt, offset);
    }

    @Override
    public void toUnitCellRnd(T3 pt, T3 offset) {
        this.unitCell.toUnitCellRnd(pt, offset);
    }

    @Override
    public P3 toSupercell(P3 fpt) {
        return this.unitCell.toSupercell(fpt);
    }

    @Override
    public void toFractional(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toFractional(pt, ignoreOffset);
        }
    }

    @Override
    public void toFractionalM(M4 m) {
        if (!this.isBio) {
            this.unitCell.toFractionalM(m);
        }
    }

    @Override
    public void toCartesian(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toCartesian(pt, ignoreOffset);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean vectorsOnly) {
        return this.unitCell.getUnitCellAsArray(vectorsOnly);
    }

    @Override
    public Tensor getTensor(Viewer vwr, float[] parBorU) {
        if (parBorU == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromParams(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true, 1.0E-4f);
        }
        return this.unitCell.getTensor(vwr, parBorU);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(T3 pt) {
        this.unitCell.setOffset(pt);
    }

    @Override
    public void setOffset(int nnn) {
        P3 pt = new P3();
        SimpleUnitCell.ijkToPoint3f(nnn, pt, 0, 0);
        this.unitCell.setOffset(pt);
    }

    @Override
    public T3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public SymmetryInterface getUnitCellMultiplied() {
        UnitCell uc = this.unitCell.getUnitCellMultiplied();
        if (uc == this.unitCell) {
            return this;
        }
        Symmetry s = new Symmetry();
        s.unitCell = uc;
        return s;
    }

    @Override
    public P3[] getCanonicalCopy(float scale, boolean withOffset) {
        return this.unitCell.getCanonicalCopy(scale, withOffset);
    }

    @Override
    public float getUnitCellInfoType(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    @Override
    public String getUnitCellInfo(boolean scaled) {
        return this.unitCell.dumpInfo(false, scaled);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
        return this.unitCell.checkDistance(f1, f2, distance, dx, iRange, jRange, kRange, ptOffset);
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] oabc, boolean setRelative, String name) {
        if (oabc == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(oabc, setRelative);
        if (name != null) {
            this.unitCell.name = name;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bsAtoms, int[] minmax) {
        try {
            BS bsDelete = new BS();
            int iAtom0 = bsAtoms.nextSetBit(0);
            JmolMolecule[] molecules = modelSet.getMolecules();
            int moleculeCount = molecules.length;
            Atom[] atoms = modelSet.at;
            boolean isOneMolecule = molecules[moleculeCount - 1].firstAtomIndex == modelSet.am[atoms[iAtom0].mi].firstAtomIndex;
            P3 center = new P3();
            boolean centroidPacked = minmax[6] == 1;
            int i = moleculeCount;
            block2: while (--i >= 0 && bsAtoms.get(molecules[i].firstAtomIndex)) {
                BS bs = molecules[i].atomList;
                center.set(0.0f, 0.0f, 0.0f);
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (isOneMolecule || centroidPacked) {
                        center.setT(atoms[j]);
                        if (this.isNotCentroid(center, 1, minmax, centroidPacked)) {
                            if (isOneMolecule) {
                                bsDelete.set(j);
                            }
                        } else if (!isOneMolecule) {
                            continue block2;
                        }
                    } else {
                        center.add(atoms[j]);
                        ++n;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                if (!centroidPacked && (n <= 0 || !this.isNotCentroid(center, n, minmax, false))) continue;
                bsDelete.or(bs);
            }
            return bsDelete;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 center, int n, int[] minmax, boolean centroidPacked) {
        center.scale(1.0f / (float)n);
        this.toFractional(center, false);
        if (centroidPacked) {
            return (double)center.x + 5.0E-6 <= (double)minmax[0] || (double)center.x - 5.0E-6 > (double)minmax[3] || (double)center.y + 5.0E-6 <= (double)minmax[1] || (double)center.y - 5.0E-6 > (double)minmax[4] || (double)center.z + 5.0E-6 <= (double)minmax[2] || (double)center.z - 5.0E-6 > (double)minmax[5];
        }
        return (double)center.x + 5.0E-6 <= (double)minmax[0] || (double)center.x + 5.0E-5 > (double)minmax[3] || (double)center.y + 5.0E-6 <= (double)minmax[1] || (double)center.y + 5.0E-5 > (double)minmax[4] || (double)center.z + 5.0E-6 <= (double)minmax[2] || (double)center.z + 5.0E-5 > (double)minmax[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        if (modelSet == null) {
            return nullDesc == null ? (nullDesc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", null, "modelkit")) : nullDesc;
        }
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc).set(modelSet);
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, int iatom, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options, int[] opList) {
        return this.getDesc(modelSet).getSymopInfo(iatom, xyz, op, translation, pt, pt2, id, type, scaleFactor, nth, options, opList);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String sgName, int modelIndex, boolean isFull, float[] cellParams) {
        Map<String, Object> info;
        boolean isForModel;
        boolean bl = isForModel = sgName == null;
        if (sgName == null && (info = modelSet.getModelAuxiliaryInfo(modelSet.vwr.am.cmi)) != null) {
            sgName = (String)info.get("spaceGroup");
        }
        SymmetryInterface cellInfo = null;
        if (cellParams != null) {
            cellInfo = new Symmetry().setUnitCellFromParams(cellParams, false, Float.NaN);
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, modelIndex, sgName, 0, null, null, null, 0.0f, -1, isFull, isForModel, 0, cellInfo, null);
    }

    @Override
    public String fcoord(T3 p) {
        return SymmetryOperation.fcoord(p);
    }

    @Override
    public T3[] getV0abc(Object def, M4 retMatrix) {
        return this.unitCell == null ? null : this.unitCell.getV0abc(def, retMatrix);
    }

    @Override
    public Quat getQuaternionRotation(String abc) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(abc);
    }

    @Override
    public P3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public boolean getState(ModelSet ms, int modelIndex, SB commands) {
        T3 ptm;
        boolean isAssigned = ms.getInfo(modelIndex, "spaceGroupAssigned") != null;
        P3 pt = this.getFractionalOffset();
        boolean loadUC = false;
        if (pt != null && (pt.x != 0.0f || pt.y != 0.0f || pt.z != 0.0f)) {
            commands.append("; set unitcell ").append(Escape.eP(pt));
            loadUC = true;
        }
        if ((ptm = this.getUnitCellMultiplier()) != null) {
            commands.append("; set unitcell ").append(SimpleUnitCell.escapeMultiplier(ptm));
            loadUC = true;
        }
        String sg = (String)ms.getInfo(modelIndex, "spaceGroup");
        if (isAssigned && sg != null) {
            commands.append("\n UNITCELL " + Escape.e(ms.getUnitCell(modelIndex).getUnitCellVectors()));
            commands.append("\n MODELKIT SPACEGROUP " + PT.esc(sg));
            commands.append("\n UNITCELL " + Escape.e(ms.getUnitCell(modelIndex).getUnitCellVectors()));
            loadUC = true;
        }
        return loadUC;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer vwr, Atom atom, BS bsAtoms, float radius) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", vwr, "script")).set(this, atom, vwr.ms.at, bsAtoms, radius);
    }

    @Override
    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] oabc, M3 primitiveToCrystal) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(oabc, false);
        }
        return this.unitCell.toFromPrimitive(toPrimitive, type, oabc, primitiveToCrystal);
    }

    @Override
    public Lst<P3> generateCrystalClass(P3 pt00) {
        P3 pt0;
        SymmetryOperation[] ops = this.getSymmetryOperations();
        Lst<P3> lst = new Lst<P3>();
        boolean isRandom = pt00 == null;
        float rand1 = 0.0f;
        float rand2 = 0.0f;
        float rand3 = 0.0f;
        if (isRandom) {
            rand1 = (float)Math.E;
            rand2 = (float)Math.PI;
            rand3 = (float)Math.log10(2000.0);
            pt0 = P3.new3(rand1 + 1.0f, rand2 + 2.0f, rand3 + 3.0f);
        } else {
            pt0 = P3.newP(pt00);
        }
        if (ops == null || this.unitCell == null) {
            lst.addLast(pt0);
        } else {
            this.unitCell.toFractional(pt0, true);
            P3 pt1 = null;
            P3 pt2 = null;
            if (isRandom) {
                pt1 = P3.new3(rand2 + 4.0f, rand3 + 5.0f, rand1 + 6.0f);
                this.unitCell.toFractional(pt1, true);
                pt2 = P3.new3(rand3 + 7.0f, rand1 + 8.0f, rand2 + 9.0f);
                this.unitCell.toFractional(pt2, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator iter = bspt.allocateCubeIterator();
            P3 pt = new P3();
            int i = ops.length;
            while (--i >= 0) {
                ops[i].rotate2(pt0, pt);
                iter.initialize(pt, 0.001f, false);
                if (iter.hasMoreElements()) continue;
                P3 ptNew = P3.newP(pt);
                lst.addLast(ptNew);
                bspt.addTuple(ptNew);
                if (!isRandom) continue;
                if (pt2 != null) {
                    ops[i].rotate2(pt2, pt);
                    lst.addLast(P3.newP(pt));
                }
                if (pt1 == null) continue;
                ops[i].rotate2(pt1, pt);
                lst.addLast(P3.newP(pt));
            }
            int j = lst.size();
            while (--j >= 0) {
                pt = (P3)lst.get(j);
                if (isRandom) {
                    pt.scale(0.5f);
                }
                this.unitCell.toCartesian(pt, true);
            }
        }
        return lst;
    }

    @Override
    public void calculateCIPChiralityForAtoms(Viewer vwr, BS bsAtoms) {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        String dataClass = vwr.getBoolean(603979960) ? "CIPData" : "CIPDataTracker";
        CIPData data = ((CIPData)Interface.getInterface("org.jmol.symmetry." + dataClass, vwr, "script")).set(vwr, bsAtoms);
        data.setRule6Full(vwr.getBoolean(603979823));
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
    }

    @Override
    public String[] calculateCIPChiralityForSmiles(Viewer vwr, String smiles) throws Exception {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        CIPDataSmiles data = ((CIPDataSmiles)Interface.getInterface("org.jmol.symmetry.CIPDataSmiles", vwr, "script")).setAtomsForSmiles(vwr, smiles);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
        return data.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer vwr) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface("org.jmol.symmetry.CIPChirality", vwr, "script")) : this.cip;
    }

    @Override
    public T3[] getConventionalUnitCell(String latticeType, M3 primitiveToCrystal) {
        return this.unitCell == null || latticeType == null ? null : this.unitCell.getConventionalUnitCell(latticeType, primitiveToCrystal);
    }

    @Override
    public Map<String, Object> getUnitCellInfoMap() {
        return this.unitCell == null ? null : this.unitCell.getInfo();
    }

    @Override
    public void setUnitCell(SymmetryInterface uc) {
        this.unitCell = UnitCell.cloneUnitCell(((Symmetry)uc).unitCell);
    }

    @Override
    public Object findSpaceGroup(Viewer vwr, BS atoms, String xyzList, float[] unitCellParams, T3 origin, boolean asString, boolean isAssign, boolean checkSupercell) {
        return ((SpaceGroupFinder)Interface.getInterface("org.jmol.symmetry.SpaceGroupFinder", vwr, "eval")).findSpaceGroup(vwr, atoms, xyzList, unitCellParams, origin, this, asString, isAssign, checkSupercell);
    }

    @Override
    public void setSpaceGroupTo(Object sg) {
        this.symmetryInfo = null;
        this.spaceGroup = sg instanceof SpaceGroup ? (SpaceGroup)sg : SpaceGroup.getSpaceGroupFromITAName(sg.toString());
    }

    @Override
    public BS removeDuplicates(ModelSet ms, BS bs, boolean highPrec) {
        UnitCell uc = this.unitCell;
        Atom[] atoms = ms.at;
        float[] occs = ms.occupancies;
        boolean haveOccupancies = occs != null;
        P3[] unitized = new P3[bs.length()];
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            P3 pt = unitized[i] = P3.newP(atoms[i]);
            uc.toFractional(pt, false);
            if (highPrec) {
                uc.unitizeRnd(pt);
            } else {
                uc.unitize(pt);
            }
            i = bs.nextSetBit(i + 1);
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            P3 pt = unitized[i];
            int type = a.getAtomicAndIsotopeNumber();
            float occ = haveOccupancies ? occs[i] : 0.0f;
            int j = bs.nextSetBit(i + 1);
            while (j >= 0) {
                P3 pt2;
                Atom b = atoms[j];
                if (type == b.getAtomicAndIsotopeNumber() && (!haveOccupancies || occ == occs[j]) && pt.distanceSquared(pt2 = unitized[j]) < 1.96E-6f) {
                    bs.clear(j);
                }
                j = bs.nextSetBit(j + 1);
            }
            i = bs.nextSetBit(i + 1);
        }
        return bs;
    }

    @Override
    public Lst<P3> getEquivPoints(Lst<P3> pts, P3 pt, String flags) {
        M4[] ops = this.getSymmetryOperations();
        return ops == null || this.unitCell == null ? null : this.unitCell.getEquivPoints(pt, flags, ops, pts == null ? new Lst<P3>() : pts, 0, 0);
    }

    @Override
    public void getEquivPointList(Lst<P3> pts, int nIgnored, String flags) {
        int i;
        P3 p0;
        int n0;
        boolean tofractional;
        M4[] ops = this.getSymmetryOperations();
        boolean newPt = flags.indexOf("newpt") >= 0;
        boolean zapped = flags.indexOf("zapped") >= 0;
        int n = pts.size();
        boolean bl = tofractional = flags.indexOf("tofractional") >= 0;
        if (flags.indexOf("fromfractional") < 0) {
            for (int i2 = 0; i2 < pts.size(); ++i2) {
                this.toFractional((T3)pts.get(i2), false);
            }
        }
        flags = flags + ",fromfractional,tofractional";
        int check0 = nIgnored > 0 ? 0 : n;
        boolean allPoints = nIgnored == n;
        int n2 = n0 = nIgnored > 0 ? nIgnored : n;
        if (allPoints) {
            --nIgnored;
            --n0;
        }
        if (zapped) {
            n0 = 0;
        }
        P3 p3 = p0 = nIgnored > 0 ? (P3)pts.get(nIgnored) : null;
        if (ops != null || this.unitCell != null) {
            for (i = nIgnored; i < n; ++i) {
                this.unitCell.getEquivPoints((P3)pts.get(i), flags, ops, pts, check0, n0);
            }
        }
        if (!zapped && (pts.size() == nIgnored || pts.get(nIgnored) != p0 || allPoints || newPt)) {
            --n;
        }
        i = n - nIgnored;
        while (--i >= 0) {
            pts.removeItemAt(nIgnored);
        }
        if (!tofractional) {
            i = pts.size();
            while (--i >= nIgnored) {
                this.toCartesian((T3)pts.get(i), false);
            }
        }
    }

    @Override
    public int[] getInvariantSymops(P3 pt, int[] v0) {
        SymmetryOperation[] ops = this.getSymmetryOperations();
        if (ops == null) {
            return new int[0];
        }
        BS bs = new BS();
        P3 p = new P3();
        P3 p0 = new P3();
        int nops = ops.length;
        for (int i = 1; i < nops; ++i) {
            p.setT(pt);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
            p0.setT(p);
            ops[i].rotTrans(p);
            this.unitCell.unitize(p);
            if (!(p0.distanceSquared(p) < 1.96E-6f)) continue;
            bs.set(i);
        }
        int[] ret = new int[bs.cardinality()];
        if (v0 != null && ret.length != v0.length) {
            return null;
        }
        int k = 0;
        for (int i = 1; i < nops; ++i) {
            boolean isOK = bs.get(i);
            if (!isOK) continue;
            if (v0 != null && v0[k] != i + 1) {
                return null;
            }
            ret[k++] = i + 1;
        }
        return ret;
    }

    @Override
    public Object getWyckoffPosition(Viewer vwr, P3 p, String letter) {
        if (this.unitCell == null) {
            return "";
        }
        SpaceGroup sg = this.spaceGroup;
        if (sg == null && this.symmetryInfo != null && (sg = SpaceGroup.determineSpaceGroupN(this.symmetryInfo.sgName)) == null) {
            sg = SpaceGroup.getSpaceGroupFromITAName(this.symmetryInfo.intlTableNoFull);
        }
        if (sg == null || sg.intlTableNumber == null) {
            return "?";
        }
        if (p == null) {
            p = P3.new3(0.45999998f, 0.38333333f, 0.2875f);
        } else {
            p = P3.newP(p);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
        }
        if (wyckoffFinder == null) {
            wyckoffFinder = (WyckoffFinder)Interface.getInterface("org.jmol.symmetry.WyckoffFinder", null, "symmetry");
        }
        try {
            int mode;
            WyckoffFinder w = wyckoffFinder.getWyckoffFinder(vwr, sg.intlTableNumberFull);
            int n = letter == null ? -1 : (letter.equalsIgnoreCase("coord") ? -2 : (letter.equalsIgnoreCase("coords") ? -3 : (mode = letter.endsWith("*") ? (int)letter.charAt(0) : 0)));
            if (mode != 0) {
                return w.getStringInfo(this.unitCell, p, mode);
            }
            if (w.findPositionFor(p, letter) == null) {
                return null;
            }
            this.unitCell.toCartesian(p, false);
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return letter == null ? "?" : null;
        }
    }

    @Override
    public M4 getTransform(P3 fracA, P3 fracB, boolean best) {
        return this.getDesc(null).getTransform(this.unitCell, this.getSymmetryOperations(), fracA, fracB, best);
    }

    static void newPoint(M4 m, P3 atom1, int x, int y, int z, P3 atom2) {
        m.rotTrans2(atom1, atom2);
        atom2.add3(x, y, z);
    }

    @Override
    public boolean isWithinUnitCell(P3 pt, float x, float y, float z) {
        return this.unitCell.isWithinUnitCell(x, y, z, pt);
    }

    @Override
    public boolean checkPeriodic(P3 pt) {
        return this.unitCell.checkPeriodic(pt);
    }

    @Override
    public Object convertOperation(String xyz, M4 matrix) {
        if (matrix == null) {
            float[] a = new float[16];
            SymmetryOperation.getMatrixFromString(null, xyz, a, true, false, true);
            a[3] = a[3] / 12.0f;
            a[7] = a[7] / 12.0f;
            a[11] = a[11] / 12.0f;
            return M4.newA16(a);
        }
        return SymmetryOperation.getXYZFromMatrixFrac(matrix, false, false, false, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getSpaceGroupJSON(Viewer vwr, String name, String sgname, int index) {
        String s0 = sgname;
        try {
            int pt = sgname.indexOf("(");
            boolean isTM = sgname.endsWith(")") && pt > 0;
            String tm = null;
            if (isTM) {
                tm = sgname.substring(pt + 1, sgname.length() - 1);
                sgname = sgname.substring(0, pt);
            }
            int itno = sgname.equalsIgnoreCase("ALL") ? 0 : PT.parseInt(sgname);
            boolean isInt = itno != Integer.MIN_VALUE;
            pt = sgname.indexOf(46);
            if (!isTM && isInt && index == 0 && pt > 0) {
                index = PT.parseInt(sgname.substring(pt + 1));
                sgname = sgname.substring(0, pt);
            }
            if (isInt && (itno > 230 || itno < 0)) {
                throw new ArrayIndexOutOfBoundsException(itno);
            }
            if (name.equalsIgnoreCase("ITA")) {
                int i;
                Map resource;
                if (itno == 0) {
                    if (allDataITA != null) return allDataITA;
                    allDataITA = (Lst)this.getResource(vwr, "sg/json/ita_all.json");
                    return allDataITA;
                }
                if (itno == Integer.MIN_VALUE) {
                    if (listDataITA == null) {
                        listDataITA = (Lst)this.getResource(vwr, "sg/json/ita_list.json");
                    }
                    if (itno == 0) {
                        return allDataITA;
                    }
                }
                if (itaData == null) {
                    itaData = new Map[230];
                }
                if ((resource = itaData[itno - 1]) == null) {
                    Symmetry.itaData[itno - 1] = resource = (Map)this.getResource(vwr, "sg/json/ita_" + itno + ".json");
                }
                if (resource == null) throw new IllegalArgumentException(s0);
                if (index == 0) {
                    return resource;
                }
                Lst its = (Lst)resource.get("its");
                if (its == null) throw new IllegalArgumentException(s0);
                int n = i = isInt ? index : its.size();
                while (--i >= 0) {
                    Map map = (Map)its.get(i);
                    if (i != index - 1 && !sgname.equals(map.get("itaFull")) && (tm == null || !tm.equals(map.get("tm")))) continue;
                    return map;
                }
                if (tm == null) throw new IllegalArgumentException(s0);
            }
            if (!name.equalsIgnoreCase("AFLOW") || tm != null) throw new IllegalArgumentException(s0);
            if (aflowStructures == null) {
                aflowStructures = (Map)this.getResource(vwr, "sg/json/aflow_structures.json");
            }
            if (itno == 0) {
                return aflowStructures;
            }
            System.out.println(sgname + " ? " + index);
            Lst data = (Lst)aflowStructures.get("" + sgname);
            if (index > data.size()) throw new IllegalArgumentException(s0);
            return index == 0 ? data : data.get(index - 1);
            throw new IllegalArgumentException(s0);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private Object getResource(Viewer vwr, String resource) {
        try {
            BufferedReader r = FileManager.getBufferedReaderForResource(vwr, this, "org/jmol/symmetry/", resource);
            String[] data = new String[1];
            if (Rdr.readAllAsString(r, Integer.MAX_VALUE, false, data, 0)) {
                return new JSJSONParser().parse(data[0], true);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    @Override
    public float getCellWeight(P3 pt) {
        return this.unitCell.getCellWeight(pt);
    }

    @Override
    public float getPrecision() {
        return this.unitCell == null ? Float.NaN : this.unitCell.getPrecision();
    }

    @Override
    public void setPrecision(float prec) {
        this.unitCell.setPrecision(prec);
    }

    @Override
    public boolean fixUnitCell(float[] params) {
        return UnitCell.createCompatibleUnitCell(this.spaceGroup, params, null, true);
    }

    @Override
    public void twelfthify(P3 pt) {
        this.unitCell.twelfthify(pt);
    }
}

