/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.freeplane.features.map.NodeAbsolutePath;
import org.freeplane.features.map.NodeModel;

public class NodeRelativePath {
    private final NodeModel commonAncestor;
    private final int[] beginPath;
    private final int[] endPath;

    public static final Comparator<NodeModel> comparator() {
        return new Comparator<NodeModel>(){
            private final HashMap<NodeModel, NodeAbsolutePath> paths = new HashMap();

            @Override
            public int compare(NodeModel o1, NodeModel o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                NodeAbsolutePath absoluteBeginPath = this.getPath(o1);
                NodeAbsolutePath absoluteEndPath = this.getPath(o2);
                return new NodeRelativePath(absoluteBeginPath, absoluteEndPath).compareNodePositions();
            }

            public NodeAbsolutePath getPath(NodeModel node) {
                NodeAbsolutePath path = this.paths.get(node);
                if (path == null) {
                    path = new NodeAbsolutePath(node);
                    this.paths.put(node, path);
                } else {
                    path.reset();
                }
                return path;
            }
        };
    }

    public NodeRelativePath(NodeModel begin, NodeModel end) {
        this(new NodeAbsolutePath(begin), new NodeAbsolutePath(end));
    }

    private NodeRelativePath(NodeAbsolutePath absoluteBeginPath, NodeAbsolutePath absoluteEndPath) {
        NodeModel commonAncestor = null;
        while (absoluteBeginPath.hasNext() && absoluteEndPath.hasNext()) {
            NodeModel nextNodeOnBeginPath = absoluteBeginPath.next();
            if (nextNodeOnBeginPath.equals(absoluteEndPath.next())) {
                commonAncestor = nextNodeOnBeginPath;
                continue;
            }
            absoluteBeginPath.previous();
            absoluteEndPath.previous();
            break;
        }
        this.commonAncestor = commonAncestor;
        int commonAncestorIndex = absoluteBeginPath.lastIndex();
        this.beginPath = this.path(absoluteBeginPath, commonAncestorIndex);
        this.endPath = this.path(absoluteEndPath, commonAncestorIndex);
    }

    private int[] path(NodeAbsolutePath absolutePath, int startingIndex) {
        int[] path = new int[absolutePath.size() - startingIndex - 1];
        if (path.length > 0) {
            for (int i = 0; i < path.length; ++i) {
                NodeModel nodeOnPath = absolutePath.next();
                NodeModel parentNode = nodeOnPath.getParentNode();
                path[i] = parentNode.getIndex(nodeOnPath);
            }
        }
        return path;
    }

    public NodeModel commonAncestor() {
        return this.commonAncestor;
    }

    public NodeModel pathBegin(NodeModel commonAncestor) {
        return this.relativeNode(commonAncestor, this.beginPath, this.beginPath.length);
    }

    public NodeModel pathEnd(NodeModel commonAncestor) {
        return this.relativeNode(commonAncestor, this.endPath, this.endPath.length);
    }

    private NodeModel relativeNode(NodeModel commonAncestor, int[] path, int level) {
        NodeModel relativeNode = commonAncestor;
        for (int position = 0; position < level; ++position) {
            relativeNode = relativeNode.getChildAt(path[position]);
        }
        return relativeNode;
    }

    public NodeModel ancestorForBegin(NodeModel begin) {
        int backLevelNumber = this.beginPath.length;
        return this.ancestor(begin, backLevelNumber);
    }

    private NodeModel ancestor(NodeModel source, int backLevelNumber) {
        NodeModel ancestor = source;
        for (int i = 0; i < backLevelNumber; ++i) {
            if (ancestor == null) {
                return ancestor;
            }
            ancestor = ancestor.getParentNode();
        }
        return ancestor;
    }

    public boolean equalPathsTo(NodeRelativePath nodeRelativePath2) {
        return Arrays.equals(this.beginPath, nodeRelativePath2.beginPath) && Arrays.equals(this.endPath, nodeRelativePath2.endPath);
    }

    public NodeModel beginPathElement(int level) {
        return this.relativeNode(this.commonAncestor, this.beginPath, level);
    }

    public NodeModel endPathElement(int level) {
        return this.relativeNode(this.commonAncestor, this.endPath, level);
    }

    public int getPathLength() {
        return this.beginPath.length + this.endPath.length;
    }

    public int compareNodePositions() {
        if (this.beginPath.length == 0 && this.endPath.length == 0) {
            return 0;
        }
        if (this.beginPath.length == 0) {
            return -1;
        }
        if (this.endPath.length == 0) {
            return 1;
        }
        return Integer.compare(this.beginPath[0], this.endPath[0]);
    }
}

