/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Font;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.svgicons.FixedSizeUIIcon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConjunctConditions;
import org.freeplane.features.filter.condition.DecoratedConditionFactory;
import org.freeplane.features.filter.condition.DisjunctConditions;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConditionFactory {
    public static final String FILTER_CONTAINS = "filter_contains";
    public static final String FILTER_DOES_NOT_EXIST = "filter_does_not_exist";
    public static final String FILTER_EXIST = "filter_exist";
    public static final String FILTER_GE = ">=";
    public static final String FILTER_GT = ">";
    public static final String FILTER_MATCH_CASE = "filter_match_case";
    public static final String FILTER_MATCH_APPROX = "filter_match_approximately";
    public static final String FILTER_IGNORE_DIACRITICS = "filter_ignore_diacritics";
    public static final String FILTER_IS_EQUAL_TO = "filter_is_equal_to";
    public static final String FILTER_STARTS_WITH = "filter_starts_with";
    public static final String FILTER_IS_NOT_EQUAL_TO = "filter_is_not_equal_to";
    public static final String FILTER_LE = "<=";
    public static final String FILTER_LT = "<";
    public static final String FILTER_REGEXP = "filter_regexp_matches";
    private static final DecoratedConditionFactory DECORATED_CONDITION_FACTORY = new DecoratedConditionFactory();
    private final SortedMap<Integer, IElementaryConditionController> conditionControllers = new TreeMap<Integer, IElementaryConditionController>();

    public static JComponent createCellRendererComponent(String description) {
        JCondition component = new JCondition();
        JLabel label = ConditionFactory.createConditionLabel(description);
        component.add(label);
        return component;
    }

    public static JLabel createConditionLabel(String text) {
        JLabel label = new JLabel(text);
        label.setUI((BasicLabelUI)BasicLabelUI.createUI(label));
        return label;
    }

    public static JLabel createConditionLabel(UIIcon uiIcon) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int fontHeight = label.getFontMetrics(font).getHeight();
        label.setIcon(FixedSizeUIIcon.withHeigth(uiIcon.getUrl(), fontHeight, uiIcon.hasStandardSize()));
        label.setHorizontalAlignment(0);
        label.setUI((BasicLabelUI)BasicLabelUI.createUI(label));
        return label;
    }

    public static String createDescription(String attribute, String simpleCondition, String value) {
        return ConditionFactory.createDescription(attribute, simpleCondition, value, false, false, false);
    }

    public static String createDescription(String attribute, String simpleCondition, String value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        String description = attribute + " " + simpleCondition + (value != null ? " \"" + value + "\"" : "") + (matchCase && value != null ? ", " + TextUtils.getText(FILTER_MATCH_CASE) : "") + (matchApproximately && value != null ? ", " + TextUtils.getText(FILTER_MATCH_APPROX) : "" + (ignoreDiacritics && value != null ? ", " + TextUtils.getText(FILTER_IGNORE_DIACRITICS) : ""));
        return description;
    }

    public void addConditionController(int position, IElementaryConditionController controller) {
        IElementaryConditionController old = this.conditionControllers.put(new Integer(position), controller);
        assert (old == null);
    }

    public Iterator<IElementaryConditionController> conditionIterator() {
        Iterator<IElementaryConditionController> iterator = this.conditionControllers.values().iterator();
        return iterator;
    }

    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        return this.getConditionController(selectedItem).createCondition(selectedItem, simpleCond, value, matchCase, matchApproximately, ignoreDiacritics);
    }

    public IElementaryConditionController getConditionController(Object item) {
        Iterator<IElementaryConditionController> iterator = this.conditionIterator();
        while (iterator.hasNext()) {
            IElementaryConditionController next = iterator.next();
            if (!next.canHandle(item)) continue;
            return next;
        }
        throw new NoSuchElementException();
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        ASelectableCondition condition = this.loadAnonymousCondition(element);
        if (condition != null) {
            String userName = element.getAttribute("user_name", null);
            condition.setUserName(userName);
        }
        return condition;
    }

    private ASelectableCondition loadAnonymousCondition(XMLElement element) {
        ASelectableCondition decoratorCondition = DECORATED_CONDITION_FACTORY.createRelativeCondition(this, element);
        if (decoratorCondition != null) {
            return decoratorCondition;
        }
        if (element.getName().equalsIgnoreCase("conjunct_condition")) {
            return ConjunctConditions.load(this, element);
        }
        if (element.getName().equalsIgnoreCase("disjunct_condition")) {
            return DisjunctConditions.load(this, element);
        }
        Iterator<IElementaryConditionController> conditionIterator = this.conditionIterator();
        while (conditionIterator.hasNext()) {
            ASelectableCondition condition = conditionIterator.next().loadCondition(element);
            if (condition == null) continue;
            return condition;
        }
        return null;
    }

    public IElementaryConditionController removeConditionController(int position, IElementaryConditionController controller) {
        IElementaryConditionController old = (IElementaryConditionController)this.conditionControllers.remove(new Integer(position));
        return old;
    }
}

