/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.GrabKeyDialog;
import org.freeplane.core.resources.components.IKeystrokeValidator;
import org.freeplane.core.resources.components.KeyEventTranslator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IAcceleratorChangeListener;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.IKeyStrokeProcessor;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.util.ActionUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.Pair;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;

public class ActionAcceleratorManager
implements IKeyStrokeProcessor,
IAcceleratorMap {
    private static final String SHORTCUT_PROPERTY_PREFIX = "acceleratorFor.";
    private final Map<Pair<ModeController, KeyStroke>, AFreeplaneAction> accelerators = new HashMap<Pair<ModeController, KeyStroke>, AFreeplaneAction>();
    private final Map<Pair<ModeController, String>, KeyStroke> actionMap = new HashMap<Pair<ModeController, String>, KeyStroke>();
    private final Map<FreeplaneActions, Collection<IAcceleratorChangeListener>> changeListenersForActionCollection = new HashMap<FreeplaneActions, Collection<IAcceleratorChangeListener>>();
    private final Properties keysetProps;
    private final Properties defaultProps;
    private final Properties overwritttenDefaultProps = new Properties();
    static final Pattern oldKeyFormatPattern = Pattern.compile("\\$(.*?)\\$0$");

    <V> Pair<ModeController, V> key(V value) {
        return this.key(Controller.getCurrentModeController(), value);
    }

    <V> Pair<ModeController, V> key(ModeController modeController, V value) {
        return new Pair<ModeController, V>(modeController, value);
    }

    public ActionAcceleratorManager() {
        this.loadDefaultAccelerators("/default_accelerators.properties");
        if (Compat.isMacOsX()) {
            this.loadDefaultAccelerators("/default_accelerators_mac.properties");
        }
        this.defaultProps = new Properties();
        this.keysetProps = new Properties(this.defaultProps);
    }

    private void loadDefaultAccelerators(String resource) {
        ResourceController resourceController = ResourceController.getResourceController();
        URL resourceUrl = resourceController.getResource(resource);
        if (resourceUrl == null) {
            return;
        }
        try (BufferedInputStream resourceStream = new BufferedInputStream(resourceUrl.openStream());){
            this.overwritttenDefaultProps.load(resourceStream);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    public void loadAcceleratorPresets() {
        block8: {
            try {
                if (ResourceController.getResourceController().getFreeplaneUserDirectory() == null) break block8;
                File defaultPresetsFile = this.getPresetsFile();
                if (defaultPresetsFile.exists()) {
                    try (FileInputStream inputStream = new FileInputStream(defaultPresetsFile);){
                        this.loadAcceleratorPresets(inputStream);
                        break block8;
                    }
                }
                this.updateAcceleratorsFromUserProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void updateAcceleratorsFromUserProperties() {
        Properties properties = ResourceController.getResourceController().getProperties();
        Iterator<Map.Entry<Object, Object>> propertyIterator = properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<Object, Object> property = propertyIterator.next();
            String key = (String)property.getKey();
            String oldPrefix = "acceleratorFor";
            if (!key.startsWith("acceleratorFor")) continue;
            String newKey = SHORTCUT_PROPERTY_PREFIX + key.substring("acceleratorFor".length()).replaceFirst("\\$", "").replaceFirst("\\$\\d", "");
            String value = (String)property.getValue();
            this.loadAcceleratorPreset(newKey, value, new Properties());
            propertyIterator.remove();
        }
        this.saveAcceleratorPresets();
    }

    public void setAccelerator(AFreeplaneAction action, KeyStroke keyStroke) {
        this.setAccelerator(Controller.getCurrentModeController(), action, keyStroke);
    }

    private void setAccelerator(ModeController modeController, AFreeplaneAction action, KeyStroke keyStroke) {
        AFreeplaneAction oldAction = this.accelerators.get(this.key(modeController, keyStroke));
        if (action == oldAction) {
            return;
        }
        if (keyStroke != null && oldAction != null) {
            if (this.acceleratorIsDefinedByUserProperties(oldAction, modeController, this.keysetProps)) {
                return;
            }
            this.actionMap.remove(this.key(modeController, oldAction.getKey()));
            this.fireAcceleratorChanged(modeController, oldAction, keyStroke, null);
        }
        if (action == null) {
            return;
        }
        if (keyStroke != null) {
            this.accelerators.put(this.key(modeController, keyStroke), action);
        }
        KeyStroke removedAccelerator = this.removeAccelerator(modeController, action);
        String actionKey = action.getKey();
        if (keyStroke != null) {
            this.actionMap.put(this.key(modeController, actionKey), keyStroke);
        }
        this.fireAcceleratorChanged(modeController, action, removedAccelerator, keyStroke);
    }

    @Override
    public void setUserDefinedAccelerator(AFreeplaneAction action) {
        String accelerator;
        String actionKey = action.getKey();
        String shortcutKey = this.getPropertyKey(actionKey);
        if (this.overwritttenDefaultProps.containsKey(shortcutKey)) {
            this.defaultProps.setProperty(shortcutKey, this.overwritttenDefaultProps.getProperty(shortcutKey));
        }
        if ((accelerator = this.getShortcut(shortcutKey)) != null) {
            KeyStroke ks = KeyStroke.getKeyStroke(accelerator);
            this.setAccelerator(action, ks);
        }
    }

    @Override
    public void setDefaultAccelerator(AFreeplaneAction action, String accelerator) {
        String shortcutKey = this.getPropertyKey(action.getKey());
        String registeredAccelerator = this.getShortcut(shortcutKey);
        if (null == registeredAccelerator) {
            if (this.overwritttenDefaultProps.containsKey(shortcutKey)) {
                accelerator = this.overwritttenDefaultProps.getProperty(shortcutKey);
            }
            accelerator = ActionAcceleratorManager.replaceModifiersForMac(accelerator);
            this.defaultProps.setProperty(shortcutKey, accelerator);
            KeyStroke ks = KeyStroke.getKeyStroke(accelerator);
            this.setAccelerator(action, ks);
        } else if (this.getAccelerator(action) == null) {
            KeyStroke ks = KeyStroke.getKeyStroke(registeredAccelerator);
            this.setAccelerator(action, ks);
        }
    }

    @Override
    public void removeActionAccelerator(FreeplaneActions freeplaneActions, AFreeplaneAction action) {
        KeyStroke oldKeystroke = this.removeAccelerator(action);
        this.fireAcceleratorChanged(freeplaneActions, action, oldKeystroke, null);
    }

    public KeyStroke removeAccelerator(AFreeplaneAction action) {
        return this.removeAccelerator(Controller.getCurrentModeController(), action);
    }

    private KeyStroke removeAccelerator(ModeController modeController, AFreeplaneAction action) throws AssertionError {
        AFreeplaneAction oldAction;
        if (action == null) {
            return null;
        }
        String actionKey = action.getKey();
        KeyStroke oldAccelerator = this.actionMap.remove(this.key(modeController, actionKey));
        if (oldAccelerator != null && (oldAction = this.accelerators.remove(this.key(modeController, oldAccelerator))) != null && !action.getKey().equals(oldAction.getKey())) {
            throw new AssertionError((Object)("unexpected action " + ActionUtils.getActionTitle(action) + " for accelerator " + oldAccelerator + "(" + ActionUtils.getActionTitle(oldAction) + ")"));
        }
        return oldAccelerator;
    }

    public String getPropertyKey(String key) {
        return this.getPropertyKey(Controller.getCurrentModeController(), key);
    }

    String getPropertyKey(ModeController modeController, String key) {
        return SHORTCUT_PROPERTY_PREFIX + modeController.getModeName() + "/" + key;
    }

    @Override
    public KeyStroke getAccelerator(AFreeplaneAction action) {
        String actionKey = action.getKey();
        return this.getAccelerator(actionKey);
    }

    public KeyStroke getAccelerator(String actionKey) {
        KeyStroke ks = this.actionMap.get(this.key(actionKey));
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcceleratorChangeListener(FreeplaneActions freeplaneActions, IAcceleratorChangeListener changeListener) {
        Map<FreeplaneActions, Collection<IAcceleratorChangeListener>> map = this.changeListenersForActionCollection;
        synchronized (map) {
            Collection<IAcceleratorChangeListener> changeListeners = this.changeListenersForActionCollection.get(freeplaneActions);
            if (changeListeners == null) {
                changeListeners = new ArrayList<IAcceleratorChangeListener>();
                this.changeListenersForActionCollection.put(freeplaneActions, changeListeners);
            }
            if (!changeListeners.contains(changeListener)) {
                changeListeners.add(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAcceleratorChanged(FreeplaneActions freeplaneActions, AFreeplaneAction action, KeyStroke oldStroke, KeyStroke newStroke) {
        Map<FreeplaneActions, Collection<IAcceleratorChangeListener>> map = this.changeListenersForActionCollection;
        synchronized (map) {
            Collection<IAcceleratorChangeListener> listeners = this.changeListenersForActionCollection.get(freeplaneActions);
            if (listeners != null) {
                for (IAcceleratorChangeListener listener : listeners) {
                    listener.acceleratorChanged(action, oldStroke, newStroke);
                }
            }
        }
    }

    private String getShortcut(String key) {
        return this.keysetProps.getProperty(key, null);
    }

    public void newAccelerator(AFreeplaneAction action, KeyStroke newAccelerator) {
        String shortcutKey = this.getPropertyKey(action.getKey());
        String oldShortcut = this.getAccelerator(action) != null ? this.getShortcut(shortcutKey) : null;
        if (newAccelerator == null || !new KeystrokeValidator(action).isValid(newAccelerator, Character.valueOf(newAccelerator.getKeyChar()))) {
            GrabKeyDialog grabKeyDialog = new GrabKeyDialog(oldShortcut);
            KeystrokeValidator validator = new KeystrokeValidator(action);
            grabKeyDialog.setValidator(validator);
            grabKeyDialog.setVisible(true);
            if (grabKeyDialog.isOK()) {
                String shortcut = grabKeyDialog.getShortcut();
                KeyStroke accelerator = UITools.getKeyStroke(shortcut);
                this.setAccelerator(action, accelerator);
                this.setKeysetProperty(shortcutKey, shortcut);
                LogUtils.info("created shortcut '" + shortcut + "' for action '" + action.getKey() + "', shortcutKey '" + shortcutKey + "' (" + ActionUtils.getActionTitle(action) + ")");
            }
        } else {
            int replace;
            if (oldShortcut != null && (replace = JOptionPane.showConfirmDialog(UITools.getCurrentRootComponent(), oldShortcut, TextUtils.removeTranslateComment(TextUtils.getText("remove_shortcut_question")), 0)) != 0) {
                return;
            }
            this.setAccelerator(action, newAccelerator);
            this.setKeysetProperty(shortcutKey, ActionAcceleratorManager.toString(newAccelerator));
            LogUtils.info("created shortcut '" + ActionAcceleratorManager.toString(newAccelerator) + "' for action '" + action + "', shortcutKey '" + shortcutKey + "' (" + ActionUtils.getActionTitle(action) + ")");
        }
        this.saveAcceleratorPresets();
    }

    public void saveAcceleratorPresets() {
        try (FileOutputStream output = new FileOutputStream(this.getPresetsFile());){
            this.storeAcceleratorPreset(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getPresetsFile() {
        File userDirectory = new File(ResourceController.getResourceController().getFreeplaneUserDirectory());
        if (!userDirectory.exists()) {
            userDirectory.mkdirs();
        }
        return new File(userDirectory, "accelerator.properties");
    }

    public void loadAcceleratorPresets(InputStream in) {
        Properties prop = new Properties();
        try {
            prop.load(in);
            for (Map.Entry<Object, Object> property : new ArrayList<Map.Entry<Object, Object>>(prop.entrySet())) {
                String shortcutKey = (String)property.getKey();
                String keystrokeString = (String)property.getValue();
                String updatedShortcutKey = this.updateShortcutKey(shortcutKey);
                if (!updatedShortcutKey.equals(shortcutKey)) {
                    prop.remove(shortcutKey);
                    if (prop.get(updatedShortcutKey) != null) continue;
                    prop.setProperty(updatedShortcutKey, keystrokeString);
                }
                this.loadAcceleratorPreset(updatedShortcutKey, keystrokeString, prop);
            }
        }
        catch (IOException e) {
            LogUtils.warn("shortcut presets not stored: " + e.getMessage());
        }
    }

    String updateShortcutKey(String shortcutKey) {
        String updatedShortcutKey = shortcutKey;
        int dotPosition = "acceleratorFor".length();
        if (shortcutKey.length() > dotPosition && shortcutKey.charAt(dotPosition) != '.') {
            updatedShortcutKey = SHORTCUT_PROPERTY_PREFIX + shortcutKey.substring(dotPosition);
        }
        if (updatedShortcutKey.endsWith("$0")) {
            updatedShortcutKey = oldKeyFormatPattern.matcher(updatedShortcutKey).replaceFirst("$1");
        }
        return updatedShortcutKey;
    }

    private void loadAcceleratorPreset(String shortcutKey, String keystrokeString, Properties allPresets) {
        if (!shortcutKey.startsWith(SHORTCUT_PROPERTY_PREFIX)) {
            LogUtils.warn("wrong property key " + shortcutKey);
            return;
        }
        int pos = shortcutKey.indexOf("/", SHORTCUT_PROPERTY_PREFIX.length());
        if (pos <= 0) {
            LogUtils.warn("wrong property key " + shortcutKey);
            return;
        }
        String modeName = shortcutKey.substring(SHORTCUT_PROPERTY_PREFIX.length(), pos);
        String itemKey = shortcutKey.substring(pos + 1);
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController(modeName);
        if (modeController != null) {
            KeyStroke keyStroke;
            if (!keystrokeString.equals("")) {
                keyStroke = UITools.getKeyStroke(keystrokeString);
                AFreeplaneAction oldAction = this.accelerators.get(this.key(modeController, keyStroke));
                if (!this.acceleratorIsDefinedByUserProperties(oldAction, modeController, allPresets)) {
                    this.setAccelerator(modeController, oldAction, null);
                }
            } else {
                keyStroke = null;
            }
            AFreeplaneAction action = modeController.getAction(itemKey);
            if (action != null) {
                this.setAccelerator(modeController, action, keyStroke);
            }
        }
        this.setKeysetProperty(shortcutKey, keystrokeString);
    }

    private boolean acceleratorIsDefinedByUserProperties(AFreeplaneAction oldAction, ModeController modeController, Hashtable<?, ?> userProperties) {
        if (oldAction != null) {
            String key = oldAction.getKey();
            String oldShortcutKey = this.getPropertyKey(modeController, key.toString());
            boolean acceleratorWasNotLoadedYet = userProperties.containsKey(oldShortcutKey) && !"".equals(userProperties.get(oldShortcutKey));
            return acceleratorWasNotLoadedYet;
        }
        return false;
    }

    public void storeAcceleratorPreset(OutputStream out) {
        try {
            BufferedOutputStream output = new BufferedOutputStream(out);
            this.keysetProps.store(output, "");
        }
        catch (IOException e1) {
            UITools.errorMessage(TextUtils.removeTranslateComment(TextUtils.getText("can_not_save_key_set")));
        }
    }

    private static String toString(KeyStroke newAccelerator) {
        return newAccelerator.toString().replaceFirst("pressed ", "");
    }

    private static boolean askForReplaceShortcutViaDialog(String oldMenuItemTitle) {
        int replace = JOptionPane.showConfirmDialog(UITools.getCurrentRootComponent(), TextUtils.removeTranslateComment(TextUtils.format("replace_shortcut_question", oldMenuItemTitle)), TextUtils.removeTranslateComment(TextUtils.format("replace_shortcut_title", new Object[0])), 0);
        return replace == 0;
    }

    public boolean canProcessKeyEvent(KeyEvent e) {
        KeyStroke ks;
        boolean pressed;
        KeyStroke ksE = null;
        boolean bl = pressed = e.getID() == 401;
        if (e.getID() == 400) {
            ks = KeyStroke.getKeyStroke(e.getKeyChar());
        } else {
            if (e.getKeyCode() != e.getExtendedKeyCode()) {
                ksE = KeyStroke.getKeyStroke(e.getExtendedKeyCode(), e.getModifiers(), !pressed);
            }
            ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), !pressed);
        }
        return ksE != null && this.actionForAccelerator(ksE) != null || this.actionForAccelerator(ks) != null;
    }

    private AFreeplaneAction actionForAccelerator(KeyStroke ks) {
        int updatedModifiers;
        int modifiers = ks.getModifiers();
        if (modifiers != (updatedModifiers = KeyEventTranslator.getCompatibleModifiers(modifiers))) {
            KeyStroke updatedKs = ks.getKeyEventType() == 400 ? KeyStroke.getKeyStroke((int)ks.getKeyChar(), updatedModifiers) : KeyStroke.getKeyStroke(ks.getKeyCode(), updatedModifiers, ks.isOnKeyRelease());
            return this.accelerators.get(this.key(updatedKs));
        }
        return this.accelerators.get(this.key(ks));
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent event) {
        AFreeplaneAction action = this.actionForAccelerator(ks);
        if (action == null) {
            KeyStroke derivedKeyStroke = FreeplaneMenuBar.derive(ks, Character.valueOf(event.getKeyChar()));
            action = this.actionForAccelerator(derivedKeyStroke);
        }
        return action != null && action.isEnabled() && action != null && SwingUtilities.notifyAction(action, ks, event, event.getComponent(), event.getModifiers());
    }

    private static String replaceModifiersForMac(String accelerator) {
        if (Compat.isMacOsX()) {
            if (accelerator.endsWith("TAB") || accelerator.endsWith("ESCAPE")) {
                return accelerator;
            }
            accelerator = accelerator.startsWith("alt ") && accelerator.charAt(accelerator.length() - 2) == ' ' ? "control " + accelerator : accelerator.replaceFirst("control", "meta");
        }
        return accelerator;
    }

    private void setKeysetProperty(String key, String value) {
        this.keysetProps.setProperty(key, value);
    }

    private class KeystrokeValidator
    implements IKeystrokeValidator {
        private final AFreeplaneAction action;

        private KeystrokeValidator(AFreeplaneAction action) {
            this.action = action;
        }

        private boolean checkForOverwriteShortcut(KeyStroke keystroke) {
            AFreeplaneAction priorAssigned = (AFreeplaneAction)ActionAcceleratorManager.this.accelerators.get(ActionAcceleratorManager.this.key(keystroke));
            if (priorAssigned == null || this.action.getKey().equals(priorAssigned.getKey())) {
                return true;
            }
            return this.replaceOrCancel(priorAssigned, ActionUtils.getActionTitle(priorAssigned));
        }

        private boolean replaceOrCancel(AFreeplaneAction action, String oldMenuItemTitle) {
            if (ActionAcceleratorManager.askForReplaceShortcutViaDialog(oldMenuItemTitle)) {
                ActionAcceleratorManager.this.setAccelerator(action, null);
                String shortcutKey = ActionAcceleratorManager.this.getPropertyKey(action.getKey());
                ActionAcceleratorManager.this.keysetProps.remove(shortcutKey);
                return true;
            }
            return false;
        }

        @Override
        public boolean isValid(KeyStroke keystroke, Character keyChar) {
            String keyTypeActionString;
            IEditHandler.FirstAction keyTypeAction;
            if (keystroke == null) {
                return true;
            }
            if (keyChar.charValue() != '\uffff' && (keystroke.getModifiers() & 0xE) == 0 && !IEditHandler.FirstAction.IGNORE.equals((Object)(keyTypeAction = IEditHandler.FirstAction.valueOf(keyTypeActionString = ResourceController.getResourceController().getProperty("key_type_action", IEditHandler.FirstAction.EDIT_CURRENT.toString()))))) {
                return false;
            }
            if (!this.checkForOverwriteShortcut(keystroke)) {
                return false;
            }
            KeyStroke derivedKS = FreeplaneMenuBar.derive(keystroke, keyChar);
            if (derivedKS == keystroke) {
                return true;
            }
            return this.checkForOverwriteShortcut(derivedKS);
        }
    }
}

