"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandRunner = void 0;
const vscode_uri_1 = require("vscode-uri");
const misc_1 = require("./misc");
const execPath_1 = require("./execPath");
class CommandRunner {
    constructor(connection, context, settings) {
        this.connection = connection;
        this.context = context;
        this.settings = settings;
    }
    runCommand(executable, args, workingDirectory, mountPaths) {
        return __awaiter(this, void 0, void 0, function* () {
            let executablePath;
            let command;
            let runEnv;
            const isEEEnabled = this.settings.executionEnvironment.enabled;
            const interpreterPath = isEEEnabled
                ? "python3"
                : this.settings.python.interpreterPath;
            if (executable.startsWith("ansible")) {
                executablePath = isEEEnabled
                    ? executable
                    : (0, execPath_1.getAnsibleCommandExecPath)(executable, this.settings);
            }
            else {
                executablePath = executable;
            }
            // prepare command and env for local run
            if (!isEEEnabled) {
                [command, runEnv] = (0, misc_1.withInterpreter)(executablePath, args, interpreterPath, this.settings.python.activationScript);
            }
            else {
                // prepare command and env for execution environment run
                const executionEnvironment = yield this.context.executionEnvironment;
                command = executionEnvironment.wrapContainerArgs(`${executable} ${args}`, mountPaths);
                runEnv = undefined;
            }
            const currentWorkingDirectory = workingDirectory
                ? workingDirectory
                : vscode_uri_1.URI.parse(this.context.workspaceFolder.uri).path;
            const result = yield (0, misc_1.asyncExec)(command, {
                encoding: "utf-8",
                cwd: currentWorkingDirectory,
                env: runEnv,
            });
            return result;
        });
    }
    /**
     * A method to return the path to the provided executable
     * @param executable String representing the name of the executable
     * @returns Complete path of the executable (string) or undefined depending upon the presence of the executable
     */
    getExecutablePath(executable) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const executablePath = yield this.runCommand("command", `-v ${executable}`);
                return executablePath.stdout.trim();
            }
            catch (error) {
                console.log(error);
            }
            try {
                const executablePath = yield this.runCommand("whereis", executable);
                const outParts = executablePath.stdout.split(":");
                return outParts.length >= 2 ? outParts[1].trim() : undefined;
            }
            catch (error) {
                console.log(error);
            }
        });
    }
}
exports.CommandRunner = CommandRunner;
//# sourceMappingURL=commandRunner.js.map