/*
 * generated by Xtext 2.20.0
 */
package org.neu.acl2.handproof.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

//import org.json.JSONObject;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.neu.acl2.handproof.handProof.Context;
import org.neu.acl2.handproof.handProof.ContextHint;
import org.neu.acl2.handproof.handProof.DerivedContext;
import org.neu.acl2.handproof.handProof.HandProofPackage;
import org.neu.acl2.handproof.handProof.Proof;
import org.neu.acl2.handproof.handProof.ProofBody;
import org.neu.acl2.handproof.handProof.ProofDocument;
import org.neu.acl2.handproof.handProof.SExpList;
import org.neu.acl2.handproof.handProof.Symbol;
import org.neu.acl2.handproof.handProof.TerminationProof;
import org.neu.acl2.handproof.handProof.contextItem;
import org.neu.acl2.handproof.handProof.dcontextItem;
import org.neu.acl2.handproof.util.CheckerValueConverter;
import org.neu.acl2.handproof.validation.ProofCheckerErrorMessage.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.log4j.Logger;

import com.google.inject.Inject;

// https://www.javaworld.com/article/2071275/when-runtime-exec---won-t.html?page=2
class StreamGobbler extends Thread {
	InputStream is;
	String type;

	StreamGobbler(InputStream is, String type) {
		this.is = is;
		this.type = type;
	}

	public void run() {
		try {
			InputStreamReader isr = new InputStreamReader(is);
			BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null)
				System.out.println(type + ">" + line);
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}

class AsyncStreamReader extends Thread {
	InputStream is;
	LinkedList<String> lines;

	AsyncStreamReader(InputStream is) {
		this.is = is;
		this.lines = new LinkedList<String>();
	}

	public synchronized List<String> getLines() {
		return (List<String>) this.lines.clone();
	}
	
	public synchronized String getString() {
		StringBuilder sb = new StringBuilder();
		for (String s : this.lines) {
			sb.append(s);
			sb.append("\n");
		}
		return sb.toString();
	}

	public void run() {
		try {
			InputStreamReader isr = new InputStreamReader(is);
			BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null)
				this.lines.add(line);
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}

class ProofCheckerErrorMessage {
	enum Severity {
		ERROR, WARN, INFO
	}

	List<Integer> ids;
	Severity severity;
	String message;
	String kind;

	public ProofCheckerErrorMessage(String message, Severity severity, List<Integer> ids, String kind) {
		this.ids = ids;
		this.severity = severity;
		this.message = message;
		this.kind = kind;
	}

	@Override
	public String toString() {
		return this.severity + ": " + this.ids.stream().map(i -> i.toString()).collect(Collectors.joining(",")) + " - " + this.message;
	}

	private static List<Integer> parseIds(String idsValue) {
		if(idsValue == null || idsValue.equals("NIL")) {
			return new ArrayList<Integer>(0);
		}
		List<Integer> ret = new ArrayList<Integer>();
		int idx = 0;
		while((idx = idsValue.indexOf(",")) != -1) {
			String firstnum = idsValue.substring(0,idx);
			try {
				ret.add(Integer.parseInt(firstnum));
			} catch (NumberFormatException e) {
				continue;
			}
			idsValue = idsValue.substring(idx+1);
		}
		try {
			ret.add(Integer.parseInt(idsValue));
		} catch (NumberFormatException e) {}
		// TODO: we currently ignore NumberFormatExceptions here.
		// Is this appropriate?

		return ret;
	}

	public static List<ProofCheckerErrorMessage> fromXML(InputSource source) throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		Document doc = dBuilder.parse(source);
		NodeList messages = doc.getElementsByTagName("message");
		List<ProofCheckerErrorMessage> msgs = new ArrayList<>(messages.getLength());
		for (int i = 0; i < messages.getLength(); i++) {
			Node node = messages.item(i);
			String message = node.getTextContent();
			List<Integer> ids = parseIds(node.getAttributes().getNamedItem("id").getNodeValue());
			Severity severity = Severity
					.valueOf(node.getAttributes().getNamedItem("severity").getNodeValue().toUpperCase());
			String kind = node.getAttributes().getNamedItem("kind").getNodeValue();
			msgs.add(new ProofCheckerErrorMessage(message, severity, ids, kind));
		}
		return msgs;
	}
}

/**
 * This class contains custom validation rules.
 *
 * See
 * https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
public class HandProofValidator extends AbstractHandProofValidator {
	
	// TODO: this is suuuuper hacky.
	// The hover provider needs to know not to access the document when the
	// validator is running, as this will result in a UI hang (since access
	// to the document is protected with a lock).
	// See https://github.com/eclipse/xtext/issues/2817
	private final Object runningLock = new Object();
	private boolean isRunning = false;

	public static final String INVALID_CONTEXT_HINT = "invalidContextHint";
	public static final String INVALID_CONTEXT = "invalidContext";
	public static final String INVALID_DERIVED_CONTEXT = "invalidDerivedContext";
	public static final String UNKNOWN_RELATION = "unknownRelation";
	public static final String VALIDATION_OUTPUT = "validationOutput";
	public static final String VALIDATION_TIMING = "timing";
	
	@Inject
	IValidationPreferencesProvider prefsProvider;
	
	@Inject
	IValidationMessageHandler msgHandler;
	
	@Inject
	private IValidationFilePathProvider validationFilePathProvider;
	
	private Logger getLogger() {
		return Logger.getLogger(this.getClass());
	}
	
	public boolean isRunning() {
		synchronized(runningLock) {
			return isRunning;
		}
	}
	
	/**
	 * Get the proof or proof case that contains the given EObject, or null if none
	 * exists. If multiple proofs or proof cases contain the child, the one which is
	 * closest to the child is returned.
	 * 
	 * @param child The child to get the parent proof or proof case of
	 * @return The proof or proof case that contains the given EObject, or null if
	 *         none exists.
	 */
	private static EObject getContainingProofOrCase(EObject child) {
		if (child == null) {
			return null;
		}
		if (child instanceof Proof) {
			return child;
		}
		return getContainingProofOrCase(child.eContainer());
	}
	
	private static List<EObject> getContainingProofsOrCases(EObject child) {
		List<EObject> parents = new ArrayList<>();
		child = child.eContainer();
		while(child != null) {
			if (child instanceof Proof) {
				parents.add(child);
			}
			child = child.eContainer();
		}
		
		// We reverse the order here so that the parents are in order of appearance
		// i.e. the outermost parent is first
		Collections.reverse(parents);
		return parents;
	}
		
//	private static Context getProofContext(Proof proof) {
//		if(proof.getBody() instanceof NormalProofBody) {
//			return ((NormalProofBody)proof.getBody()).getContext();
//		}
//		if(proof.getBody() instanceof InductionProofBody) {
//			return ((InductionProofBody)proof.getBody());
//		}
//		return null;
//	}
	
	private static Context getContextOfContainingProof(EObject child) {
		EObject proofOrCase = getContainingProofOrCase(child);
		if(proofOrCase == null) {
			return null;
		}
		//if(proofOrCase instanceof InductionProofCase) {
		//	return ((InductionProofCase)proofOrCase).getContext();
		//}
		Proof proof = (Proof)proofOrCase;
		if(proof instanceof Proof) {
			return (proof.getContext());
		}
		return null;
	}
	
	private static Stream<contextItem> getContextOrEmptyStream(Proof proof) {
		if(proof.getContext() != null && proof.getContext().getContext() != null) {
			return proof.getContext().getContext().stream();
		} else {
			return Stream.empty();
		}
	}
	
	private static Stream<dcontextItem> getDerivedContextOrEmptyStream(Proof proof) {
		if(proof.getDerivedContext() != null && proof.getDerivedContext().getDerivedContext() != null) {
			return proof.getDerivedContext().getDerivedContext().stream();
		} else {
			return Stream.empty();
		}
	}
	
	private static Stream<String> allContextNamesOfContainingProofs(EObject child) {
		List<EObject> proofsOrCases = getContainingProofsOrCases(child);
		if(proofsOrCases == null) {
			return null;
		}
		//if(proofOrCase instanceof InductionProofCase) {
			//InductionProofCase proofCase = (InductionProofCase)proofOrCase;
		//	return Stream.concat(
		//			proofCase.getContext().getContext().stream().map(item -> (String)item.getName()),
		//			proofCase.getDerivedContext().getDerivedContext().stream().map(item -> (String)item.getName()));
		//}
		
		List<String> contextNames = new ArrayList<>();
		for(EObject proofOrCase : proofsOrCases) {
			if(proofOrCase instanceof Proof) {
				Proof proof = (Proof)proofOrCase;
				
				contextNames.addAll(getContextOrEmptyStream(proof).map(item -> (String)item.getName()).collect(Collectors.toList()));
				contextNames.addAll(getDerivedContextOrEmptyStream(proof).map(item -> (String)item.getName()).collect(Collectors.toList()));
			}
		}
		return contextNames.stream();
	}
	
	private static Stream<String> contextNamesOfContainingProofs(EObject child) {
		// TODO: we are assuming here that the proofsOrCases here are in order from outermost to innermost.
		// should confirm that this is the case.
		List<EObject> proofsOrCases = getContainingProofsOrCases(child);
		if(proofsOrCases == null) {
			return null;
		}
		
		List<String> contextNames = new ArrayList<>();
		for(EObject proofOrCase : proofsOrCases) {
			if(proofOrCase instanceof Proof) {
				Proof proof = (Proof)proofOrCase;
				
				contextNames.addAll(getContextOrEmptyStream(proof).map(item -> (String)item.getName()).collect(Collectors.toList()));
			}
		}
		return contextNames.stream();
	}
	
	private static Stream<String> derivedContextNamesOfContainingProofs(EObject child) {
		// TODO: we are assuming here that the proofsOrCases here are in order from outermost to innermost.
		// should confirm that this is the case.
		List<EObject> proofsOrCases = getContainingProofsOrCases(child);
		if(proofsOrCases == null) {
			return null;
		}
		
		List<String> contextNames = new ArrayList<>();
		for(EObject proofOrCase : proofsOrCases) {
			if(proofOrCase instanceof Proof) {
				Proof proof = (Proof)proofOrCase;
				
				contextNames.addAll(getDerivedContextOrEmptyStream(proof).map(item -> (String)item.getName()).collect(Collectors.toList()));
			}
		}
		return contextNames.stream();
	}

	/**
	 * A validator which checks that every context hint has a name that matches a
	 * context item in the containing proof
	 * 
	 * @param hint The context hint to check
	 */
	@Check
	public void checkContractHintIsValid(ContextHint hint) {
		Stream<String> contextNames = allContextNamesOfContainingProofs(hint);
		if(contextNames == null) { 
			throw new RuntimeException("Couldn't find containing context for hint: " + hint.toString());
		}
		if(!contextNames.anyMatch(name -> name.equalsIgnoreCase(hint.getName()))) {
			error("Context hint references a nonexistant context item!",
					hint,
					HandProofPackage.Literals.CONTEXT_HINT__NAME,
					INVALID_CONTEXT_HINT);
		}
	}
	
//	@Check
//	public void checkDefineCTypes(DefineC defc) {
//		if(!defc.getReturnType().startsWith(":")) {
//			// error out
//		}
//		defc.getParameters().getParams().forEach(item -> {
//			if(!item.getType().startsWith(":")) {
//				// error out
//			}
//		});
//	}
	
	@Check
	public void checkContextNames(Context ctx) {
		EObject proof = getContainingProofOrCase(ctx);
		if(!proof.eResource().getErrors().isEmpty()) {
			return;
		}
		int i = contextNamesOfContainingProofs(proof)
				.map(name -> Integer.parseInt(name.substring(1)))
				.max(Integer::compare).orElse(0) + 1;
		
		for(contextItem ctxItem : ctx.getContext()) {
			if(Integer.parseInt(ctxItem.getName().substring(1)) != i) {
				error("Context items not given in ascending order from 0!",
						ctxItem,
						HandProofPackage.Literals.CONTEXT_ITEM__NAME,
						INVALID_CONTEXT);
			}
			i++;
		}
	}
	
	@Check
	public void checkDContextNames(DerivedContext dctx) {
		EObject proof = getContainingProofOrCase(dctx);
		if(!proof.eResource().getErrors().isEmpty()) {
			return;
		}
		int i = derivedContextNamesOfContainingProofs(proof)
				.map(name -> Integer.parseInt(name.substring(1)))
				.max(Integer::compare).orElse(0) + 1;
		
		for(dcontextItem dctxItem : dctx.getDerivedContext()) {
			if(Integer.parseInt(dctxItem.getName().substring(1)) != i) {
				error("Derived Context items not given in ascending order from 0!",
						dctxItem,
						HandProofPackage.Literals.DCONTEXT_ITEM__NAME,
						INVALID_DERIVED_CONTEXT);
			}
			i++;
		}
	}
	
	@Check
	public void checkProofBodyRels(ProofBody body) {
		if(!body.eResource().getErrors().isEmpty()) {
			return;
		}
		List<String> validRels = Arrays.asList("=", "==", ">", ">=", "<", "<=", "->", "=>", "<-", "iff");
		if (!body.getRels().stream().allMatch(rel -> validRels.contains(rel))) {
			List<INode> relNodes = NodeModelUtils.findNodesForFeature(body, HandProofPackage.Literals.PROOF_BODY__RELS);
			relNodes.stream().filter(item -> !validRels.contains(item.getText()))
					.forEach(offendingNode -> getMessageAcceptor().acceptWarning(
							"Unknown relation used: " + offendingNode.getText(), body, offendingNode.getOffset(),
							offendingNode.getLength(), UNKNOWN_RELATION));

		}
	}

	@Check
	public void checkTermProofDefinitions(TerminationProof tproof) {
		String measureName = tproof.getHead().getMeasure().get(0);
		String targetName = tproof.getHead().getTarget().get(0);
		
		//Currently I assume that any definition is at the top level
		List<String> definedFuncs = new LinkedList<String>();
		for(EObject def : tproof.getDefinitions()) {
			if(def instanceof SExpList
					&& ((SExpList) def).getBody().get(0) instanceof Symbol
					&& ((Symbol) ((SExpList) def).getBody().get(0)).getValue().equalsIgnoreCase("definec")) {
				System.out.println("Symbol: " + ((Symbol) ((SExpList) def).getBody().get(0)).getValue());
				definedFuncs.add(((Symbol)((SExpList)def).getBody().get(1)).getValue());
			}
		}
	}

	/**
	 * Run the ACL2s proof checker code on the entire proof document
	 * 
	 * @param doc
	 */
	@Check(CheckType.EXPENSIVE)
	public void checkWithACL2(ProofDocument doc) {
		if(!doc.eResource().getErrors().isEmpty()) {
			getLogger().warn("Proof document already has errors, so we won't run the ACL2 checker code.");
			msgHandler.handleError("Proof document is not well-formed", "Proof document already has errors, so we won't perform additional validation. Please fix the syntax error(s) first..");
			return;
		}
		// TODO: catch all errors that could be thrown inside here and return a useful error message if one occurs
		List<EObject> allNodes = new ArrayList<>();
		doc.eAllContents().forEachRemaining(allNodes::add);

		CheckerValueConverter cv = new CheckerValueConverter(allNodes);
		String docLisp;
		try { docLisp = cv.toLisp(doc); }
		catch (Exception e) {
			Logger.getLogger(this.getClass()).error(e.toString());
			msgHandler.handleError("Couldn't translate proof document for the validator", e.toString());
			System.err.println(e);
			throw e;
		}
		synchronized(runningLock) {
			isRunning = true;
		}
		// TODO: improve this later
		String prove_file_sh_path = this.prefsProvider.getProveFileSH();
		System.out.println("Path: " + prove_file_sh_path);
		if(!Files.exists(Path.of(prove_file_sh_path))) {
			msgHandler.handleError("Validation Error", "The provided path to the prove-file SH script is not valid!\n" + prove_file_sh_path);
			throw new RuntimeException("Can't get a path to the prove-file SH script!");
		}
		if(!Files.isExecutable(Path.of(prove_file_sh_path))) {
			msgHandler.handleError("Validation Error", "The provided prove-file SH script is not an executable file!\n" + prove_file_sh_path);
			throw new RuntimeException("The prove-file SH script is not an executable file!");
		}
		ProcessBuilder pb;
		if(this.validationFilePathProvider.getPath() != null) {
			System.out.println(this.validationFilePathProvider.getPath());
			pb = new ProcessBuilder(prove_file_sh_path, this.validationFilePathProvider.getPath());
		} else {
			pb = new ProcessBuilder(prove_file_sh_path);
		}
		try {
			Process p = pb.start();

			// Send query to ACL2s
			String queryString = "(prover::check-proof-document '" + docLisp + ")\n(sb-ext::exit)\n";
			p.getOutputStream().write(queryString.getBytes());
			p.getOutputStream().flush();
//			System.out.println(queryString);

			// This will consume contents of output stream
			// Needed because if the output stream's buffer fills up, it blocks output on
			// stderr as well
			AsyncStreamReader outputReader = new AsyncStreamReader(p.getInputStream());
			outputReader.start();
			
			// This will save contents of output stream to a StringBuilder
			// 1 million characters is arbitrarily chosen - if it is exceeded, the UI may freeze up temporarily
			// as the builder allocates more memory.
			StringBuilder sb = new StringBuilder(1000000);
			String s;
			BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getErrorStream()));
			while ((s = stdout.readLine()) != null) {
				sb.append(s);
				sb.append("\n");
			}
			
			try {
				p.waitFor(1, TimeUnit.SECONDS);
			} catch (InterruptedException e) {
				getLogger().error(e.toString(), e);
			}
			
			if(p.isAlive()) {
				p.destroyForcibly();
				getLogger().warn("Had to forcibly terminate the checker process");
			}
			
			if(p.exitValue() != 0) {
				msgHandler.handleError("Validation Error", "Couldn't run the proof checker - logging some information to the error log that might be helpful.");
				getLogger().info("Couldn't run the proof checker - error code " + p.exitValue());
				getLogger().info(outputReader.getString());
				return;
			}
			
			String output = sb.toString();
			getLogger().debug(output);
//			System.out.println(output);
			List<ProofCheckerErrorMessage> messages = ProofCheckerErrorMessage
					.fromXML(new InputSource(new StringReader(output)));

			INode docNode = NodeModelUtils.getNode(doc);
			// TODO: get rid of this message and just communicate output through msgHandler
			getMessageAcceptor().acceptInfo("DATA",
					doc,
					docNode.getOffset(),
					//docNode.getLength(),
					0,
					VALIDATION_OUTPUT,
					outputReader.getString(),
					queryString);
			msgHandler.handleOutput(outputReader.getString());
			for (ProofCheckerErrorMessage message : messages) {
				// TODO: what should we do if a message doesn't have an ID?
				int len = 0;
				int offset = 0;
				if (message.ids.size() > 0) {
					INode firstNode = message.ids.stream()
							.map(id -> NodeModelUtils.getNode(allNodes.get(id)))
							.collect(Collectors.minBy((n1, n2) -> Integer.compare(n1.getOffset(), n2.getOffset())))
							.get();
					INode lastNode = message.ids.stream()
							.map(id -> NodeModelUtils.getNode(allNodes.get(id)))
							.collect(Collectors.maxBy((n1, n2) -> Integer.compare(n1.getOffset(), n2.getOffset())))
							.get();
					offset = firstNode.getOffset();
					len = lastNode.getEndOffset() - firstNode.getOffset();
				}
				
				if (message.severity == Severity.ERROR) {
					getMessageAcceptor().acceptError(message.message, doc, offset, len, message.kind);
				} else if (message.severity == Severity.WARN) {
					getMessageAcceptor().acceptWarning(message.message, doc, offset, len, message.kind);
				} else if (message.severity == Severity.INFO) {
					getMessageAcceptor().acceptInfo(message.message, doc, offset, len, message.kind);
				} else {
					getLogger().warn("Message with unknown severity " + message.severity.toString() + " reported!");
				}
			}
		} catch (IOException e) {
			msgHandler.handleError("Validation Error", e.toString());
			getLogger().error(e.toString(), e);
		} catch (ParserConfigurationException | SAXException e) {
			msgHandler.handleError("Validation Error", "It looks like the ACL2 checker failed to run - confirm that the prove-file SH script location is correct!\n" + e.toString());
			getLogger().error(e.toString(), e);
		} finally {
			synchronized(runningLock) {
				isRunning = false;
			}
		}
	}
}

