      SUBROUTINE T1STAT(T1OLD,T1NEW,SYVEC,NSIZET,NSMSZ,
     &                  ISPIN,ICONVG,TOL,NLIST,TYPE)
C
C THIS ROUTINE ACCEPTS TWO T1 VECTORS AND FINDS THE LARGEST
C  AND RMS DIFFERENCE BETWEEN THEIR ELEMENTS AND DETERMINES
C  IF THEY ARE IDENTICAL TO WITHIN A SET TOLERANCE.
C
C INPUT:  
C       T1OLD - ONE OF THE TWO T1 VECTORS.
C       T1NEW - THE OTHER T1 VECTOR.
C       SYVEC - THE AI SYMMETRY VECTOR FOR THIS SPIN CASE
C       NSIZET- LENGTH OF THE SYMMETRY-PACKED T1 VECTOR.
C       NSMSZ - LENGTH OF THE AI SYMMETRY VECTOR (Na*na OR Nb*nb)
C       ISPIN - THE SPIN CASE
C       TOL   - THE CONVERGENCE CRITERION
C       NLIST - THE LIST NUMBER ON WHICH THE VALUES RESIDE
C       TYPE  - ???????
C
C OUTPUT:
C       ICONVG- RETURNED AS "0" IF VALUES ARE CONVERGED, "1"
C               OTHERWISE.
C
CEND
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER A,SYVEC(NSMSZ)
      CHARACTER*2 SPCASE(3) 
      CHARACTER*1 TYPE
      DIMENSION T1OLD(NSIZET),T1NEW(NSIZET)
      COMMON /INFO/ NOCCO(2),NVRTO(2)
      COMMON /FLAGS/ IFLAGS(100)
      DATA SPCASE /'AA','BB','AB'/
      DATA ONEM /-1.0/
      IGETI(IX,N)=1+(IX-1)/N
      IGETA(IX,N)=IX-(IGETI(IX,N)-1)*N 
C
      IF(NSIZET.EQ.0)RETURN
C
C FORM T2DIFF = T2NEW - T2OLD
C
      CALL GETLST(T1OLD,1,1,1,ISPIN,90+NLIST)
      CALL GETLST(T1NEW,1,1,1,ISPIN+2,90)
      CALL VADD(T1OLD,T1NEW,T1OLD,NSIZET,ONEM)
      RMSDIF=SNRM2(NSIZET,T1OLD,1)
      RMSDIF=RMSDIF/FLOAT(NSIZET)
      MAXDIF=ISAMAX(NSIZET,T1OLD,1)
      DIFMAX=T1OLD(MAXDIF)
      IF(DABS(DIFMAX).GT.TOL)ICONVG=1
C
C MAXDIF IS THE OFFSET OF THE INDICES IN THE PACKED LIST.  WE NEED TO
C  GET THE OFFSET IN THE UNPACKED LIST.
C
      IOFFUNP=SYVEC(MAXDIF)
      I=IGETI(IOFFUNP,NVRTO(ISPIN))
      A=IGETA(IOFFUNP,NVRTO(ISPIN))+NOCCO(ISPIN)
      IF(IFLAGS(1).GE.10)THEN
       WRITE(*,100)TYPE,'1',SPCASE(ISPIN),RMSDIF,DIFMAX,I,A
  100  FORMAT(T9,A1,A1,T19,A2,T24,F13.10,T37,F13.10,T52,I3,T62,I3)
      ENDIF
      RETURN
      END
