/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeGraph;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.AnalysisReport;
import com.intellij.diagnostic.hprof.util.ListProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/performancePlugin/commands/DetectProjectLeaksCommand;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "analyzeSnapshot", "openProjectsNames", "", "Companion", "AnalyzeProjectGraph", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDetectProjectLeaksCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetectProjectLeaksCommand.kt\ncom/jetbrains/performancePlugin/commands/DetectProjectLeaksCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n11561#2:81\n11896#2,3:82\n13#3:85\n*S KotlinDebug\n*F\n+ 1 DetectProjectLeaksCommand.kt\ncom/jetbrains/performancePlugin/commands/DetectProjectLeaksCommand\n*L\n33#1:81\n33#1:82,3\n29#1:85\n*E\n"})
public final class DetectProjectLeaksCommand
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%detectProjectLeaks";
    @NotNull
    private static final Logger LOG;

    public DetectProjectLeaksCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$map$iv = projectArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Project project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List openProjectsNames = (List)destination$iv$iv;
        this.analyzeSnapshot(openProjectsNames);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void analyzeSnapshot(List<String> openProjectsNames) {
        String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String snapshotFileName = "close-project-" + snapshotDate + ".hprof";
        String snapshotPath = System.getProperty("memory.snapshots.path", SystemProperties.getUserHome()) + "/" + snapshotFileName;
        MemoryDumpHelper.captureMemoryDump((String)snapshotPath);
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(Paths.get(snapshotPath, new String[0]), object);
        Throwable throwable = null;
        try {
            String analysisResult;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)channel);
            HProfAnalysis analysis = new HProfAnalysis(channel, (HProfAnalysis.TempFilenameSupplier)new SystemTempFilenameSupplier(), (arg_0, arg_1, arg_2) -> DetectProjectLeaksCommand.analyzeSnapshot$lambda$0$0(openProjectsNames, arg_0, arg_1, arg_2));
            analysis.setOnlyStrongReferences(true);
            analysis.setIncludeClassesAsRoots(false);
            analysis.setIncludeMetaInfo(false);
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            if (((CharSequence)(analysisResult = analysis.analyze(progressIndicator))).length() > 0) {
                LOG.error("Snapshot analysis result: " + analysisResult);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private static final String analyzeSnapshot$lambda$0$0(List $openProjectsNames, AnalysisContext analysisContext, ListProvider listProvider, ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkNotNullParameter((Object)listProvider, (String)"listProvider");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        String string = new AnalyzeProjectGraph(analysisContext, listProvider, $openProjectsNames).analyze(progressIndicator).getMainReport().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DetectProjectLeaksCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/performancePlugin/commands/DetectProjectLeaksCommand$AnalyzeProjectGraph;", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph;", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "listProvider", "Lcom/intellij/diagnostic/hprof/util/ListProvider;", "openProjectsNames", "", "", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;Lcom/intellij/diagnostic/hprof/util/ListProvider;Ljava/util/List;)V", "getOpenProjectsNames", "()Ljava/util/List;", "analyze", "Lcom/intellij/diagnostic/hprof/util/AnalysisReport;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.performanceTesting"})
    private static final class AnalyzeProjectGraph
    extends AnalyzeGraph {
        @NotNull
        private final List<String> openProjectsNames;

        public AnalyzeProjectGraph(@NotNull AnalysisContext analysisContext, @NotNull ListProvider listProvider, @NotNull List<String> openProjectsNames) {
            Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
            Intrinsics.checkNotNullParameter((Object)listProvider, (String)"listProvider");
            Intrinsics.checkNotNullParameter(openProjectsNames, (String)"openProjectsNames");
            super(analysisContext, listProvider);
            this.openProjectsNames = openProjectsNames;
        }

        @NotNull
        public final List<String> getOpenProjectsNames() {
            return this.openProjectsNames;
        }

        @NotNull
        public AnalysisReport analyze(@NotNull ProgressIndicator progress) {
            AnalysisReport analysisReport;
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            AnalysisReport $this$analyze_u24lambda_u240 = analysisReport = new AnalysisReport(null, null, 3, null);
            boolean bl = false;
            this.traverseInstanceGraph(progress, $this$analyze_u24lambda_u240);
            ObjectNavigator navigator = this.getAnalysisContext().getNavigator();
            long l2 = 1L;
            long l3 = navigator.getInstanceCount();
            if (l2 <= l3) {
                while (true) {
                    ClassDefinition classDefinition;
                    if (Intrinsics.areEqual((Object)(classDefinition = navigator.getClassForObjectId(l2)).getName(), (Object)ProjectImpl.class.getName())) {
                        ObjectNavigator.goTo$default((ObjectNavigator)navigator, (long)l2, null, (int)2, null);
                        navigator.goToInstanceField(ProjectImpl.class.getName(), "cachedName");
                        String projectUnderAnalysis = navigator.getStringInstanceFieldValue();
                        if (!CollectionsKt.contains((Iterable)this.openProjectsNames, (Object)projectUnderAnalysis)) {
                            LOG.info("Analyzing GC Root for " + projectUnderAnalysis);
                            GCRootPathsTree gcRootPathsTree = new GCRootPathsTree(this.getAnalysisContext(), AnalysisConfig.TreeDisplayOptions.Companion.all$default((AnalysisConfig.TreeDisplayOptions.Companion)AnalysisConfig.TreeDisplayOptions.Companion, (boolean)false, (boolean)false, (int)1, null), null);
                            gcRootPathsTree.registerObject((int)l2);
                            $this$analyze_u24lambda_u240.getMainReport().append(gcRootPathsTree.printTree());
                        }
                    }
                    if (l2 == l3) break;
                    ++l2;
                }
            }
            return analysisReport;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/DetectProjectLeaksCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

