/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.chunking.Chunker;
import org.languagetool.language.English;
import org.languagetool.noop.NoopChunker;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.AmericanReplaceRule;
import org.languagetool.rules.en.BritishReplaceRule;
import org.languagetool.rules.en.NewZealandReplaceRule;

public class GenericEnglish
extends English {
    public String[] getCountries() {
        return new String[]{"US", "AU", "CA", "GB", "NZ"};
    }

    public String getName() {
        return "English (All variants)";
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        List rules = super.getRelevantRules(messages, userConfig, motherTongue, altLanguages);
        rules.add(new AmericanReplaceRule(messages, "/en/en-US/replace.txt"));
        rules.add(new BritishReplaceRule(messages, "/en/en-GB/replace.txt"));
        rules.add(new NewZealandReplaceRule(messages, "/en/en-NZ/replace.txt"));
        return rules;
    }

    public List<String> getRuleFileNames() {
        ArrayList<String> ruleFileNames = new ArrayList<String>(super.getRuleFileNames());
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dir = dataBroker.getRulesDir();
        for (String country : this.getCountries()) {
            String code = "en-" + country;
            ruleFileNames.add(dir + "/en/" + code + "/grammar.xml");
            if (!dataBroker.ruleFileExists("/en/" + code + "/style.xml")) continue;
            ruleFileNames.add(dir + "/en/" + code + "/style.xml");
        }
        ruleFileNames.add(dir + "/en/grammar-l2-de.xml");
        ruleFileNames.add(dir + "/en/grammar-l2-fr.xml");
        return ruleFileNames;
    }

    public boolean isVariant() {
        return true;
    }

    @NotNull
    public static English noChunkingEnglish() {
        GenericEnglish english = new GenericEnglish();
        english.setChunker((Chunker)new NoopChunker());
        return english;
    }
}

